/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.Arrays;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;

public final class FragmentedHandshakeMessage
extends HandshakeMessage {
    private final byte[] fragmentedBytes;
    private final HandshakeType type;
    private final int messageLength;
    private final int fragmentOffset;

    public FragmentedHandshakeMessage(HandshakeType type, int messageLength, int messageSeq, int fragmentOffset, byte[] fragmentedBytes) {
        this.type = type;
        this.messageLength = messageLength;
        this.fragmentedBytes = Arrays.copyOf(fragmentedBytes, fragmentedBytes.length);
        this.fragmentOffset = fragmentOffset;
        this.setMessageSeq(messageSeq);
    }

    @Override
    public HandshakeType getMessageType() {
        return this.type;
    }

    @Override
    public int getMessageLength() {
        return this.messageLength;
    }

    @Override
    public int getFragmentOffset() {
        return this.fragmentOffset;
    }

    @Override
    public int getFragmentLength() {
        return this.fragmentedBytes.length;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\tFragmented Handshake Protocol");
        sb.append(StringUtil.lineSeparator()).append("\tType: ").append((Object)this.getMessageType());
        sb.append(StringUtil.lineSeparator()).append("\tMessage Sequence No: ").append(this.getMessageSeq());
        sb.append(StringUtil.lineSeparator()).append("\tFragment Offset: ").append(this.getFragmentOffset());
        sb.append(StringUtil.lineSeparator()).append("\tFragment Length: ").append(this.getFragmentLength());
        sb.append(StringUtil.lineSeparator()).append("\tLength: ").append(this.getMessageLength());
        sb.append(StringUtil.lineSeparator());
        return sb.toString();
    }

    @Override
    public byte[] fragmentToByteArray() {
        return this.fragmentedBytes;
    }
}

