/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.ServerKeyExchange;

public final class PSKServerKeyExchange
extends ServerKeyExchange {
    private static final int IDENTITY_HINT_LENGTH_BITS = 16;
    private final PskPublicInformation hint;

    public PSKServerKeyExchange(PskPublicInformation hint) {
        this.hint = hint;
    }

    private PSKServerKeyExchange(byte[] hintEncoded) {
        this.hint = PskPublicInformation.fromByteArray(hintEncoded);
    }

    @Override
    public int getMessageLength() {
        return 2 + this.hint.length();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\t\tPSK Identity Hint: ").append(this.hint).append(StringUtil.lineSeparator());
        return sb.toString();
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter(this.hint.length() + 2);
        writer.writeVarBytes(this.hint, 16);
        return writer.toByteArray();
    }

    public static HandshakeMessage fromReader(DatagramReader reader) {
        byte[] hintEncoded = reader.readVarBytes(16);
        return new PSKServerKeyExchange(hintEncoded);
    }

    public PskPublicInformation getHint() {
        return this.hint;
    }
}

