/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.ECDHClientKeyExchange;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;

@NoPublicAPI
public final class EcdhPskClientKeyExchange
extends ECDHClientKeyExchange {
    private static final int IDENTITY_LENGTH_BITS = 16;
    private final PskPublicInformation identity;

    public EcdhPskClientKeyExchange(PskPublicInformation identity, byte[] encodedPoint) {
        super(encodedPoint);
        if (identity == null) {
            throw new NullPointerException("identity cannot be null");
        }
        this.identity = identity;
    }

    @Override
    protected void writeFragment(DatagramWriter writer) {
        writer.writeVarBytes(this.identity, 16);
        super.writeFragment(writer);
    }

    public static HandshakeMessage fromReader(DatagramReader reader) {
        byte[] identityEncoded = reader.readVarBytes(16);
        PskPublicInformation identity = PskPublicInformation.fromByteArray(identityEncoded);
        byte[] pointEncoded = EcdhPskClientKeyExchange.readEncodedPoint(reader);
        return new EcdhPskClientKeyExchange(identity, pointEncoded);
    }

    @Override
    public int getMessageLength() {
        return 2 + this.identity.length() + super.getMessageLength();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t\t Encoded identity value: ");
        sb.append(this.identity).append(StringUtil.lineSeparator());
        sb.append(super.toString());
        sb.append(StringUtil.lineSeparator());
        return sb.toString();
    }

    public PskPublicInformation getIdentity() {
        return this.identity;
    }
}

