/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.StringOutput;
import java.io.IOException;

final class Base64 {
    private static final String Base64URL = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
    private static final String Base64Classic = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    private Base64() {
    }

    public static void WriteBase64(StringOutput writer, byte[] data, int offset, int count, boolean padding) throws IOException {
        Base64.WriteBase64(writer, data, offset, count, true, padding);
    }

    public static void WriteBase64URL(StringOutput writer, byte[] data, int offset, int count, boolean padding) throws IOException {
        Base64.WriteBase64(writer, data, offset, count, false, padding);
    }

    private static void WriteBase64(StringOutput writer, byte[] data, int offset, int count, boolean classic, boolean padding) throws IOException {
        if (writer == null) {
            throw new NullPointerException("writer");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset (" + offset + ") is less than 0 ");
        }
        if (offset > data.length) {
            throw new IllegalArgumentException("offset (" + offset + ") is more than " + data.length);
        }
        if (count < 0) {
            throw new IllegalArgumentException("count (" + count + ") is less than 0 ");
        }
        if (count > data.length) {
            throw new IllegalArgumentException("count (" + count + ") is more than " + data.length);
        }
        if (data.length - offset < count) {
            throw new IllegalArgumentException("data's length minus " + offset + " (" + (data.length - offset) + ") is less than " + count);
        }
        String alphabet = classic ? Base64Classic : Base64URL;
        int length = offset + count;
        int i = offset;
        char[] buffer = new char[4];
        for (i = offset; i < length - 2; i += 3) {
            buffer[0] = alphabet.charAt(data[i] >> 2 & 0x3F);
            buffer[1] = alphabet.charAt(((data[i] & 3) << 4) + (data[i + 1] >> 4 & 0xF));
            buffer[2] = alphabet.charAt(((data[i + 1] & 0xF) << 2) + (data[i + 2] >> 6 & 3));
            buffer[3] = alphabet.charAt(data[i + 2] & 0x3F);
            writer.WriteCodePoint(buffer[0]);
            writer.WriteCodePoint(buffer[1]);
            writer.WriteCodePoint(buffer[2]);
            writer.WriteCodePoint(buffer[3]);
        }
        int lenmod3 = count % 3;
        if (lenmod3 != 0) {
            i = length - lenmod3;
            buffer[0] = alphabet.charAt(data[i] >> 2 & 0x3F);
            if (lenmod3 == 2) {
                buffer[1] = alphabet.charAt(((data[i] & 3) << 4) + (data[i + 1] >> 4 & 0xF));
                buffer[2] = alphabet.charAt((data[i + 1] & 0xF) << 2);
                writer.WriteCodePoint(buffer[0]);
                writer.WriteCodePoint(buffer[1]);
                writer.WriteCodePoint(buffer[2]);
                if (padding) {
                    writer.WriteCodePoint(61);
                }
            } else {
                buffer[1] = alphabet.charAt((data[i] & 3) << 4);
                writer.WriteCodePoint(buffer[0]);
                writer.WriteCodePoint(buffer[1]);
                if (padding) {
                    writer.WriteCodePoint(61);
                    writer.WriteCodePoint(61);
                }
            }
        }
    }
}

