/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.x509;

import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.util.CertPathUtil;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateVerificationResult;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.rpkstore.InMemoryRpkTrustStore;
import org.eclipse.californium.scandium.dtls.rpkstore.TrustAllRpks;
import org.eclipse.californium.scandium.dtls.rpkstore.TrustedRpkStore;
import org.eclipse.californium.scandium.dtls.x509.AdvancedCertificateVerifier;
import org.eclipse.californium.scandium.dtls.x509.CertificateVerifier;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.dtls.x509.StaticCertificateVerifier;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgeCertificateVerifier
implements NewAdvancedCertificateVerifier {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final CertificateVerifier x509verifier;
    private final TrustedRpkStore rpkVerifier;
    private final List<CertificateType> supportedCertificateTypes;

    protected BridgeCertificateVerifier(CertificateVerifier x509verifier, TrustedRpkStore rpkVerifier, List<CertificateType> supportedCertificateTypes) {
        if (x509verifier == null && rpkVerifier == null) {
            throw new IllegalArgumentException("no verifier provided!");
        }
        if (supportedCertificateTypes == null) {
            throw new NullPointerException("list of supported certificate types must not be null!");
        }
        this.x509verifier = x509verifier;
        this.rpkVerifier = rpkVerifier;
        this.supportedCertificateTypes = supportedCertificateTypes;
    }

    @Override
    public List<CertificateType> getSupportedCertificateType() {
        return this.supportedCertificateTypes;
    }

    @Override
    public CertificateVerificationResult verifyCertificate(ConnectionId cid, ServerNames serverName, Boolean clientUsage, boolean truncateCertificatePath, CertificateMessage message, DTLSSession session) {
        try {
            CertPath certChain = message.getCertificateChain();
            if (certChain == null) {
                if (this.rpkVerifier == null) {
                    AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, session.getPeer());
                    throw new HandshakeException("RPK verification not enabled!", alert);
                }
                PublicKey publicKey = message.getPublicKey();
                RawPublicKeyIdentity rpk = new RawPublicKeyIdentity(publicKey);
                if (!this.rpkVerifier.isTrusted(rpk)) {
                    this.LOGGER.debug("Certificate validation failed: Raw public key is not trusted");
                    AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, session.getPeer());
                    throw new HandshakeException("Raw public key is not trusted!", alert);
                }
                return new CertificateVerificationResult(cid, publicKey, null);
            }
            if (this.x509verifier == null) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, session.getPeer());
                throw new HandshakeException("x509 verification not enabled!", alert);
            }
            if (this.x509verifier instanceof AdvancedCertificateVerifier) {
                certChain = ((AdvancedCertificateVerifier)this.x509verifier).verifyCertificate(clientUsage, truncateCertificatePath, message, session);
            } else {
                Certificate certificate;
                if (clientUsage != null && !message.isEmpty() && (certificate = certChain.getCertificates().get(0)) instanceof X509Certificate && !CertPathUtil.canBeUsedForAuthentication((X509Certificate)certificate, clientUsage)) {
                    AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, session.getPeer());
                    throw new HandshakeException("Key Usage doesn't match!", alert);
                }
                this.x509verifier.verifyCertificate(message, session);
            }
            return new CertificateVerificationResult(cid, certChain, null);
        }
        catch (HandshakeException e) {
            this.LOGGER.debug("Certificate validation failed!", e);
            return new CertificateVerificationResult(cid, e, null);
        }
    }

    @Override
    public List<X500Principal> getAcceptedIssuers() {
        X509Certificate[] issuers = this.x509verifier.getAcceptedIssuers();
        if (issuers != null) {
            return CertPathUtil.toSubjects(Arrays.asList(issuers));
        }
        return CertPathUtil.toSubjects(null);
    }

    @Override
    public void setResultHandler(HandshakeResultHandler resultHandler) {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected CertificateVerifier x509verifier;
        protected TrustedRpkStore rpkVerifier;
        protected List<CertificateType> supportedCertificateTypes;

        public Builder setCertificateVerifier(CertificateVerifier x509verifier) {
            this.x509verifier = x509verifier;
            return this;
        }

        public Builder setTrustedCertificates(Certificate[] trustedCertificates) {
            if (trustedCertificates == null) {
                this.x509verifier = null;
            } else if (trustedCertificates.length == 0) {
                this.x509verifier = new StaticCertificateVerifier(new X509Certificate[0]);
            } else {
                X509Certificate[] certificates = SslContextUtil.asX509Certificates(trustedCertificates);
                SslContextUtil.ensureUniqueCertificates(certificates);
                this.x509verifier = new StaticCertificateVerifier(certificates);
            }
            return this;
        }

        public Builder setTrustAllCertificates() {
            this.x509verifier = new StaticCertificateVerifier(new X509Certificate[0]);
            return this;
        }

        public Builder setTrustedRPKs(TrustedRpkStore rpkVerifier) {
            this.rpkVerifier = rpkVerifier;
            return this;
        }

        public Builder setTrustedRPKs(Set<RawPublicKeyIdentity> trustedRPKs) {
            this.rpkVerifier = new InMemoryRpkTrustStore(trustedRPKs);
            return this;
        }

        public Builder setTrustAllRPKs() {
            this.rpkVerifier = new TrustAllRpks();
            return this;
        }

        public NewAdvancedCertificateVerifier build() {
            this.init();
            return new BridgeCertificateVerifier(this.x509verifier, this.rpkVerifier, this.supportedCertificateTypes);
        }

        protected void init() {
            ArrayList<CertificateType> supported = new ArrayList<CertificateType>();
            if (this.rpkVerifier != null) {
                supported.add(CertificateType.RAW_PUBLIC_KEY);
            }
            if (this.x509verifier != null) {
                supported.add(CertificateType.X_509);
            }
            this.supportedCertificateTypes = Collections.unmodifiableList(supported);
        }
    }
}

