/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseTimeout
extends MessageObserverAdapter
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseTimeout.class);
    private final AtomicReference<ScheduledFuture<?>> responseTimeout = new AtomicReference();
    private final Request request;
    private final ScheduledExecutorService executor;
    private final long timeout;

    public ResponseTimeout(Request request, long timeout, ScheduledExecutorService executor) {
        this.request = request;
        this.executor = executor;
        this.timeout = timeout;
    }

    private void scheduleTimeout() {
        ScheduledFuture<?> schedule = this.executor.schedule(this, this.timeout, TimeUnit.MILLISECONDS);
        ScheduledFuture<?> previous = this.responseTimeout.getAndSet(schedule);
        if (previous != null) {
            previous.cancel(false);
        }
    }

    private void cancelTimeout() {
        ScheduledFuture schedule = this.responseTimeout.getAndSet(null);
        if (schedule != null) {
            schedule.cancel(false);
        }
    }

    @Override
    public void onSent(boolean retransmission) {
        if (!retransmission && !this.request.isConfirmable()) {
            LOGGER.trace("start non-response timeout {}", (Object)this.timeout);
            this.scheduleTimeout();
        }
    }

    @Override
    public void onAcknowledgement() {
        if (this.request.isConfirmable()) {
            LOGGER.trace("start con-response timeout {}", (Object)this.timeout);
            this.scheduleTimeout();
        }
    }

    @Override
    public void onResponse(Response response) {
        this.cancelTimeout();
    }

    @Override
    protected void failed() {
        this.cancelTimeout();
    }

    @Override
    public void run() {
        LOGGER.trace("response timeout!");
        this.request.setTimedOut(true);
    }
}

