/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.ServerKeyExchange;

public final class PSKServerKeyExchange
extends ServerKeyExchange {
    private static final int IDENTITY_HINT_LENGTH_BITS = 16;
    private final PskPublicInformation hint;

    public PSKServerKeyExchange(PskPublicInformation hint, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.hint = hint;
    }

    private PSKServerKeyExchange(byte[] hintEncoded, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.hint = PskPublicInformation.fromByteArray(hintEncoded);
    }

    @Override
    public int getMessageLength() {
        return 2 + this.hint.length();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\t\tPSK Identity Hint: ").append(this.hint).append(StringUtil.lineSeparator());
        return sb.toString();
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.hint.length(), 16);
        writer.writeBytes(this.hint.getBytes());
        return writer.toByteArray();
    }

    public static HandshakeMessage fromReader(DatagramReader reader, InetSocketAddress peerAddress) {
        int length = reader.read(16);
        byte[] hintEncoded = reader.readBytes(length);
        return new PSKServerKeyExchange(hintEncoded, peerAddress);
    }

    public PskPublicInformation getHint() {
        return this.hint;
    }
}

