/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.EInteger;

final class FastInteger
implements Comparable<FastInteger> {
    private int smallValue;
    private MutableNumber mnum;
    private EInteger largeValue;
    private int integerMode;
    private boolean frozen;
    private static final EInteger ValueInt32MinValue = EInteger.FromInt64(Integer.MIN_VALUE);
    private static final EInteger ValueInt32MaxValue = EInteger.FromInt64(Integer.MAX_VALUE);
    private static final EInteger ValueNegativeInt32MinValue = ValueInt32MinValue.Negate();
    private static final String HexAlphabet = "0123456789ABCDEF";

    FastInteger(int value) {
        this.smallValue = value;
    }

    FastInteger Copy() {
        FastInteger fi = new FastInteger(this.smallValue);
        fi.integerMode = this.integerMode;
        fi.largeValue = this.largeValue;
        fi.mnum = this.mnum == null || this.integerMode != 1 ? null : this.mnum.Copy();
        return fi;
    }

    static FastInteger CopyFrozen(FastInteger value) {
        FastInteger fi = new FastInteger(value.smallValue);
        fi.integerMode = value.integerMode;
        fi.largeValue = value.largeValue;
        fi.mnum = value.mnum == null || value.integerMode != 1 ? null : value.mnum.Copy();
        fi.frozen = true;
        return fi;
    }

    static FastInteger FromBig(EInteger bigintVal) {
        if (bigintVal.CanFitInInt32()) {
            return new FastInteger(bigintVal.ToInt32Unchecked());
        }
        if (bigintVal.signum() > 0) {
            FastInteger fi = new FastInteger(0);
            fi.integerMode = 1;
            fi.mnum = MutableNumber.FromEInteger(bigintVal);
            return fi;
        }
        FastInteger fi = new FastInteger(0);
        fi.integerMode = 2;
        fi.largeValue = bigintVal;
        return fi;
    }

    int AsInt32() {
        switch (this.integerMode) {
            case 0: {
                return this.smallValue;
            }
            case 1: {
                return this.mnum.ToInt32();
            }
            case 2: {
                return this.largeValue.ToInt32Checked();
            }
        }
        throw new IllegalStateException();
    }

    private void CheckFrozen() {
    }

    @Override
    public int compareTo(FastInteger val) {
        switch (this.integerMode << 2 | val.integerMode) {
            case 0: {
                int vsv = val.smallValue;
                return this.smallValue == vsv ? 0 : (this.smallValue < vsv ? -1 : 1);
            }
            case 1: {
                return -val.mnum.CompareToInt(this.smallValue);
            }
            case 2: {
                return this.AsEInteger().compareTo(val.largeValue);
            }
            case 4: {
                return this.mnum.CompareToInt(val.smallValue);
            }
            case 5: {
                return this.mnum.compareTo(val.mnum);
            }
            case 6: {
                return this.AsEInteger().compareTo(val.largeValue);
            }
            case 8: 
            case 9: 
            case 10: {
                return this.largeValue.compareTo(val.AsEInteger());
            }
        }
        throw new IllegalStateException();
    }

    FastInteger Abs() {
        if (this.frozen) {
            throw new IllegalStateException();
        }
        switch (this.integerMode) {
            case 0: {
                if (this.smallValue == Integer.MIN_VALUE) {
                    return this.Negate();
                }
                this.smallValue = Math.abs(this.smallValue);
                return this;
            }
        }
        return this.signum() < 0 ? this.Negate() : this;
    }

    static int[] GetLastWords(EInteger bigint, int numWords32Bit) {
        return MutableNumber.FromEInteger(bigint).GetLastWordsInternal(numWords32Bit);
    }

    FastInteger SetInt(int val) {
        this.CheckFrozen();
        this.smallValue = val;
        this.integerMode = 0;
        return this;
    }

    FastInteger Multiply(int val) {
        this.CheckFrozen();
        if (val == 0) {
            this.smallValue = 0;
            this.integerMode = 0;
        } else {
            switch (this.integerMode) {
                case 0: {
                    long amult = (long)val * (long)this.smallValue;
                    if (amult > Integer.MAX_VALUE || amult < Integer.MIN_VALUE) {
                        boolean bpos;
                        boolean apos = (long)this.smallValue > 0L;
                        boolean bl = bpos = (long)val > 0L;
                        if (apos && bpos) {
                            this.integerMode = 1;
                            this.mnum = MutableNumber.FromLong(amult);
                            break;
                        }
                        this.integerMode = 2;
                        this.largeValue = EInteger.FromInt64(amult);
                        break;
                    }
                    this.smallValue = (int)amult;
                    break;
                }
                case 1: {
                    if (val < 0) {
                        this.integerMode = 2;
                        this.largeValue = this.mnum.ToEInteger();
                        this.largeValue = this.largeValue.Multiply(EInteger.FromInt32(val));
                        break;
                    }
                    this.mnum.Multiply(val);
                    break;
                }
                case 2: {
                    this.largeValue = this.largeValue.Multiply(EInteger.FromInt32(val));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this;
    }

    FastInteger Negate() {
        this.CheckFrozen();
        switch (this.integerMode) {
            case 0: {
                if (this.smallValue == Integer.MIN_VALUE) {
                    this.integerMode = 1;
                    this.mnum = MutableNumber.FromEInteger(ValueNegativeInt32MinValue);
                    break;
                }
                this.smallValue = -this.smallValue;
                break;
            }
            case 1: {
                this.integerMode = 2;
                this.largeValue = this.mnum.ToEInteger();
                this.largeValue = this.largeValue.Negate();
                break;
            }
            case 2: {
                this.largeValue = this.largeValue.Negate();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    FastInteger Subtract(FastInteger val) {
        this.CheckFrozen();
        switch (this.integerMode) {
            case 0: {
                if (val.integerMode == 0) {
                    int vsv = val.smallValue;
                    if (vsv < 0 && Integer.MAX_VALUE + vsv < this.smallValue || vsv > 0 && Integer.MIN_VALUE + vsv > this.smallValue) {
                        this.integerMode = 2;
                        this.largeValue = EInteger.FromInt32(this.smallValue);
                        this.largeValue = this.largeValue.Subtract(EInteger.FromInt32(vsv));
                        break;
                    }
                    this.smallValue -= vsv;
                    break;
                }
                this.integerMode = 2;
                this.largeValue = EInteger.FromInt32(this.smallValue);
                EInteger valValue = val.AsEInteger();
                this.largeValue = this.largeValue.Subtract(valValue);
                break;
            }
            case 1: {
                if (val.integerMode == 1) {
                    this.mnum.Subtract(val.mnum);
                    break;
                }
                if (val.integerMode == 0 && val.smallValue >= 0) {
                    this.mnum.SubtractInt(val.smallValue);
                    break;
                }
                this.integerMode = 2;
                this.largeValue = this.mnum.ToEInteger();
                EInteger valValue = val.AsEInteger();
                this.largeValue = this.largeValue.Subtract(valValue);
                break;
            }
            case 2: {
                EInteger valValue = val.AsEInteger();
                this.largeValue = this.largeValue.Subtract(valValue);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    FastInteger SubtractInt(int val) {
        this.CheckFrozen();
        if (val == Integer.MIN_VALUE) {
            return this.AddBig(ValueNegativeInt32MinValue);
        }
        if (this.integerMode == 0) {
            if (val < 0 && Integer.MAX_VALUE + val < this.smallValue || val > 0 && Integer.MIN_VALUE + val > this.smallValue) {
                this.integerMode = 2;
                this.largeValue = EInteger.FromInt32(this.smallValue);
                this.largeValue = this.largeValue.Subtract(EInteger.FromInt32(val));
            } else {
                this.smallValue -= val;
            }
            return this;
        }
        return this.AddInt(-val);
    }

    FastInteger AddBig(EInteger bigintVal) {
        this.CheckFrozen();
        switch (this.integerMode) {
            case 0: {
                return bigintVal.CanFitInInt32() ? this.AddInt(bigintVal.ToInt32Checked()) : this.Add(FastInteger.FromBig(bigintVal));
            }
            case 1: {
                this.integerMode = 2;
                this.largeValue = this.mnum.ToEInteger();
                this.largeValue = this.largeValue.Add(bigintVal);
                break;
            }
            case 2: {
                this.largeValue = this.largeValue.Add(bigintVal);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    FastInteger SubtractBig(EInteger bigintVal) {
        this.CheckFrozen();
        if (this.integerMode == 2) {
            this.largeValue = this.largeValue.Subtract(bigintVal);
            return this;
        }
        int sign = bigintVal.signum();
        if (sign == 0) {
            return this;
        }
        if (sign < 0 && bigintVal.compareTo(ValueInt32MinValue) > 0) {
            return this.AddInt(-bigintVal.ToInt32Checked());
        }
        if (sign > 0 && bigintVal.compareTo(ValueInt32MaxValue) <= 0) {
            return this.SubtractInt(bigintVal.ToInt32Checked());
        }
        bigintVal = bigintVal.Negate();
        return this.AddBig(bigintVal);
    }

    FastInteger Add(FastInteger val) {
        this.CheckFrozen();
        switch (this.integerMode) {
            case 0: {
                if (val.integerMode == 0) {
                    if (this.smallValue < 0 && val.smallValue < Integer.MIN_VALUE - this.smallValue || this.smallValue > 0 && val.smallValue > Integer.MAX_VALUE - this.smallValue) {
                        if (val.smallValue >= 0) {
                            this.integerMode = 1;
                            this.mnum = new MutableNumber(this.smallValue);
                            this.mnum.Add(val.smallValue);
                            break;
                        }
                        this.integerMode = 2;
                        this.largeValue = EInteger.FromInt32(this.smallValue);
                        this.largeValue = this.largeValue.Add(EInteger.FromInt64(val.smallValue));
                        break;
                    }
                    this.smallValue += val.smallValue;
                    break;
                }
                this.integerMode = 2;
                this.largeValue = EInteger.FromInt32(this.smallValue);
                EInteger valValue = val.AsEInteger();
                this.largeValue = this.largeValue.Add(valValue);
                break;
            }
            case 1: {
                if (val.integerMode == 0 && val.smallValue >= 0) {
                    this.mnum.Add(val.smallValue);
                    break;
                }
                this.integerMode = 2;
                this.largeValue = this.mnum.ToEInteger();
                EInteger valValue = val.AsEInteger();
                this.largeValue = this.largeValue.Add(valValue);
                break;
            }
            case 2: {
                EInteger valValue = val.AsEInteger();
                this.largeValue = this.largeValue.Add(valValue);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    FastInteger Remainder(int divisor) {
        block6: {
            block5: {
                this.CheckFrozen();
                if (divisor == 0) break block5;
                switch (this.integerMode) {
                    case 0: {
                        this.smallValue %= divisor;
                        break block6;
                    }
                    case 1: {
                        this.largeValue = this.mnum.ToEInteger();
                        this.largeValue = this.largeValue.Remainder(EInteger.FromInt64(divisor));
                        this.smallValue = this.largeValue.ToInt32Checked();
                        this.integerMode = 0;
                        break block6;
                    }
                    case 2: {
                        this.largeValue = this.largeValue.Remainder(EInteger.FromInt64(divisor));
                        this.smallValue = this.largeValue.ToInt32Checked();
                        this.integerMode = 0;
                        break block6;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            throw new ArithmeticException();
        }
        return this;
    }

    FastInteger Increment() {
        this.CheckFrozen();
        if (this.integerMode == 0) {
            if (this.smallValue != Integer.MAX_VALUE) {
                ++this.smallValue;
            } else {
                this.integerMode = 1;
                this.mnum = MutableNumber.FromEInteger(ValueNegativeInt32MinValue);
            }
            return this;
        }
        return this.AddInt(1);
    }

    FastInteger Decrement() {
        this.CheckFrozen();
        if (this.integerMode == 0) {
            if (this.smallValue != Integer.MIN_VALUE) {
                --this.smallValue;
            } else {
                this.integerMode = 1;
                this.mnum = MutableNumber.FromEInteger(ValueInt32MinValue);
                this.mnum.SubtractInt(1);
            }
            return this;
        }
        return this.SubtractInt(1);
    }

    FastInteger Divide(int divisor) {
        block10: {
            block9: {
                this.CheckFrozen();
                if (divisor == 0) break block9;
                switch (this.integerMode) {
                    case 0: {
                        if (divisor == -1 && this.smallValue == Integer.MIN_VALUE) {
                            this.integerMode = 1;
                            this.mnum = MutableNumber.FromEInteger(ValueNegativeInt32MinValue);
                        } else {
                            this.smallValue /= divisor;
                        }
                        break block10;
                    }
                    case 1: {
                        this.integerMode = 2;
                        this.largeValue = this.mnum.ToEInteger();
                        this.largeValue = this.largeValue.Divide(EInteger.FromInt64(divisor));
                        if (this.largeValue.isZero()) {
                            this.integerMode = 0;
                            this.smallValue = 0;
                        }
                        break block10;
                    }
                    case 2: {
                        this.largeValue = this.largeValue.Divide(EInteger.FromInt64(divisor));
                        if (this.largeValue.isZero()) {
                            this.integerMode = 0;
                            this.smallValue = 0;
                        }
                        break block10;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            throw new ArithmeticException();
        }
        return this;
    }

    EInteger ShiftEIntegerLeftByThis(EInteger ei) {
        switch (this.integerMode) {
            case 0: {
                return ei.ShiftLeft(this.smallValue);
            }
            case 1: {
                return ei.ShiftLeft(this.mnum.ToEInteger());
            }
            case 2: {
                return ei.ShiftLeft(this.largeValue);
            }
        }
        throw new IllegalStateException();
    }

    final boolean isEvenNumber() {
        switch (this.integerMode) {
            case 0: {
                return (this.smallValue & 1) == 0;
            }
            case 1: {
                return this.mnum.isEvenNumber();
            }
            case 2: {
                return this.largeValue.isEven();
            }
        }
        throw new IllegalStateException();
    }

    FastInteger AddInt(int val) {
        this.CheckFrozen();
        switch (this.integerMode) {
            case 0: {
                if (this.smallValue < 0 && val < Integer.MIN_VALUE - this.smallValue || this.smallValue > 0 && val > Integer.MAX_VALUE - this.smallValue) {
                    if (val >= 0) {
                        this.integerMode = 1;
                        this.mnum = new MutableNumber(this.smallValue);
                        this.mnum.Add(val);
                        break;
                    }
                    this.integerMode = 2;
                    this.largeValue = EInteger.FromInt32(this.smallValue);
                    this.largeValue = this.largeValue.Add(EInteger.FromInt32(val));
                    break;
                }
                this.smallValue += val;
                break;
            }
            case 1: {
                if (val >= 0) {
                    this.mnum.Add(val);
                    break;
                }
                this.integerMode = 2;
                this.largeValue = this.mnum.ToEInteger();
                EInteger valValue = EInteger.FromInt32(val);
                this.largeValue = this.largeValue.Add(valValue);
                break;
            }
            case 2: {
                EInteger valValue = EInteger.FromInt32(val);
                this.largeValue = this.largeValue.Add(valValue);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    boolean CanFitInInt32() {
        switch (this.integerMode) {
            case 0: {
                return true;
            }
            case 1: {
                return this.mnum.CanFitInInt32();
            }
            case 2: {
                return this.largeValue.CanFitInInt32();
            }
        }
        throw new IllegalStateException();
    }

    boolean CanFitInInt64() {
        switch (this.integerMode) {
            case 0: {
                return true;
            }
            case 1: {
                return this.AsEInteger().CanFitInInt64();
            }
            case 2: {
                return this.largeValue.CanFitInInt64();
            }
        }
        throw new IllegalStateException();
    }

    long AsInt64() {
        switch (this.integerMode) {
            case 0: {
                return this.smallValue;
            }
            case 1: {
                return this.AsEInteger().ToInt64Unchecked();
            }
            case 2: {
                return this.largeValue.ToInt64Unchecked();
            }
        }
        throw new IllegalStateException();
    }

    static String IntToString(int value) {
        char digit;
        int intdivvalue;
        if (value == Integer.MIN_VALUE) {
            return "-2147483648";
        }
        if (value == 0) {
            return "0";
        }
        boolean neg = value < 0;
        char[] chars = new char[12];
        int count = 11;
        if (neg) {
            value = -value;
        }
        while (value > 43698) {
            intdivvalue = value / 10;
            digit = HexAlphabet.charAt(value - intdivvalue * 10);
            chars[count--] = digit;
            value = intdivvalue;
        }
        while (value > 9) {
            intdivvalue = value * 26215 >> 18;
            digit = HexAlphabet.charAt(value - intdivvalue * 10);
            chars[count--] = digit;
            value = intdivvalue;
        }
        if (value != 0) {
            chars[count--] = HexAlphabet.charAt(value);
        }
        if (neg) {
            chars[count] = 45;
        } else {
            ++count;
        }
        return new String(chars, count, 12 - count);
    }

    public String toString() {
        switch (this.integerMode) {
            case 0: {
                return FastInteger.IntToString(this.smallValue);
            }
            case 1: {
                return this.mnum.ToEInteger().toString();
            }
            case 2: {
                return this.largeValue.toString();
            }
        }
        return "";
    }

    final int signum() {
        switch (this.integerMode) {
            case 0: {
                return this.smallValue == 0 ? 0 : (this.smallValue < 0 ? -1 : 1);
            }
            case 1: {
                return this.mnum.signum();
            }
            case 2: {
                return this.largeValue.signum();
            }
        }
        return 0;
    }

    final boolean isValueZero() {
        switch (this.integerMode) {
            case 0: {
                return this.smallValue == 0;
            }
            case 1: {
                return this.mnum.signum() == 0;
            }
            case 2: {
                return this.largeValue.isZero();
            }
        }
        return false;
    }

    int CompareToInt(int val) {
        switch (this.integerMode) {
            case 0: {
                return val == this.smallValue ? 0 : (this.smallValue < val ? -1 : 1);
            }
            case 1: {
                return this.mnum.ToEInteger().compareTo(EInteger.FromInt32(val));
            }
            case 2: {
                return this.largeValue.compareTo(EInteger.FromInt32(val));
            }
        }
        return 0;
    }

    EInteger AsEInteger() {
        switch (this.integerMode) {
            case 0: {
                return EInteger.FromInt32(this.smallValue);
            }
            case 1: {
                return this.mnum.ToEInteger();
            }
            case 2: {
                return this.largeValue;
            }
        }
        throw new IllegalStateException();
    }

    private static final class MutableNumber {
        private int[] data;
        private int wordCount;

        static MutableNumber FromEInteger(EInteger bigintVal) {
            MutableNumber mnum = new MutableNumber(0);
            if (bigintVal.signum() < 0) {
                throw new IllegalArgumentException("bigintVal's sign (" + bigintVal.signum() + ") is less than 0 ");
            }
            byte[] bytes = bigintVal.ToBytes(true);
            int len = bytes.length;
            int newWordCount = Math.max(4, len / 4 + 1);
            if (newWordCount > mnum.data.length) {
                mnum.data = new int[newWordCount];
            }
            mnum.wordCount = newWordCount;
            for (int i = 0; i < len; i += 4) {
                int x = bytes[i] & 0xFF;
                if (i + 1 < len) {
                    x |= (bytes[i + 1] & 0xFF) << 8;
                }
                if (i + 2 < len) {
                    x |= (bytes[i + 2] & 0xFF) << 16;
                }
                if (i + 3 < len) {
                    x |= (bytes[i + 3] & 0xFF) << 24;
                }
                mnum.data[i >> 2] = x;
            }
            while (mnum.wordCount != 0 && mnum.data[mnum.wordCount - 1] == 0) {
                --mnum.wordCount;
            }
            return mnum;
        }

        MutableNumber(int val) {
            if (val < 0) {
                throw new IllegalArgumentException("val (" + val + ") is less than 0 ");
            }
            this.data = new int[4];
            this.wordCount = val == 0 ? 0 : 1;
            this.data[0] = val;
        }

        MutableNumber SetInt(int val) {
            if (val < 0) {
                throw new IllegalArgumentException("val (" + val + ") is less than 0 ");
            }
            this.wordCount = val == 0 ? 0 : 1;
            this.data[0] = val;
            return this;
        }

        EInteger ToEInteger() {
            if (this.wordCount == 1 && this.data[0] >> 31 == 0) {
                return EInteger.FromInt64(this.data[0]);
            }
            if (this.wordCount == 2 && this.data[1] >> 31 == 0) {
                long longV = this.data[0];
                longV &= 0xFFFFFFFFL;
                return EInteger.FromInt64(longV |= (long)this.data[1] << 32);
            }
            return EInteger.FromInts(this.data, this.wordCount);
        }

        int[] GetLastWordsInternal(int numWords32Bit) {
            int[] ret = new int[numWords32Bit];
            System.arraycopy(this.data, 0, ret, 0, Math.min(numWords32Bit, this.wordCount));
            return ret;
        }

        boolean CanFitInInt32() {
            return this.wordCount == 0 || this.wordCount == 1 && this.data[0] >> 31 == 0;
        }

        int ToInt32() {
            return this.wordCount == 0 ? 0 : this.data[0];
        }

        public static MutableNumber FromLong(long longVal) {
            int mbd;
            if (longVal < 0L) {
                throw new IllegalArgumentException();
            }
            if (longVal == 0L) {
                return new MutableNumber(0);
            }
            MutableNumber mbi = new MutableNumber(0);
            mbi.data[0] = (int)longVal;
            mbi.data[1] = mbd = (int)(longVal >> 32);
            mbi.wordCount = mbd == 0 ? 1 : 2;
            return mbi;
        }

        MutableNumber Copy() {
            MutableNumber mbi = new MutableNumber(0);
            if (this.wordCount > mbi.data.length) {
                mbi.data = new int[this.wordCount];
            }
            System.arraycopy(this.data, 0, mbi.data, 0, this.wordCount);
            mbi.wordCount = this.wordCount;
            return mbi;
        }

        MutableNumber Multiply(int multiplicand) {
            if (multiplicand < 0) {
                throw new IllegalArgumentException("multiplicand (" + multiplicand + ") is less than 0 ");
            }
            if (multiplicand != 0) {
                int result3;
                int result2;
                int result0;
                int result1;
                int y0;
                int x1;
                int x0;
                int carry = 0;
                if (this.wordCount == 0) {
                    if (this.data.length == 0) {
                        this.data = new int[4];
                    }
                    this.data[0] = 0;
                    this.wordCount = 1;
                }
                if (multiplicand < 65536) {
                    if (this.wordCount == 2 && this.data[1] >> 16 == 0) {
                        long longV = this.data[0];
                        longV &= 0xFFFFFFFFL;
                        longV |= (long)this.data[1] << 32;
                        this.data[0] = (int)(longV *= (long)multiplicand);
                        this.data[1] = (int)(longV >> 32);
                        carry = 0;
                    } else if (this.wordCount == 1) {
                        long longV = this.data[0];
                        longV &= 0xFFFFFFFFL;
                        this.data[0] = (int)(longV *= (long)multiplicand);
                        carry = (int)(longV >> 32);
                    } else {
                        for (int i = 0; i < this.wordCount; ++i) {
                            x1 = x0 = this.data[i];
                            y0 = multiplicand;
                            x1 = x1 >> 16 & 0xFFFF;
                            int temp = (x0 &= 0xFFFF) * y0;
                            result1 = temp >> 16 & 0xFFFF;
                            result0 = temp & 0xFFFF;
                            result2 = 0;
                            temp = x1 * y0;
                            result2 += temp >> 16 & 0xFFFF;
                            result3 = (result2 += (result1 += temp & 0xFFFF) >> 16 & 0xFFFF) >> 16 & 0xFFFF;
                            x0 = result0 | (result1 &= 0xFFFF) << 16;
                            x1 = (result2 &= 0xFFFF) | result3 << 16;
                            int x2 = x0 + carry;
                            if (x2 >> 31 == x0 >> 31 ? (x2 & Integer.MAX_VALUE) < (x0 & Integer.MAX_VALUE) : x2 >> 31 == 0) {
                                // empty if block
                            }
                            this.data[i] = x2;
                            carry = ++x1;
                        }
                    }
                } else if (this.wordCount == 1) {
                    long longV = this.data[0];
                    longV &= 0xFFFFFFFFL;
                    this.data[0] = (int)(longV *= (long)multiplicand);
                    carry = (int)(longV >> 32);
                } else {
                    for (int i = 0; i < this.wordCount; ++i) {
                        x1 = x0 = this.data[i];
                        int y1 = y0 = multiplicand;
                        x1 = x1 >> 16 & 0xFFFF;
                        y1 = y1 >> 16 & 0xFFFF;
                        int temp = (x0 &= 0xFFFF) * (y0 &= 0xFFFF);
                        result1 = temp >> 16 & 0xFFFF;
                        result0 = temp & 0xFFFF;
                        temp = x0 * y1;
                        result2 = temp >> 16 & 0xFFFF;
                        result2 += (result1 += temp & 0xFFFF) >> 16 & 0xFFFF;
                        result1 &= 0xFFFF;
                        temp = x1 * y0;
                        result2 += temp >> 16 & 0xFFFF;
                        result3 = (result2 += (result1 += temp & 0xFFFF) >> 16 & 0xFFFF) >> 16 & 0xFFFF;
                        result2 &= 0xFFFF;
                        temp = x1 * y1;
                        result3 += temp >> 16 & 0xFFFF;
                        x0 = result0 | (result1 &= 0xFFFF) << 16;
                        x1 = (result2 &= 0xFFFF) | (result3 += (result2 += temp & 0xFFFF) >> 16 & 0xFFFF) << 16;
                        int x2 = x0 + carry;
                        if (x2 >> 31 == x0 >> 31 ? (x2 & Integer.MAX_VALUE) < (x0 & Integer.MAX_VALUE) : x2 >> 31 == 0) {
                            // empty if block
                        }
                        this.data[i] = x2;
                        carry = ++x1;
                    }
                }
                if (carry != 0) {
                    if (this.wordCount >= this.data.length) {
                        int[] newdata = new int[this.wordCount + 20];
                        System.arraycopy(this.data, 0, newdata, 0, this.data.length);
                        this.data = newdata;
                    }
                    this.data[this.wordCount] = carry;
                    ++this.wordCount;
                }
                while (this.wordCount != 0 && this.data[this.wordCount - 1] == 0) {
                    --this.wordCount;
                }
            } else {
                if (this.data.length > 0) {
                    this.data[0] = 0;
                }
                this.wordCount = 0;
            }
            return this;
        }

        final int signum() {
            return this.wordCount == 0 ? 0 : 1;
        }

        final boolean isEvenNumber() {
            return this.wordCount == 0 || (this.data[0] & 1) == 0;
        }

        int CompareToInt(int val) {
            if (val < 0 || this.wordCount > 1) {
                return 1;
            }
            if (this.wordCount == 0) {
                return val == 0 ? 0 : -1;
            }
            if (this.data[0] == val) {
                return 0;
            }
            return (this.data[0] >> 31 == val >> 31 ? (this.data[0] & Integer.MAX_VALUE) < (val & Integer.MAX_VALUE) : this.data[0] >> 31 == 0) ? -1 : 1;
        }

        /*
         * Unable to fully structure code
         */
        MutableNumber SubtractInt(int other) {
            block8: {
                if (other < 0) {
                    throw new IllegalArgumentException("other (" + other + ") is less than 0 ");
                }
                if (other == 0) break block8;
                if (this.wordCount == 0) {
                    if (this.data.length == 0) {
                        this.data = new int[4];
                    }
                    this.data[0] = 0;
                    this.wordCount = 1;
                }
                if ((a = this.data[0]) >> 31 != (u = a - other) >> 31 ? a >> 31 == 0 : (a & 0x7FFFFFFF) < (u & 0x7FFFFFFF)) ** GOTO lbl-1000
                if (a == u && other != 0) lbl-1000:
                // 2 sources

                {
                    v0 = 1;
                } else {
                    v0 = 0;
                }
                borrow = v0;
                this.data[0] = u;
                if (borrow != 0) {
                    for (i = 1; i < this.wordCount; ++i) {
                        u = this.data[i] - borrow;
                        borrow = (this.data[i] >> 31 == u >> 31 ? (this.data[i] & 0x7FFFFFFF) < (u & 0x7FFFFFFF) : this.data[i] >> 31 == 0) ? 1 : 0;
                        this.data[i] = u;
                    }
                }
                while (this.wordCount != 0 && this.data[this.wordCount - 1] == 0) {
                    --this.wordCount;
                }
            }
            return this;
        }

        /*
         * Unable to fully structure code
         */
        MutableNumber Subtract(MutableNumber other) {
            block8: {
                v0 = neededSize = this.wordCount > other.wordCount ? this.wordCount : other.wordCount;
                if (this.data.length < neededSize) {
                    newdata = new int[neededSize + 20];
                    System.arraycopy(this.data, 0, newdata, 0, this.data.length);
                    this.data = newdata;
                }
                neededSize = this.wordCount < other.wordCount ? this.wordCount : other.wordCount;
                u = 0;
                borrow = 0;
                for (i = 0; i < neededSize; ++i) {
                    a = this.data[i];
                    u = a - other.data[i] - borrow;
                    if (a >> 31 != u >> 31 ? a >> 31 == 0 : (a & 0x7FFFFFFF) < (u & 0x7FFFFFFF)) ** GOTO lbl-1000
                    if (a == u && other.data[i] != 0) lbl-1000:
                    // 2 sources

                    {
                        v1 = 1;
                    } else {
                        v1 = 0;
                    }
                    borrow = v1;
                    this.data[i] = u;
                }
                if (borrow == 0) break block8;
                for (i = neededSize; i < this.wordCount; ++i) {
                    a = this.data[i];
                    u = a - other.data[i] - borrow;
                    if (a >> 31 != u >> 31 ? a >> 31 == 0 : (a & 0x7FFFFFFF) < (u & 0x7FFFFFFF)) ** GOTO lbl-1000
                    if (a == u && other.data[i] != 0) lbl-1000:
                    // 2 sources

                    {
                        v2 = 1;
                    } else {
                        v2 = 0;
                    }
                    borrow = v2;
                    this.data[i] = u;
                }
            }
            while (this.wordCount != 0 && this.data[this.wordCount - 1] == 0) {
                --this.wordCount;
            }
            return this;
        }

        public int compareTo(MutableNumber other) {
            if (this.wordCount != other.wordCount) {
                return this.wordCount < other.wordCount ? -1 : 1;
            }
            int valueN = this.wordCount;
            while (valueN-- != 0) {
                int an = this.data[valueN];
                int bn = other.data[valueN];
                if (an >> 31 == bn >> 31 ? (an & Integer.MAX_VALUE) < (bn & Integer.MAX_VALUE) : an >> 31 == 0) {
                    return -1;
                }
                if (an == bn) continue;
                return 1;
            }
            return 0;
        }

        /*
         * Unable to fully structure code
         */
        MutableNumber Add(int augend) {
            block10: {
                if (augend < 0) {
                    throw new IllegalArgumentException("augend (" + augend + ") is less than 0 ");
                }
                if (augend == 0) break block10;
                carry = 0;
                if (this.wordCount == 0) {
                    if (this.data.length == 0) {
                        this.data = new int[4];
                    }
                    this.data[0] = 0;
                    this.wordCount = 1;
                }
                for (i = 0; i < this.wordCount; ++i) {
                    a = this.data[i];
                    u = a + augend + carry;
                    if (u >> 31 != a >> 31 ? u >> 31 == 0 : (u & 0x7FFFFFFF) < (a & 0x7FFFFFFF)) ** GOTO lbl-1000
                    if (u == a && augend != 0) lbl-1000:
                    // 2 sources

                    {
                        v0 = 1;
                    } else {
                        v0 = 0;
                    }
                    carry = v0;
                    this.data[i] = u;
                    if (carry == 0) {
                        return this;
                    }
                    augend = 0;
                }
                if (carry != 0) {
                    if (this.wordCount >= this.data.length) {
                        newdata = new int[this.wordCount + 20];
                        System.arraycopy(this.data, 0, newdata, 0, this.data.length);
                        this.data = newdata;
                    }
                    this.data[this.wordCount] = carry;
                    ++this.wordCount;
                }
            }
            while (this.wordCount != 0 && this.data[this.wordCount - 1] == 0) {
                --this.wordCount;
            }
            return this;
        }
    }
}

