/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.ICharacterInput;
import java.io.IOException;
import java.io.InputStream;

final class CharacterReader
implements ICharacterInput {
    private final int mode;
    private final boolean errorThrow;
    private final boolean dontSkipUtf8Bom;
    private final String str;
    private final int strLength;
    private final IByteReader stream;
    private int offset;
    private ICharacterInput reader;

    public CharacterReader(String str) {
        this(str, false, false);
    }

    public CharacterReader(String str, boolean skipByteOrderMark) {
        this(str, skipByteOrderMark, false);
    }

    public CharacterReader(String str, boolean skipByteOrderMark, boolean errorThrow) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        this.strLength = str.length();
        this.offset = skipByteOrderMark && this.strLength > 0 && str.charAt(0) == '\ufeff' ? 1 : 0;
        this.str = str;
        this.errorThrow = errorThrow;
        this.mode = -1;
        this.dontSkipUtf8Bom = false;
        this.stream = null;
    }

    public CharacterReader(String str, int offset, int length) {
        this(str, offset, length, false, false);
    }

    public CharacterReader(String str, int offset, int length, boolean skipByteOrderMark, boolean errorThrow) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset (" + offset + ") is less than 0");
        }
        if (offset > str.length()) {
            throw new IllegalArgumentException("offset (" + offset + ") is more than " + str.length());
        }
        if (length < 0) {
            throw new IllegalArgumentException("length (" + length + ") is less than 0");
        }
        if (length > str.length()) {
            throw new IllegalArgumentException("length (" + length + ") is more than " + str.length());
        }
        if (str.length() - offset < length) {
            throw new IllegalArgumentException("str's length minus " + offset + " (" + (str.length() - offset) + ") is less than " + length);
        }
        this.strLength = length;
        this.offset = skipByteOrderMark && length > 0 && str.charAt(offset) == '\ufeff' ? offset + 1 : 0;
        this.str = str;
        this.errorThrow = errorThrow;
        this.mode = -1;
        this.dontSkipUtf8Bom = false;
        this.stream = null;
    }

    public CharacterReader(InputStream stream) {
        this(stream, 0, false);
    }

    public CharacterReader(InputStream stream, int mode, boolean errorThrow) {
        this(stream, mode, errorThrow, false);
    }

    public CharacterReader(InputStream stream, int mode) {
        this(stream, mode, false, false);
    }

    public CharacterReader(InputStream stream, int mode, boolean errorThrow, boolean dontSkipUtf8Bom) {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        this.stream = new WrappedStream(stream);
        this.mode = mode;
        this.errorThrow = errorThrow;
        this.dontSkipUtf8Bom = dontSkipUtf8Bom;
        this.str = "";
        this.strLength = -1;
    }

    @Override
    public int Read(int[] chars, int index, int length) {
        if (chars == null) {
            throw new NullPointerException("chars");
        }
        if (index < 0) {
            throw new IllegalArgumentException("index (" + index + ") is less than 0");
        }
        if (index > chars.length) {
            throw new IllegalArgumentException("index (" + index + ") is more than " + chars.length);
        }
        if (length < 0) {
            throw new IllegalArgumentException("length (" + length + ") is less than 0");
        }
        if (length > chars.length) {
            throw new IllegalArgumentException("length (" + length + ") is more than " + chars.length);
        }
        if (chars.length - index < length) {
            throw new IllegalArgumentException("chars's length minus " + index + " (" + (chars.length - index) + ") is less than " + length);
        }
        int count = 0;
        for (int i = 0; i < length; ++i) {
            int c = this.ReadChar();
            if (c < 0) {
                return count;
            }
            chars[index + i] = c;
            ++count;
        }
        return count;
    }

    @Override
    public int ReadChar() {
        int c;
        if (this.reader != null) {
            return this.reader.ReadChar();
        }
        if (this.stream != null) {
            return this.DetectUnicodeEncoding();
        }
        int n = c = this.offset < this.strLength ? (int)this.str.charAt(this.offset) : -1;
        if ((c & 0xFC00) == 55296 && this.offset + 1 < this.strLength && this.str.charAt(this.offset + 1) >= '\udc00' && this.str.charAt(this.offset + 1) <= '\udfff') {
            c = 65536 + ((c & 0x3FF) << 10) + (this.str.charAt(this.offset + 1) & 0x3FF);
            ++this.offset;
        } else if ((c & 0xF800) == 55296) {
            if (this.errorThrow) {
                throw new IllegalStateException("Unpaired surrogate code point");
            }
            c = 65533;
        }
        ++this.offset;
        return c;
    }

    private int DetectUtf8Or16Or32(int c1) {
        if (c1 == 255 || c1 == 254) {
            int otherbyte;
            int c2 = this.stream.read();
            boolean bigEndian = c1 == 254;
            int n = otherbyte = bigEndian ? 255 : 254;
            if (c2 == otherbyte) {
                int c3 = this.stream.read();
                int c4 = this.stream.read();
                if (!bigEndian && c3 == 0 && c4 == 0) {
                    this.reader = new Utf32Reader(this.stream, false, this.errorThrow);
                    return this.reader.ReadChar();
                }
                Utf16Reader newReader = new Utf16Reader(this.stream, bigEndian, this.errorThrow);
                newReader.Unget(c3, c4);
                this.reader = newReader;
                return newReader.ReadChar();
            }
            if (this.errorThrow) {
                throw new IllegalStateException("Invalid Unicode stream");
            }
            Utf8Reader utf8reader = new Utf8Reader(this.stream, this.errorThrow);
            utf8reader.Unget(c2);
            this.reader = utf8reader;
            return 65533;
        }
        if (c1 == 0 && this.mode == 4) {
            int c2 = this.stream.read();
            int c3 = this.stream.read();
            int c4 = this.stream.read();
            if (c2 == 0 && (c3 == 254 && c4 == 255 || c3 == 0 && c4 >= 1 && c4 <= 127)) {
                this.reader = new Utf32Reader(this.stream, true, this.errorThrow);
                return c3 == 0 ? c4 : this.reader.ReadChar();
            }
            Utf8Reader utf8reader = new Utf8Reader(this.stream, this.errorThrow);
            utf8reader.UngetThree(c2, c3, c4);
            this.reader = utf8reader;
            return c1;
        }
        if (this.mode == 2) {
            if (c1 >= 1 && c1 <= 127) {
                int c2 = this.stream.read();
                if (c2 == 0) {
                    int c3 = this.stream.read();
                    int c4 = this.stream.read();
                    if (c3 == 0 && c4 == 0) {
                        this.reader = new Utf32Reader(this.stream, false, this.errorThrow);
                        return c1;
                    }
                    Utf16Reader newReader = new Utf16Reader(this.stream, false, this.errorThrow);
                    newReader.Unget(c3, c4);
                    this.reader = newReader;
                    return c1;
                }
                Utf8Reader utf8reader = new Utf8Reader(this.stream, this.errorThrow);
                utf8reader.Unget(c2);
                this.reader = utf8reader;
                return c1;
            }
            if (c1 == 0) {
                int c2 = this.stream.read();
                if (c2 >= 1 && c2 <= 127) {
                    Utf16Reader newReader = new Utf16Reader(this.stream, true, this.errorThrow);
                    this.reader = newReader;
                    return c2;
                }
                if (c2 == 0) {
                    int c3 = this.stream.read();
                    int c4 = this.stream.read();
                    if (c3 == 0 && c4 >= 1 && c4 <= 127) {
                        this.reader = new Utf32Reader(this.stream, true, this.errorThrow);
                        return c4;
                    }
                    if (c3 == 254 && c4 == 255) {
                        this.reader = new Utf32Reader(this.stream, true, this.errorThrow);
                        return this.reader.ReadChar();
                    }
                    Utf8Reader newReader = new Utf8Reader(this.stream, this.errorThrow);
                    newReader.UngetThree(c2, c3, c4);
                    this.reader = newReader;
                    return c1;
                }
                Utf8Reader utf8reader = new Utf8Reader(this.stream, this.errorThrow);
                utf8reader.Unget(c2);
                this.reader = utf8reader;
                return c1;
            }
        }
        return -2;
    }

    private int DetectUtf8OrUtf16(int c1) {
        int mode = this.mode;
        if (c1 == 255 || c1 == 254) {
            int otherbyte;
            int c2 = this.stream.read();
            boolean bigEndian = c1 == 254;
            int n = otherbyte = bigEndian ? 255 : 254;
            if (c2 == otherbyte) {
                Utf16Reader newReader = new Utf16Reader(this.stream, bigEndian, this.errorThrow);
                this.reader = newReader;
                return newReader.ReadChar();
            }
            if (this.errorThrow) {
                throw new IllegalStateException("Invalid Unicode stream");
            }
            Utf8Reader utf8reader = new Utf8Reader(this.stream, this.errorThrow);
            utf8reader.Unget(c2);
            this.reader = utf8reader;
            return 65533;
        }
        if (mode == 1) {
            if (c1 >= 1 && c1 <= 127) {
                int c2 = this.stream.read();
                if (c2 == 0) {
                    Utf16Reader newReader = new Utf16Reader(this.stream, false, this.errorThrow);
                    this.reader = newReader;
                } else {
                    Utf8Reader utf8reader = new Utf8Reader(this.stream, this.errorThrow);
                    utf8reader.Unget(c2);
                    this.reader = utf8reader;
                }
                return c1;
            }
            if (c1 == 0) {
                int c2 = this.stream.read();
                if (c2 >= 1 && c2 <= 127) {
                    Utf16Reader newReader = new Utf16Reader(this.stream, true, this.errorThrow);
                    this.reader = newReader;
                    return c2;
                }
                Utf8Reader utf8reader = new Utf8Reader(this.stream, this.errorThrow);
                utf8reader.Unget(c2);
                this.reader = utf8reader;
                return c1;
            }
        }
        return -2;
    }

    private int DetectUnicodeEncoding() {
        int mode = this.mode;
        int c1 = this.stream.read();
        if (c1 < 0) {
            return -1;
        }
        switch (mode) {
            case 0: {
                Utf8Reader utf8reader = new Utf8Reader(this.stream, this.errorThrow);
                this.reader = utf8reader;
                c1 = utf8reader.ReadChar();
                if (c1 == 65279) {
                    c1 = utf8reader.ReadChar();
                }
                return c1;
            }
            case 1: 
            case 3: {
                int c2 = this.DetectUtf8OrUtf16(c1);
                if (c2 < -1) break;
                return c2;
            }
            case 2: 
            case 4: {
                int c2 = this.DetectUtf8Or16Or32(c1);
                if (c2 < -1) break;
                return c2;
            }
        }
        Utf8Reader utf8reader = new Utf8Reader(this.stream, this.errorThrow);
        this.reader = utf8reader;
        utf8reader.Unget(c1);
        c1 = utf8reader.ReadChar();
        if (!this.dontSkipUtf8Bom && c1 == 65279) {
            c1 = utf8reader.ReadChar();
        }
        return c1;
    }

    private static final class WrappedStream
    implements IByteReader {
        private final InputStream stream;

        public WrappedStream(InputStream stream) {
            this.stream = stream;
        }

        @Override
        public int read() {
            try {
                return this.stream.read();
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
    }

    private static final class Utf8Reader
    implements ICharacterInput {
        private final IByteReader stream;
        private final SavedState state;
        private final boolean errorThrow;
        private int lastChar;

        public Utf8Reader(IByteReader stream, boolean errorThrow) {
            this.stream = stream;
            this.lastChar = -1;
            this.state = new SavedState();
            this.errorThrow = errorThrow;
        }

        public void Unget(int ch) {
            this.state.AddOne(ch);
        }

        public void UngetThree(int a, int b, int c) {
            this.state.AddThree(a, b, c);
        }

        @Override
        public int ReadChar() {
            int cp = 0;
            int bytesSeen = 0;
            int bytesNeeded = 0;
            int lower = 0;
            int upper = 0;
            while (true) {
                int b;
                if (this.lastChar != -1) {
                    b = this.lastChar;
                    this.lastChar = -1;
                } else {
                    b = this.state.Read(this.stream);
                }
                if (b < 0) {
                    if (bytesNeeded != 0) {
                        bytesNeeded = 0;
                        if (this.errorThrow) {
                            throw new IllegalStateException("Invalid UTF-8");
                        }
                        return 65533;
                    }
                    return -1;
                }
                if (bytesNeeded == 0) {
                    if ((b & 0x7F) == b) {
                        return b;
                    }
                    if (b >= 194 && b <= 223) {
                        bytesNeeded = 1;
                        lower = 128;
                        upper = 191;
                        cp = b - 192 << 6;
                        continue;
                    }
                    if (b >= 224 && b <= 239) {
                        lower = b == 224 ? 160 : 128;
                        upper = b == 237 ? 159 : 191;
                        bytesNeeded = 2;
                        cp = b - 224 << 12;
                        continue;
                    }
                    if (b >= 240 && b <= 244) {
                        lower = b == 240 ? 144 : 128;
                        upper = b == 244 ? 143 : 191;
                        bytesNeeded = 3;
                        cp = b - 240 << 18;
                        continue;
                    }
                    if (this.errorThrow) {
                        throw new IllegalStateException("Invalid UTF-8");
                    }
                    return 65533;
                }
                if (b < lower || b > upper) {
                    bytesSeen = 0;
                    bytesNeeded = 0;
                    cp = 0;
                    this.state.AddOne(b);
                    if (this.errorThrow) {
                        throw new IllegalStateException("Invalid UTF-8");
                    }
                    return 65533;
                }
                lower = 128;
                upper = 191;
                cp += b - 128 << 6 * (bytesNeeded - ++bytesSeen);
                if (bytesSeen == bytesNeeded) break;
            }
            int ret = cp;
            cp = 0;
            bytesSeen = 0;
            bytesNeeded = 0;
            return ret;
        }

        @Override
        public int Read(int[] chars, int index, int length) {
            int count = 0;
            for (int i = 0; i < length; ++i) {
                int c = this.ReadChar();
                if (c < 0) {
                    return count;
                }
                chars[index + i] = c;
                ++count;
            }
            return count;
        }
    }

    private static final class Utf32Reader
    implements ICharacterInput {
        private final boolean bigEndian;
        private final IByteReader stream;
        private final boolean errorThrow;
        private final SavedState state;

        public Utf32Reader(IByteReader stream, boolean bigEndian, boolean errorThrow) {
            this.stream = stream;
            this.bigEndian = bigEndian;
            this.state = new SavedState();
            this.errorThrow = errorThrow;
        }

        @Override
        public int ReadChar() {
            int c1 = this.state.Read(this.stream);
            if (c1 < 0) {
                return -1;
            }
            int c2 = this.state.Read(this.stream);
            int c3 = this.state.Read(this.stream);
            int c4 = this.state.Read(this.stream);
            if (c2 < 0 || c3 < 0 || c4 < 0) {
                this.state.AddOne(-1);
                if (this.errorThrow) {
                    throw new IllegalStateException("Invalid UTF-32");
                }
                return 65533;
            }
            int n = c1 = this.bigEndian ? c1 << 24 | c2 << 16 | c3 << 8 | c4 : c4 << 24 | c3 << 16 | c2 << 8 | c1;
            if (c1 < 0 || c1 >= 0x110000 || (c1 & 0xFFF800) == 55296) {
                if (this.errorThrow) {
                    throw new IllegalStateException("Invalid UTF-32");
                }
                return 65533;
            }
            return c1;
        }

        @Override
        public int Read(int[] chars, int index, int length) {
            int count = 0;
            for (int i = 0; i < length; ++i) {
                int c = this.ReadChar();
                if (c < 0) {
                    return count;
                }
                chars[index + i] = c;
                ++count;
            }
            return count;
        }
    }

    private static final class Utf16Reader
    implements ICharacterInput {
        private final boolean bigEndian;
        private final IByteReader stream;
        private final SavedState state;
        private final boolean errorThrow;

        public Utf16Reader(IByteReader stream, boolean bigEndian, boolean errorThrow) {
            this.stream = stream;
            this.bigEndian = bigEndian;
            this.state = new SavedState();
            this.errorThrow = errorThrow;
        }

        public void Unget(int c1, int c2) {
            this.state.AddTwo(c1, c2);
        }

        @Override
        public int ReadChar() {
            int c1 = this.state.Read(this.stream);
            if (c1 < 0) {
                return -1;
            }
            int c2 = this.state.Read(this.stream);
            if (c2 < 0) {
                this.state.AddOne(-1);
                if (this.errorThrow) {
                    throw new IllegalStateException("Invalid UTF-16");
                }
                return 65533;
            }
            c1 = this.bigEndian ? c1 << 8 | c2 : c2 << 8 | c1;
            int surr = c1 & 0xFC00;
            if (surr == 55296) {
                int unit2;
                surr = c1;
                c1 = this.state.Read(this.stream);
                c2 = this.state.Read(this.stream);
                if (c1 < 0 || c2 < 0) {
                    this.state.AddOne(-1);
                    if (this.errorThrow) {
                        throw new IllegalStateException("Invalid UTF-16");
                    }
                    return 65533;
                }
                int n = unit2 = this.bigEndian ? c1 << 8 | c2 : c2 << 8 | c1;
                if ((unit2 & 0xFC00) == 56320) {
                    return 65536 + ((surr & 0x3FF) << 10) + (unit2 & 0x3FF);
                }
                this.Unget(c1, c2);
                if (this.errorThrow) {
                    throw new IllegalStateException("Invalid UTF-16");
                }
                return 65533;
            }
            if (surr == 56320) {
                if (this.errorThrow) {
                    throw new IllegalStateException("Invalid UTF-16");
                }
                return 65533;
            }
            return c1;
        }

        @Override
        public int Read(int[] chars, int index, int length) {
            int count = 0;
            for (int i = 0; i < length; ++i) {
                int c = this.ReadChar();
                if (c < 0) {
                    return count;
                }
                chars[index + i] = c;
                ++count;
            }
            return count;
        }
    }

    private static final class SavedState {
        private int[] saved;
        private int savedLength;

        private SavedState() {
        }

        private void Ensure(int size) {
            int[] nArray = this.saved = this.saved == null ? new int[this.savedLength + size] : this.saved;
            if (this.savedLength + size < this.saved.length) {
                int[] newsaved = new int[this.savedLength + size + 4];
                System.arraycopy(this.saved, 0, newsaved, 0, this.savedLength);
                this.saved = newsaved;
            }
        }

        public void AddOne(int a) {
            this.Ensure(1);
            this.saved[this.savedLength++] = a;
        }

        public void AddTwo(int a, int b) {
            this.Ensure(2);
            this.saved[this.savedLength + 1] = a;
            this.saved[this.savedLength] = b;
            this.savedLength += 2;
        }

        public void AddThree(int a, int b, int c) {
            this.Ensure(3);
            this.saved[this.savedLength + 2] = a;
            this.saved[this.savedLength + 1] = b;
            this.saved[this.savedLength] = c;
            this.savedLength += 3;
        }

        public int Read(IByteReader input) {
            if (this.savedLength > 0) {
                int ret = this.saved[--this.savedLength];
                return ret;
            }
            return input.read();
        }
    }

    private static interface IByteReader {
        public int read();
    }
}

