/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORCanonical;
import com.upokecenter.cbor.CBORDateConverter;
import com.upokecenter.cbor.CBOREncodeOptions;
import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORJson;
import com.upokecenter.cbor.CBORNumber;
import com.upokecenter.cbor.CBORReader;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.CBORTypeMapper;
import com.upokecenter.cbor.CBORUriConverter;
import com.upokecenter.cbor.CBORUtilities;
import com.upokecenter.cbor.CBORUuidConverter;
import com.upokecenter.cbor.CharacterInputWithCount;
import com.upokecenter.cbor.CharacterReader;
import com.upokecenter.cbor.JSONOptions;
import com.upokecenter.cbor.PODOptions;
import com.upokecenter.cbor.PropertyMap;
import com.upokecenter.cbor.StringOutput;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;
import com.upokecenter.util.DataUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class CBORObject
implements Comparable<CBORObject> {
    public static final CBORObject False = CBORObject.ConstructSimpleValue(20);
    public static final CBORObject NaN = CBORObject.FromObject(Double.NaN);
    public static final CBORObject NegativeInfinity = CBORObject.FromObject(Double.NEGATIVE_INFINITY);
    public static final CBORObject Null = CBORObject.ConstructSimpleValue(22);
    public static final CBORObject PositiveInfinity = CBORObject.FromObject(Double.POSITIVE_INFINITY);
    public static final CBORObject True = CBORObject.ConstructSimpleValue(21);
    public static final CBORObject Undefined = CBORObject.ConstructSimpleValue(23);
    public static final CBORObject Zero = CBORObject.ConstructIntegerValue(0);
    private static final int CBORObjectTypeInteger = 0;
    private static final int CBORObjectTypeEInteger = 1;
    private static final int CBORObjectTypeByteString = 2;
    private static final int CBORObjectTypeTextString = 3;
    private static final int CBORObjectTypeArray = 4;
    private static final int CBORObjectTypeMap = 5;
    private static final int CBORObjectTypeTagged = 6;
    private static final int CBORObjectTypeSimpleValue = 7;
    private static final int CBORObjectTypeDouble = 8;
    private static final int StreamedStringBufferLength = 4096;
    private static final EInteger UInt64MaxValue = EInteger.FromInt32(1).ShiftLeft(64).Subtract(EInteger.FromInt64(1L));
    private static final EInteger[] ValueEmptyTags = new EInteger[0];
    private static final int[] ValueExpectedLengths = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 5, 9, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 5, 9, -1, -1, -1, -1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 0, 0, 0, 0, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 0, 0, 0, 0, -1, -1, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 5, 9, -1, -1, -1, -1};
    private static final byte[] ValueFalseBytes = new byte[]{102, 97, 108, 115, 101};
    private static final byte[] ValueNullBytes = new byte[]{110, 117, 108, 108};
    private static final byte[] ValueTrueBytes = new byte[]{116, 114, 117, 101};
    private static final CBORObject[] FixedObjects = CBORObject.InitializeFixedObjects();
    private final int itemtypeValue;
    private final Object itemValue;
    private final int tagHigh;
    private final int tagLow;
    private static final CBOREncodeOptions AllowEmptyOptions = new CBOREncodeOptions("allowempty=1");

    private static CBORObject ConstructSimpleValue(int v) {
        return new CBORObject(7, v);
    }

    private static CBORObject ConstructIntegerValue(int v) {
        return new CBORObject(0, v);
    }

    CBORObject(CBORObject obj, int tagLow, int tagHigh) {
        this.itemtypeValue = 6;
        this.itemValue = obj;
        this.tagLow = tagLow;
        this.tagHigh = tagHigh;
    }

    CBORObject(int type, Object item) {
        this.itemtypeValue = type;
        this.itemValue = item;
        this.tagLow = 0;
        this.tagHigh = 0;
    }

    public final int size() {
        return this.getItemType() == 4 ? this.AsList().size() : (this.getItemType() == 5 ? this.AsMap().size() : 0);
    }

    public final EInteger getMostInnerTag() {
        if (!this.isTagged()) {
            return EInteger.FromInt32(-1);
        }
        CBORObject previtem = this;
        CBORObject curitem = (CBORObject)this.itemValue;
        while (curitem.isTagged()) {
            previtem = curitem;
            curitem = (CBORObject)curitem.itemValue;
        }
        if (previtem.tagHigh == 0 && previtem.tagLow >= 0 && previtem.tagLow < 65536) {
            return EInteger.FromInt64(previtem.tagLow);
        }
        return CBORObject.LowHighToEInteger(previtem.tagLow, previtem.tagHigh);
    }

    public final boolean isFalse() {
        return this.getItemType() == 7 && (Integer)this.getThisItem() == 20;
    }

    public final boolean isFinite() {
        return this.isNumber() && !this.IsInfinity() && !this.IsNaN();
    }

    public final boolean isIntegral() {
        CBORNumber cn = CBORNumber.FromCBORObject(this);
        return cn != null && cn.GetNumberInterface().IsIntegral(cn.GetValue());
    }

    public final boolean isNull() {
        return this.getItemType() == 7 && (Integer)this.getThisItem() == 22;
    }

    public final boolean isTagged() {
        return this.itemtypeValue == 6;
    }

    public final boolean isTrue() {
        return this.getItemType() == 7 && (Integer)this.getThisItem() == 21;
    }

    public final boolean isUndefined() {
        return this.getItemType() == 7 && (Integer)this.getThisItem() == 23;
    }

    public final boolean isZero() {
        CBORNumber cn = CBORNumber.FromCBORObject(this);
        return cn != null && cn.GetNumberInterface().IsNumberZero(cn.GetValue());
    }

    public final Collection<CBORObject> getKeys() {
        if (this.getItemType() == 5) {
            Map<CBORObject, CBORObject> dict = this.AsMap();
            return dict.keySet();
        }
        throw new IllegalStateException("Not a map");
    }

    public final boolean isNegative() {
        CBORNumber cn = CBORNumber.FromCBORObject(this);
        return cn != null && cn.GetNumberInterface().IsNegative(cn.GetValue());
    }

    public final EInteger getMostOuterTag() {
        if (!this.isTagged()) {
            return EInteger.FromInt32(-1);
        }
        if (this.tagHigh == 0 && this.tagLow >= 0 && this.tagLow < 65536) {
            return EInteger.FromInt32(this.tagLow);
        }
        return CBORObject.LowHighToEInteger(this.tagLow, this.tagHigh);
    }

    public final int signum() {
        int ret;
        CBORNumber cn = CBORNumber.FromCBORObject(this);
        int n = ret = cn == null ? 2 : cn.GetNumberInterface().Sign(cn.GetValue());
        if (ret == 2) {
            throw new IllegalStateException("This Object is not a number.");
        }
        return ret;
    }

    public final int getSimpleValue() {
        return this.getItemType() == 7 ? (Integer)this.getThisItem() : -1;
    }

    public final boolean isNumber() {
        return CBORNumber.IsNumber(this);
    }

    public final CBORType getType() {
        switch (this.getItemType()) {
            case 0: 
            case 1: {
                return CBORType.Integer;
            }
            case 8: {
                return CBORType.FloatingPoint;
            }
            case 7: {
                return (Integer)this.getThisItem() == 21 || (Integer)this.getThisItem() == 20 ? CBORType.Boolean : CBORType.SimpleValue;
            }
            case 4: {
                return CBORType.Array;
            }
            case 5: {
                return CBORType.Map;
            }
            case 2: {
                return CBORType.ByteString;
            }
            case 3: {
                return CBORType.TextString;
            }
        }
        throw new IllegalStateException("Unexpected data type");
    }

    public final Collection<CBORObject> getValues() {
        if (this.getItemType() == 5) {
            Map<CBORObject, CBORObject> dict = this.AsMap();
            return dict.values();
        }
        if (this.getItemType() == 4) {
            List<CBORObject> list = this.AsList();
            return Collections.unmodifiableList(list);
        }
        throw new IllegalStateException("Not a map or array");
    }

    private final int getItemType() {
        CBORObject curobject = this;
        while (curobject.itemtypeValue == 6) {
            curobject = (CBORObject)curobject.itemValue;
        }
        return curobject.itemtypeValue;
    }

    private final Object getThisItem() {
        CBORObject curobject = this;
        while (curobject.itemtypeValue == 6) {
            curobject = (CBORObject)curobject.itemValue;
        }
        return curobject.itemValue;
    }

    public CBORObject get(int index) {
        if (this.getItemType() == 4) {
            List<CBORObject> list = this.AsList();
            if (index < 0 || index >= list.size()) {
                throw new IllegalArgumentException("index");
            }
            return list.get(index);
        }
        if (this.getItemType() == 5) {
            CBORObject key;
            Map<CBORObject, CBORObject> map = this.AsMap();
            return !map.containsKey(key = CBORObject.FromObject(index)) ? null : map.get(key);
        }
        throw new IllegalStateException("Not an array or map");
    }

    public void set(int index, CBORObject value) {
        if (this.getItemType() == 4) {
            if (value == null) {
                throw new NullPointerException("value");
            }
            List<CBORObject> list = this.AsList();
            if (index < 0 || index >= list.size()) {
                throw new IllegalArgumentException("index");
            }
            list.set(index, value);
        } else if (this.getItemType() == 5) {
            Map<CBORObject, CBORObject> map = this.AsMap();
            CBORObject key = CBORObject.FromObject(index);
            map.put(key, value);
        } else {
            throw new IllegalStateException("Not an array or map");
        }
    }

    public CBORObject GetOrDefault(Object key, CBORObject defaultValue) {
        if (this.getItemType() == 4) {
            int index = 0;
            if (key instanceof Integer) {
                index = (Integer)key;
            } else {
                CBORObject cborkey = CBORObject.FromObject(key);
                if (!cborkey.isIntegral()) {
                    return defaultValue;
                }
                if (!cborkey.CanTruncatedIntFitInInt32()) {
                    return defaultValue;
                }
                index = cborkey.AsInt32();
            }
            List<CBORObject> list = this.AsList();
            return index < 0 || index >= list.size() ? defaultValue : list.get(index);
        }
        if (this.getItemType() == 5) {
            CBORObject ckey;
            Map<CBORObject, CBORObject> map = this.AsMap();
            return !map.containsKey(ckey = CBORObject.FromObject(key)) ? defaultValue : map.get(ckey);
        }
        return defaultValue;
    }

    public CBORObject get(CBORObject key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.getItemType() == 5) {
            Map<CBORObject, CBORObject> map = this.AsMap();
            return !map.containsKey(key) ? null : map.get(key);
        }
        if (this.getItemType() == 4) {
            if (!key.isIntegral()) {
                throw new IllegalArgumentException("Not an integer");
            }
            if (!key.CanTruncatedIntFitInInt32()) {
                throw new IllegalArgumentException("key");
            }
            List<CBORObject> list = this.AsList();
            int index = key.AsInt32();
            if (index < 0 || index >= list.size()) {
                throw new IllegalArgumentException("key");
            }
            return list.get(index);
        }
        throw new IllegalStateException("Not an array or map");
    }

    public void set(CBORObject key, CBORObject value) {
        if (key == null) {
            throw new NullPointerException("value");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (this.getItemType() == 5) {
            Map<CBORObject, CBORObject> map = this.AsMap();
            map.put(key, value);
            return;
        }
        if (this.getItemType() == 4) {
            if (!key.isIntegral()) {
                throw new IllegalArgumentException("Not an integer");
            }
            if (!key.CanTruncatedIntFitInInt32()) {
                throw new IllegalArgumentException("key");
            }
            List<CBORObject> list = this.AsList();
            int index = key.AsInt32();
            if (index < 0 || index >= list.size()) {
                throw new IllegalArgumentException("key");
            }
            list.set(index, value);
            return;
        }
        throw new IllegalStateException("Not an array or map");
    }

    public CBORObject get(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        CBORObject objkey = CBORObject.FromObject(key);
        return this.get(objkey);
    }

    public void set(String key, CBORObject value) {
        if (key == null) {
            throw new NullPointerException("value");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        CBORObject objkey = CBORObject.FromObject(key);
        if (this.getItemType() != 5) {
            throw new IllegalStateException("Not a map");
        }
        Map<CBORObject, CBORObject> map = this.AsMap();
        map.put(objkey, value);
    }

    public static CBORObject Addition(CBORObject first, CBORObject second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        CBORNumber numberA = CBORNumber.FromCBORObject(first);
        if (numberA == null) {
            throw new IllegalArgumentException("firstdoes not represent a number");
        }
        CBORNumber b = CBORNumber.FromCBORObject(second);
        if (b == null) {
            throw new IllegalArgumentException("seconddoes not represent a number");
        }
        return numberA.Add(b).ToCBORObject();
    }

    public static CBORObject DecodeFromBytes(byte[] data) {
        return CBORObject.DecodeFromBytes(data, CBOREncodeOptions.Default);
    }

    public static CBORObject[] DecodeSequenceFromBytes(byte[] data) {
        return CBORObject.DecodeSequenceFromBytes(data, AllowEmptyOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CBORObject[] DecodeSequenceFromBytes(byte[] data, CBOREncodeOptions options) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (data.length == 0) {
            return new CBORObject[0];
        }
        CBOREncodeOptions opt = options;
        if (!opt.getAllowEmpty()) {
            opt = new CBOREncodeOptions(opt.toString() + ";allowempty=1");
        }
        ArrayList<CBORObject> cborList = new ArrayList<CBORObject>();
        ByteArrayInputStream ms = null;
        try {
            CBORObject obj;
            ms = new ByteArrayInputStream(data);
            while ((obj = CBORObject.Read(ms, opt)) != null) {
                cborList.add(obj);
            }
        }
        finally {
            try {
                if (ms != null) {
                    ms.close();
                }
            }
            catch (IOException iOException) {}
        }
        return cborList.toArray(new CBORObject[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CBORObject DecodeFromBytes(byte[] data, CBOREncodeOptions options) {
        String s;
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (data.length == 0) {
            if (options.getAllowEmpty()) {
                return null;
            }
            throw new CBORException("data is empty.");
        }
        int firstbyte = data[0] & 0xFF;
        int expectedLength = ValueExpectedLengths[firstbyte];
        if (expectedLength == -1) {
            throw new CBORException("Unexpected data encountered");
        }
        if (expectedLength != 0) {
            CBORObject.CheckCBORLength(expectedLength, data.length);
            if (!options.getCtap2Canonical() || firstbyte >= 0 && firstbyte < 24 || firstbyte >= 32 && firstbyte < 56) {
                return CBORObject.GetFixedLengthObject(firstbyte, data);
            }
        }
        if (firstbyte == 192 && !options.getCtap2Canonical() && (s = CBORObject.GetOptimizedStringIfShortAscii(data, 1)) != null) {
            return new CBORObject(CBORObject.FromObject(s), 0, 0);
        }
        ByteArrayInputStream ms = null;
        try {
            ms = new ByteArrayInputStream(data);
            int startingAvailable = ms.available();
            CBORObject o = CBORObject.Read(ms, options);
            CBORObject.CheckCBORLength((long)data.length, (long)(startingAvailable - ms.available()));
            CBORObject cBORObject = o;
            return cBORObject;
        }
        finally {
            try {
                if (ms != null) {
                    ms.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static CBORObject Divide(CBORObject first, CBORObject second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        CBORNumber a = CBORNumber.FromCBORObject(first);
        if (a == null) {
            throw new IllegalArgumentException("firstdoes not represent a number");
        }
        CBORNumber b = CBORNumber.FromCBORObject(second);
        if (b == null) {
            throw new IllegalArgumentException("seconddoes not represent a number");
        }
        return a.Divide(b).ToCBORObject();
    }

    public static CBORObject FromJSONString(String str) {
        return CBORObject.FromJSONString(str, CBOREncodeOptions.Default);
    }

    public static CBORObject FromJSONString(String str, CBOREncodeOptions options) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (str.length() > 0 && str.charAt(0) == '\ufeff') {
            throw new CBORException("JSON Object began with a byte order mark (U+FEFF) (offset 0)");
        }
        CharacterInputWithCount reader = new CharacterInputWithCount(new CharacterReader(str, false, true));
        int[] nextchar = new int[1];
        CBORObject obj = CBORJson.ParseJSONValue(reader, !options.getAllowDuplicateKeys(), false, nextchar);
        if (nextchar[0] != -1) {
            reader.RaiseError("End of String not reached");
        }
        return obj;
    }

    public <T> T ToObject(Type t) {
        return this.ToObject(t, null, null, 0);
    }

    public <T> T ToObject(Type t, CBORTypeMapper mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapper");
        }
        return this.ToObject(t, mapper, null, 0);
    }

    public <T> T ToObject(Type t, PODOptions options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        return this.ToObject(t, null, options, 0);
    }

    public <T> T ToObject(Type t, CBORTypeMapper mapper, PODOptions options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        return this.ToObject(t, mapper, options, 0);
    }

    <T> T ToObject(Type t, CBORTypeMapper mapper, PODOptions options, int depth) {
        Object obj;
        if (++depth > 100) {
            throw new CBORException("Depth level too high");
        }
        if (t == null) {
            throw new NullPointerException("t");
        }
        if (t.equals(CBORObject.class)) {
            return (T)this;
        }
        if (this.isNull()) {
            return null;
        }
        if (mapper != null && (obj = mapper.ConvertBackWithConverter(this, t)) != null) {
            return obj;
        }
        if (t.equals(Object.class)) {
            return (T)this;
        }
        return (T)(t.equals(String.class) ? this.AsString() : PropertyMap.TypeToObject(this, t, mapper, options, depth));
    }

    public static CBORObject FromObject(long value) {
        return value >= 0L && value < 24L ? FixedObjects[(int)value] : new CBORObject(0, value);
    }

    public static CBORObject FromObject(CBORObject value) {
        return value == null ? Null : value;
    }

    public static CBORObject FromObject(EInteger bigintValue) {
        if (bigintValue == null) {
            return Null;
        }
        if (bigintValue.CanFitInInt64()) {
            return CBORObject.FromObject(bigintValue.ToInt64Checked());
        }
        EInteger bitLength = bigintValue.GetSignedBitLengthAsEInteger();
        if (bitLength.compareTo(64) <= 0) {
            return new CBORObject(1, bigintValue);
        }
        int tag = bigintValue.signum() < 0 ? 3 : 2;
        return CBORObject.FromObjectAndTag((Object)CBORObject.EIntegerBytes(bigintValue), tag);
    }

    public static CBORObject FromObject(EFloat bigValue) {
        int tag;
        CBORObject cbor;
        if (bigValue == null) {
            return Null;
        }
        if (bigValue.IsInfinity() || bigValue.IsNaN() || bigValue.isNegative() && bigValue.isZero()) {
            int options;
            int n = options = bigValue.isNegative() ? 1 : 0;
            if (bigValue.IsInfinity()) {
                options += 2;
            }
            if (bigValue.IsQuietNaN()) {
                options += 4;
            }
            if (bigValue.IsSignalingNaN()) {
                options += 6;
            }
            cbor = CBORObject.NewArray().Add(bigValue.getExponent()).Add(bigValue.getUnsignedMantissa()).Add(options);
            tag = 269;
        } else {
            EInteger bitLength = bigValue.getExponent().GetSignedBitLengthAsEInteger();
            tag = bitLength.compareTo(64) > 0 ? 265 : 5;
            cbor = CBORObject.NewArray().Add(bigValue.getExponent()).Add(bigValue.getMantissa());
        }
        return CBORObject.FromObjectAndTag((Object)cbor, tag);
    }

    public static CBORObject FromObject(ERational bigValue) {
        int tag;
        CBORObject cbor;
        if (bigValue == null) {
            return Null;
        }
        if (bigValue.IsInfinity() || bigValue.IsNaN() || bigValue.isNegative() && bigValue.isZero()) {
            int options;
            int n = options = bigValue.isNegative() ? 1 : 0;
            if (bigValue.IsInfinity()) {
                options += 2;
            }
            if (bigValue.IsQuietNaN()) {
                options += 4;
            }
            if (bigValue.IsSignalingNaN()) {
                options += 6;
            }
            cbor = CBORObject.NewArray().Add(bigValue.getUnsignedNumerator()).Add(bigValue.getDenominator()).Add(options);
            tag = 270;
        } else {
            tag = 30;
            cbor = CBORObject.NewArray().Add(bigValue.getNumerator()).Add(bigValue.getDenominator());
        }
        return CBORObject.FromObjectAndTag((Object)cbor, tag);
    }

    public static CBORObject FromObject(EDecimal bigValue) {
        int tag;
        CBORObject cbor;
        if (bigValue == null) {
            return Null;
        }
        if (bigValue.IsInfinity() || bigValue.IsNaN() || bigValue.isNegative() && bigValue.isZero()) {
            int options;
            int n = options = bigValue.isNegative() ? 1 : 0;
            if (bigValue.IsInfinity()) {
                options += 2;
            }
            if (bigValue.IsQuietNaN()) {
                options += 4;
            }
            if (bigValue.IsSignalingNaN()) {
                options += 6;
            }
            cbor = CBORObject.NewArray().Add(bigValue.getExponent()).Add(bigValue.getUnsignedMantissa()).Add(options);
            tag = 268;
        } else {
            EInteger bitLength = bigValue.getExponent().GetSignedBitLengthAsEInteger();
            tag = bitLength.compareTo(64) > 0 ? 264 : 4;
            cbor = CBORObject.NewArray().Add(bigValue.getExponent()).Add(bigValue.getMantissa());
        }
        return CBORObject.FromObjectAndTag((Object)cbor, tag);
    }

    public static CBORObject FromObject(String strValue) {
        if (strValue == null) {
            return Null;
        }
        if (DataUtilities.GetUtf8Length(strValue, false) < 0L) {
            throw new IllegalArgumentException("String contains an unpaired surrogate code point.");
        }
        return new CBORObject(3, strValue);
    }

    public static CBORObject FromObject(int value) {
        return value >= 0 && value < 24 ? FixedObjects[value] : CBORObject.FromObject((long)value);
    }

    public static CBORObject FromObject(short value) {
        return value >= 0 && value < 24 ? FixedObjects[value] : CBORObject.FromObject((long)value);
    }

    public static CBORObject FromObject(boolean value) {
        return value ? True : False;
    }

    public static CBORObject FromObject(byte value) {
        return CBORObject.FromObject(value & 0xFF);
    }

    public static CBORObject FromObject(float value) {
        long doubleBits = CBORUtilities.SingleToDoublePrecision(CBORUtilities.SingleToInt32Bits(value));
        return new CBORObject(8, doubleBits);
    }

    public static CBORObject FromObject(double value) {
        long doubleBits = CBORUtilities.DoubleToInt64Bits(value);
        return new CBORObject(8, doubleBits);
    }

    public static CBORObject FromObject(byte[] bytes) {
        if (bytes == null) {
            return Null;
        }
        byte[] newvalue = new byte[bytes.length];
        System.arraycopy(bytes, 0, newvalue, 0, bytes.length);
        return new CBORObject(2, bytes);
    }

    public static CBORObject FromObject(CBORObject[] array) {
        if (array == null) {
            return Null;
        }
        CBORObject cbor = CBORObject.NewArray();
        for (CBORObject i : array) {
            cbor.Add(i);
        }
        return cbor;
    }

    public static CBORObject FromObject(int[] array) {
        if (array == null) {
            return Null;
        }
        ArrayList<CBORObject> list = new ArrayList<CBORObject>();
        for (int i : array) {
            list.add(CBORObject.FromObject(i));
        }
        return new CBORObject(4, list);
    }

    public static CBORObject FromObject(long[] array) {
        if (array == null) {
            return Null;
        }
        ArrayList<CBORObject> list = new ArrayList<CBORObject>();
        for (long i : array) {
            list.add(CBORObject.FromObject(i));
        }
        return new CBORObject(4, list);
    }

    public static CBORObject FromObject(Object obj) {
        return CBORObject.FromObject(obj, PODOptions.Default);
    }

    public static CBORObject FromObject(Object obj, PODOptions options) {
        return CBORObject.FromObject(obj, options, null, 0);
    }

    public static CBORObject FromObject(Object obj, CBORTypeMapper mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapper");
        }
        return CBORObject.FromObject(obj, PODOptions.Default, mapper, 0);
    }

    public static CBORObject FromObject(Object obj, CBORTypeMapper mapper, PODOptions options) {
        if (mapper == null) {
            throw new NullPointerException("mapper");
        }
        return CBORObject.FromObject(obj, options, mapper, 0);
    }

    static CBORObject FromObject(Object obj, PODOptions options, CBORTypeMapper mapper, int depth) {
        byte[] bytearr;
        ERational erf;
        EFloat eff;
        EDecimal edf;
        EInteger eif;
        CBORObject objret;
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (depth >= 100) {
            throw new CBORException("Nesting depth too high");
        }
        if (obj == null) {
            return Null;
        }
        if (obj instanceof CBORObject) {
            return CBORObject.FromObject((CBORObject)obj);
        }
        if (mapper != null && (objret = mapper.ConvertWithConverter(obj)) != null) {
            return objret;
        }
        if (obj instanceof String) {
            return CBORObject.FromObject((String)obj);
        }
        if (obj instanceof Integer) {
            return CBORObject.FromObject((Integer)obj);
        }
        if (obj instanceof Long) {
            return CBORObject.FromObject((Long)obj);
        }
        EInteger eInteger = eif = obj instanceof EInteger ? (EInteger)obj : null;
        if (eif != null) {
            return CBORObject.FromObject(eif);
        }
        EDecimal eDecimal = edf = obj instanceof EDecimal ? (EDecimal)obj : null;
        if (edf != null) {
            return CBORObject.FromObject(edf);
        }
        EFloat eFloat = eff = obj instanceof EFloat ? (EFloat)obj : null;
        if (eff != null) {
            return CBORObject.FromObject(eff);
        }
        ERational eRational = erf = obj instanceof ERational ? (ERational)obj : null;
        if (erf != null) {
            return CBORObject.FromObject(erf);
        }
        if (obj instanceof Short) {
            return CBORObject.FromObject((Short)obj);
        }
        if (obj instanceof Character) {
            return CBORObject.FromObject(((Character)obj).charValue());
        }
        if (obj instanceof Boolean) {
            return CBORObject.FromObject((Boolean)obj);
        }
        if (obj instanceof Byte) {
            return CBORObject.FromObject((Byte)obj);
        }
        if (obj instanceof Float) {
            return CBORObject.FromObject(((Float)obj).floatValue());
        }
        if (obj instanceof Double) {
            return CBORObject.FromObject((Double)obj);
        }
        byte[] byArray = bytearr = obj instanceof byte[] ? (byte[])obj : null;
        if (bytearr != null) {
            return CBORObject.FromObject(bytearr);
        }
        if (obj instanceof Map) {
            objret = CBORObject.NewMap();
            Map objdic = (Map)obj;
            Iterator iterator = objdic.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry keyPair;
                Map.Entry kvp = keyPair = iterator.next();
                CBORObject objKey = CBORObject.FromObject(kvp.getKey(), options, mapper, depth + 1);
                objret.set(objKey, CBORObject.FromObject(kvp.getValue(), options, mapper, depth + 1));
            }
            return objret;
        }
        if (obj.getClass().isArray()) {
            return PropertyMap.FromArray(obj, options, mapper, depth);
        }
        if (obj instanceof Iterable) {
            objret = CBORObject.NewArray();
            for (Object element : (Iterable)obj) {
                objret.Add(CBORObject.FromObject(element, options, mapper, depth + 1));
            }
            return objret;
        }
        if (obj instanceof Enum) {
            return CBORObject.FromObject(PropertyMap.EnumToObjectAsInteger((Enum)obj));
        }
        if (obj instanceof Date) {
            return new CBORDateConverter().ToCBORObject((Date)obj);
        }
        if (obj instanceof URI) {
            return new CBORUriConverter().ToCBORObject((URI)obj);
        }
        if (obj instanceof UUID) {
            return new CBORUuidConverter().ToCBORObject((UUID)obj);
        }
        objret = CBORObject.NewMap();
        for (Map.Entry<String, Object> key : PropertyMap.GetProperties(obj, options.getUseCamelCase())) {
            objret.set(key.getKey(), CBORObject.FromObject(key.getValue(), options, mapper, depth + 1));
        }
        return objret;
    }

    public static CBORObject FromObjectAndTag(Object valueOb, EInteger bigintTag) {
        int b;
        int i;
        if (bigintTag == null) {
            throw new NullPointerException("bigintTag");
        }
        if (bigintTag.signum() < 0) {
            throw new IllegalArgumentException("tagEInt's sign (" + bigintTag.signum() + ") is less than 0");
        }
        if (bigintTag.compareTo(UInt64MaxValue) > 0) {
            throw new IllegalArgumentException("tag more than 18446744073709551615 (" + bigintTag + ")");
        }
        CBORObject c = CBORObject.FromObject(valueOb);
        if (bigintTag.CanFitInInt32()) {
            return CBORObject.FromObjectAndTag((Object)c, bigintTag.ToInt32Checked());
        }
        int tagLow = 0;
        int tagHigh = 0;
        byte[] bytes = bigintTag.ToBytes(true);
        for (i = 0; i < Math.min(4, bytes.length); ++i) {
            b = bytes[i] & 0xFF;
            tagLow |= b << i * 8;
        }
        for (i = 4; i < Math.min(8, bytes.length); ++i) {
            b = bytes[i] & 0xFF;
            tagHigh |= b << i * 8;
        }
        CBORObject c2 = new CBORObject(c, tagLow, tagHigh);
        return c2;
    }

    public static CBORObject FromObjectAndTag(Object valueObValue, int smallTag) {
        if (smallTag < 0) {
            throw new IllegalArgumentException("smallTag (" + smallTag + ") is less than 0");
        }
        CBORObject c = CBORObject.FromObject(valueObValue);
        c = new CBORObject(c, smallTag, 0);
        return c;
    }

    public static CBORObject FromSimpleValue(int simpleValue) {
        if (simpleValue < 0) {
            throw new IllegalArgumentException("simpleValue (" + simpleValue + ") is less than 0");
        }
        if (simpleValue > 255) {
            throw new IllegalArgumentException("simpleValue (" + simpleValue + ") is more than 255");
        }
        if (simpleValue >= 24 && simpleValue < 32) {
            throw new IllegalArgumentException("Simple value is from 24 to 31: " + simpleValue);
        }
        if (simpleValue < 32) {
            return FixedObjects[224 + simpleValue];
        }
        return new CBORObject(7, simpleValue);
    }

    public static CBORObject Multiply(CBORObject first, CBORObject second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        CBORNumber a = CBORNumber.FromCBORObject(first);
        if (a == null) {
            throw new IllegalArgumentException("firstdoes not represent a number");
        }
        CBORNumber b = CBORNumber.FromCBORObject(second);
        if (b == null) {
            throw new IllegalArgumentException("seconddoes not represent a number");
        }
        return a.Multiply(b).ToCBORObject();
    }

    public static CBORObject NewArray() {
        return new CBORObject(4, new ArrayList());
    }

    public static CBORObject NewMap() {
        return new CBORObject(5, new HashMap());
    }

    public static CBORObject[] ReadSequence(InputStream stream) throws IOException {
        CBORObject obj;
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        ArrayList<CBORObject> cborList = new ArrayList<CBORObject>();
        while ((obj = CBORObject.Read(stream, AllowEmptyOptions)) != null) {
            cborList.add(obj);
        }
        return cborList.toArray(new CBORObject[0]);
    }

    public static CBORObject[] ReadSequence(InputStream stream, CBOREncodeOptions options) throws IOException {
        CBORObject obj;
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        CBOREncodeOptions opt = options;
        if (!opt.getAllowEmpty()) {
            opt = new CBOREncodeOptions(opt.toString() + ";allowempty=1");
        }
        ArrayList<CBORObject> cborList = new ArrayList<CBORObject>();
        while ((obj = CBORObject.Read(stream, opt)) != null) {
            cborList.add(obj);
        }
        return cborList.toArray(new CBORObject[0]);
    }

    public static CBORObject Read(InputStream stream) {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        try {
            CBORReader reader = new CBORReader(stream);
            return reader.Read();
        }
        catch (IOException ex) {
            throw new CBORException("I/O error occurred.", ex);
        }
    }

    public static CBORObject Read(InputStream stream, CBOREncodeOptions options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        try {
            CBORReader reader = new CBORReader(stream, options);
            return reader.Read();
        }
        catch (IOException ex) {
            throw new CBORException("I/O error occurred.", ex);
        }
    }

    public static CBORObject ReadJSON(InputStream stream) throws IOException {
        return CBORObject.ReadJSON(stream, CBOREncodeOptions.Default);
    }

    public static CBORObject ReadJSON(InputStream stream, CBOREncodeOptions options) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        CharacterInputWithCount reader = new CharacterInputWithCount(new CharacterReader(stream, 2, true));
        try {
            int[] nextchar = new int[1];
            CBORObject obj = CBORJson.ParseJSONValue(reader, !options.getAllowDuplicateKeys(), false, nextchar);
            if (nextchar[0] != -1) {
                reader.RaiseError("End of data stream not reached");
            }
            return obj;
        }
        catch (CBORException ex) {
            IOException ioex;
            IOException iOException = ioex = ex.getCause() instanceof IOException ? (IOException)ex.getCause() : null;
            if (ioex != null) {
                throw ioex;
            }
            throw ex;
        }
    }

    public static CBORObject Remainder(CBORObject first, CBORObject second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        CBORNumber a = CBORNumber.FromCBORObject(first);
        if (a == null) {
            throw new IllegalArgumentException("firstdoes not represent a number");
        }
        CBORNumber b = CBORNumber.FromCBORObject(second);
        if (b == null) {
            throw new IllegalArgumentException("seconddoes not represent a number");
        }
        return a.Remainder(b).ToCBORObject();
    }

    public static CBORObject Subtract(CBORObject first, CBORObject second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        CBORNumber a = CBORNumber.FromCBORObject(first);
        if (a == null) {
            throw new IllegalArgumentException("firstdoes not represent a number");
        }
        CBORNumber b = CBORNumber.FromCBORObject(second);
        if (b == null) {
            throw new IllegalArgumentException("seconddoes not represent a number");
        }
        return a.Subtract(b).ToCBORObject();
    }

    public static void Write(String str, OutputStream stream) throws IOException {
        CBORObject.Write(str, stream, CBOREncodeOptions.Default);
    }

    public static void Write(String str, OutputStream stream, CBOREncodeOptions options) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (str == null) {
            stream.write(246);
        } else if (!options.getUseIndefLengthStrings() || options.getCtap2Canonical()) {
            long codePointLength = DataUtilities.GetUtf8Length(str, true);
            CBORObject.WritePositiveInt64(3, codePointLength, stream);
            DataUtilities.WriteUtf8(str, stream, true);
        } else {
            CBORObject.WriteStreamedString(str, stream);
        }
    }

    public static void Write(EFloat bignum, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (bignum == null) {
            stream.write(246);
            return;
        }
        if (bignum.isZero() && bignum.isNegative() || bignum.IsInfinity() || bignum.IsNaN()) {
            CBORObject.Write(CBORObject.FromObject(bignum), stream);
            return;
        }
        EInteger exponent = bignum.getExponent();
        if (exponent.GetSignedBitLengthAsEInteger().compareTo(64) > 0) {
            stream.write(217);
            stream.write(1);
            stream.write(9);
            stream.write(130);
        } else {
            stream.write(197);
            stream.write(130);
        }
        CBORObject.Write(bignum.getExponent(), stream);
        CBORObject.Write(bignum.getMantissa(), stream);
    }

    public static void Write(ERational rational, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (rational == null) {
            stream.write(246);
            return;
        }
        if (!rational.isFinite() || rational.isNegative() && rational.isZero()) {
            CBORObject.Write(CBORObject.FromObject(rational), stream);
            return;
        }
        stream.write(216);
        stream.write(30);
        stream.write(130);
        CBORObject.Write(rational.getNumerator(), stream);
        CBORObject.Write(rational.getDenominator(), stream);
    }

    public static void Write(EDecimal bignum, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (bignum == null) {
            stream.write(246);
            return;
        }
        if (!bignum.isFinite() || bignum.isNegative() && bignum.isZero()) {
            CBORObject.Write(CBORObject.FromObject(bignum), stream);
            return;
        }
        EInteger exponent = bignum.getExponent();
        if (exponent.GetSignedBitLengthAsEInteger().compareTo(64) > 0) {
            stream.write(217);
            stream.write(1);
            stream.write(8);
            stream.write(130);
        } else {
            stream.write(196);
            stream.write(130);
        }
        CBORObject.Write(bignum.getExponent(), stream);
        CBORObject.Write(bignum.getMantissa(), stream);
    }

    private static byte[] EIntegerBytes(EInteger ei) {
        int index;
        if (ei.isZero()) {
            return new byte[]{0};
        }
        if (ei.signum() < 0) {
            ei = ei.Add(1).Negate();
        }
        byte[] bytes = ei.ToBytes(false);
        for (index = 0; index < bytes.length && bytes[index] == 0; ++index) {
        }
        if (index > 0) {
            byte[] newBytes = new byte[bytes.length - index];
            System.arraycopy(bytes, index, newBytes, 0, newBytes.length);
            return newBytes;
        }
        return bytes;
    }

    public static void Write(EInteger bigint, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (bigint == null) {
            stream.write(246);
            return;
        }
        int datatype = 0;
        if (bigint.signum() < 0) {
            datatype = 1;
            bigint = bigint.Add(EInteger.FromInt32(1));
            bigint = bigint.Negate();
        }
        if (bigint.CanFitInInt64()) {
            CBORObject.WritePositiveInt64(datatype, bigint.ToInt64Checked(), stream);
        } else {
            int byteCount;
            byte[] bytes = bigint.ToBytes(true);
            for (byteCount = bytes.length; byteCount > 0 && bytes[byteCount - 1] == 0; --byteCount) {
            }
            if (byteCount != 0) {
                int half = byteCount >> 1;
                int right = byteCount - 1;
                int i = 0;
                while (i < half) {
                    byte value = bytes[i];
                    bytes[i] = bytes[right];
                    bytes[right] = value;
                    ++i;
                    --right;
                }
            }
            switch (byteCount) {
                case 0: {
                    stream.write((byte)(datatype << 5));
                    return;
                }
                case 1: {
                    CBORObject.WritePositiveInt(datatype, bytes[0] & 0xFF, stream);
                    break;
                }
                case 2: {
                    stream.write((byte)(datatype << 5 | 0x19));
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                case 3: {
                    stream.write((byte)(datatype << 5 | 0x1A));
                    stream.write(0);
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                case 4: {
                    stream.write((byte)(datatype << 5 | 0x1A));
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                case 5: {
                    stream.write((byte)(datatype << 5 | 0x1B));
                    stream.write(0);
                    stream.write(0);
                    stream.write(0);
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                case 6: {
                    stream.write((byte)(datatype << 5 | 0x1B));
                    stream.write(0);
                    stream.write(0);
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                case 7: {
                    stream.write((byte)(datatype << 5 | 0x1B));
                    stream.write(0);
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                case 8: {
                    stream.write((byte)(datatype << 5 | 0x1B));
                    stream.write(bytes, 0, byteCount);
                    break;
                }
                default: {
                    stream.write(datatype == 0 ? -62 : -61);
                    CBORObject.WritePositiveInt(2, byteCount, stream);
                    stream.write(bytes, 0, byteCount);
                }
            }
        }
    }

    public static void Write(long value, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (value >= 0L) {
            CBORObject.WritePositiveInt64(0, value, stream);
        } else {
            ++value;
            value = -value;
            CBORObject.WritePositiveInt64(1, value, stream);
        }
    }

    public static void Write(int value, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        int type = 0;
        if (value < 0) {
            ++value;
            value = -value;
            type = 32;
        }
        if (value < 24) {
            stream.write((byte)(value | type));
        } else if (value <= 255) {
            byte[] bytes = new byte[]{(byte)(0x18 | type), (byte)(value & 0xFF)};
            stream.write(bytes, 0, 2);
        } else if (value <= 65535) {
            byte[] bytes = new byte[]{(byte)(0x19 | type), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
            stream.write(bytes, 0, 3);
        } else {
            byte[] bytes = new byte[]{(byte)(0x1A | type), (byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
            stream.write(bytes, 0, 5);
        }
    }

    public static void Write(short value, OutputStream stream) throws IOException {
        CBORObject.Write((long)value, stream);
    }

    public static void Write(boolean value, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        stream.write(value ? -11 : -12);
    }

    public static void Write(byte value, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if ((value & 0xFF) < 24) {
            stream.write(value);
        } else {
            stream.write(24);
            stream.write(value);
        }
    }

    public static void Write(float value, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        byte[] data = CBORObject.GetDoubleBytes(value, 0);
        stream.write(data, 0, data.length);
    }

    public static void Write(double value, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        byte[] data = CBORObject.GetDoubleBytes(CBORUtilities.DoubleToInt64Bits(value), 0);
        stream.write(data, 0, data.length);
    }

    public static void Write(CBORObject value, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (value == null) {
            stream.write(246);
        } else {
            value.WriteTo(stream);
        }
    }

    public static void Write(Object objValue, OutputStream stream) throws IOException {
        CBORObject.Write(objValue, stream, CBOREncodeOptions.Default);
    }

    public static void Write(Object objValue, OutputStream output, CBOREncodeOptions options) throws IOException {
        byte[] data;
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (output == null) {
            throw new NullPointerException("output");
        }
        if (objValue == null) {
            output.write(246);
            return;
        }
        if (options.getCtap2Canonical()) {
            CBORObject.FromObject(objValue).WriteTo(output, options);
            return;
        }
        byte[] byArray = data = objValue instanceof byte[] ? (byte[])objValue : null;
        if (data != null) {
            CBORObject.WritePositiveInt(3, data.length, output);
            output.write(data, 0, data.length);
            return;
        }
        if (objValue instanceof List) {
            CBORObject.WriteObjectArray((List)objValue, output, options);
            return;
        }
        if (objValue instanceof Map) {
            CBORObject.WriteObjectMap((Map)objValue, output, options);
            return;
        }
        CBORObject.FromObject(objValue).WriteTo(output, options);
    }

    public static void WriteJSON(Object obj, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        if (obj == null) {
            outputStream.write(ValueNullBytes, 0, ValueNullBytes.length);
            return;
        }
        if (obj instanceof Boolean) {
            if (((Boolean)obj).booleanValue()) {
                outputStream.write(ValueTrueBytes, 0, ValueTrueBytes.length);
                return;
            }
            outputStream.write(ValueFalseBytes, 0, ValueFalseBytes.length);
            return;
        }
        CBORObject.FromObject(obj).WriteJSONTo(outputStream);
    }

    public CBORObject Abs() {
        ERational rat;
        Object newItem;
        CBORNumber cn = CBORNumber.FromCBORObject(this);
        if (cn == null) {
            throw new IllegalStateException("This Object is not a number.");
        }
        Object oldItem = cn.GetValue();
        if (oldItem == (newItem = cn.GetNumberInterface().Abs(oldItem))) {
            return this;
        }
        if (newItem instanceof EDecimal) {
            return CBORObject.FromObject((EDecimal)newItem);
        }
        if (newItem instanceof EInteger) {
            return CBORObject.FromObject((EInteger)newItem);
        }
        if (newItem instanceof EFloat) {
            return CBORObject.FromObject((EFloat)newItem);
        }
        ERational eRational = rat = newItem instanceof ERational ? (ERational)newItem : null;
        return rat != null ? CBORObject.FromObject(rat) : (oldItem == newItem ? this : CBORObject.FromObject(newItem));
    }

    public CBORObject Add(Object key, Object valueOb) {
        Map<CBORObject, CBORObject> map;
        CBORObject mapValue;
        CBORObject mapKey;
        if (this.getItemType() == 5) {
            if (key == null) {
                mapKey = Null;
            } else {
                mapKey = key instanceof CBORObject ? (CBORObject)key : null;
                CBORObject cBORObject = mapKey = mapKey == null ? CBORObject.FromObject(key) : mapKey;
            }
            if (valueOb == null) {
                mapValue = Null;
            } else {
                mapValue = valueOb instanceof CBORObject ? (CBORObject)valueOb : null;
                mapValue = mapValue == null ? CBORObject.FromObject(valueOb) : mapValue;
            }
            map = this.AsMap();
            if (map.containsKey(mapKey)) {
                throw new IllegalArgumentException("Key already exists");
            }
        } else {
            throw new IllegalStateException("Not a map");
        }
        map.put(mapKey, mapValue);
        return this;
    }

    public CBORObject Add(CBORObject obj) {
        if (this.getItemType() == 4) {
            List<CBORObject> list = this.AsList();
            list.add(obj);
            return this;
        }
        throw new IllegalStateException("Not an array");
    }

    public CBORObject Add(Object obj) {
        if (this.getItemType() == 4) {
            List<CBORObject> list = this.AsList();
            list.add(CBORObject.FromObject(obj));
            return this;
        }
        throw new IllegalStateException("Not an array");
    }

    public EInteger AsEInteger() {
        CBORNumber cn = CBORNumber.FromCBORObject(this);
        if (cn == null) {
            throw new IllegalStateException("Not a number type");
        }
        return cn.GetNumberInterface().AsEInteger(cn.GetValue());
    }

    public boolean AsBoolean() {
        return !this.isFalse() && !this.isNull() && !this.isUndefined();
    }

    public byte AsByte() {
        return (byte)this.AsInt32(0, 255);
    }

    public double AsDouble() {
        CBORNumber cn = CBORNumber.FromCBORObject(this);
        if (cn == null) {
            throw new IllegalStateException("Not a number type");
        }
        return cn.GetNumberInterface().AsDouble(cn.GetValue());
    }

    public EDecimal AsEDecimal() {
        CBORNumber cn = this.AsNumber();
        return cn.GetNumberInterface().AsExtendedDecimal(cn.GetValue());
    }

    public EFloat AsEFloat() {
        CBORNumber cn = CBORNumber.FromCBORObject(this);
        if (cn == null) {
            throw new IllegalStateException("Not a number type");
        }
        return cn.GetNumberInterface().AsExtendedFloat(cn.GetValue());
    }

    public ERational AsERational() {
        ERational ret = this.GetERational();
        if (ret != null) {
            return ret;
        }
        CBORNumber cn = CBORNumber.FromCBORObject(this);
        if (cn == null) {
            throw new IllegalStateException("Not a number type");
        }
        return cn.GetNumberInterface().AsExtendedRational(cn.GetValue());
    }

    private ERational GetERational() {
        return this.HasMostInnerTag(30) && this.size() == 2 ? ERational.Create(this.get(0).AsEInteger(), this.get(1).AsEInteger()) : null;
    }

    public short AsInt16() {
        return (short)this.AsInt32(Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public int AsInt32Value() {
        switch (this.getItemType()) {
            case 0: {
                long longValue = (Long)this.getThisItem();
                if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
                    throw new ArithmeticException();
                }
                return (int)longValue;
            }
            case 1: {
                EInteger ei = (EInteger)this.getThisItem();
                return ei.ToInt32Checked();
            }
        }
        throw new IllegalStateException("Not an integer type");
    }

    public long AsInt64Value() {
        switch (this.getItemType()) {
            case 0: {
                return (Long)this.getThisItem();
            }
            case 1: {
                EInteger ei = (EInteger)this.getThisItem();
                return ei.ToInt64Checked();
            }
        }
        throw new IllegalStateException("Not an integer type");
    }

    public boolean CanValueFitInInt64() {
        switch (this.getItemType()) {
            case 0: {
                return true;
            }
            case 1: {
                EInteger ei = (EInteger)this.getThisItem();
                return ei.CanFitInInt64();
            }
        }
        return false;
    }

    public boolean CanValueFitInInt32() {
        switch (this.getItemType()) {
            case 0: {
                long elong = (Long)this.getThisItem();
                return elong >= Integer.MIN_VALUE && elong <= Integer.MAX_VALUE;
            }
            case 1: {
                EInteger ei = (EInteger)this.getThisItem();
                return ei.CanFitInInt32();
            }
        }
        return false;
    }

    public EInteger AsEIntegerValue() {
        switch (this.getItemType()) {
            case 0: {
                return EInteger.FromInt64((Long)this.getThisItem());
            }
            case 1: {
                return (EInteger)this.getThisItem();
            }
        }
        throw new IllegalStateException("Not an integer type");
    }

    public long AsDoubleBits() {
        switch (this.getType()) {
            case FloatingPoint: {
                return (Long)this.getThisItem();
            }
        }
        throw new IllegalStateException("Not a floating-point type");
    }

    public double AsDoubleValue() {
        switch (this.getType()) {
            case FloatingPoint: {
                return CBORUtilities.Int64BitsToDouble((Long)this.getThisItem());
            }
        }
        throw new IllegalStateException("Not a floating-point type");
    }

    public CBORNumber AsNumber() {
        CBORNumber num = CBORNumber.FromCBORObject(this);
        if (num == null) {
            throw new IllegalStateException("Not a number type");
        }
        return num;
    }

    public int AsInt32() {
        return this.AsInt32(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public long AsInt64() {
        CBORNumber cn = this.AsNumber();
        return cn.GetNumberInterface().AsInt64(cn.GetValue());
    }

    public float AsSingle() {
        CBORNumber cn = this.AsNumber();
        return cn.GetNumberInterface().AsSingle(cn.GetValue());
    }

    public String AsString() {
        int type = this.getItemType();
        switch (type) {
            case 3: {
                return (String)this.getThisItem();
            }
        }
        throw new IllegalStateException("Not a String type");
    }

    public boolean CanFitInDouble() {
        CBORNumber cn = CBORNumber.FromCBORObject(this);
        return cn != null && cn.GetNumberInterface().CanFitInDouble(cn.GetValue());
    }

    public boolean CanFitInInt32() {
        if (!this.CanFitInInt64()) {
            return false;
        }
        long v = this.AsInt64();
        return v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE;
    }

    public boolean CanFitInInt64() {
        CBORNumber cn = CBORNumber.FromCBORObject(this);
        return cn != null && cn.GetNumberInterface().CanFitInInt64(cn.GetValue());
    }

    public boolean CanFitInSingle() {
        CBORNumber cn = CBORNumber.FromCBORObject(this);
        return cn != null && cn.GetNumberInterface().CanFitInSingle(cn.GetValue());
    }

    public boolean CanTruncatedIntFitInInt32() {
        CBORNumber cn = CBORNumber.FromCBORObject(this);
        return cn != null && cn.GetNumberInterface().CanTruncatedIntFitInInt32(cn.GetValue());
    }

    public boolean CanTruncatedIntFitInInt64() {
        CBORNumber cn = CBORNumber.FromCBORObject(this);
        return cn != null && cn.GetNumberInterface().CanTruncatedIntFitInInt64(cn.GetValue());
    }

    @Override
    public int compareTo(CBORObject other) {
        int cmp;
        block16: {
            int typeB;
            int typeA;
            block15: {
                if (other == null) {
                    return 1;
                }
                if (this == other) {
                    return 0;
                }
                typeA = this.itemtypeValue;
                typeB = other.itemtypeValue;
                Object objA = this.itemValue;
                Object objB = other.itemValue;
                if (typeA != typeB) break block15;
                switch (typeA) {
                    case 0: {
                        long a = (Long)objA;
                        long b = (Long)objB;
                        cmp = a >= 0L && b >= 0L ? (a == b ? 0 : (a < b ? -1 : 1)) : (a <= 0L && b <= 0L ? (a == b ? 0 : (a < b ? 1 : -1)) : (a < 0L && b >= 0L ? 1 : -1));
                        break block16;
                    }
                    case 1: {
                        cmp = CBORUtilities.ByteArrayCompare(this.EncodeToBytes(), other.EncodeToBytes());
                        break block16;
                    }
                    case 2: {
                        cmp = CBORUtilities.ByteArrayCompareLengthFirst((byte[])objA, (byte[])objB);
                        break block16;
                    }
                    case 3: {
                        cmp = CBORUtilities.FastPathStringCompare((String)objA, (String)objB);
                        if (cmp < -1) {
                            cmp = CBORUtilities.ByteArrayCompare(this.EncodeToBytes(), other.EncodeToBytes());
                        }
                        break block16;
                    }
                    case 4: {
                        cmp = CBORObject.ListCompare((ArrayList)objA, (ArrayList)objB);
                        break block16;
                    }
                    case 5: {
                        cmp = CBORObject.MapCompare((Map)objA, (Map)objB);
                        break block16;
                    }
                    case 6: {
                        cmp = this.getMostOuterTag().compareTo(other.getMostOuterTag());
                        if (cmp == 0) {
                            cmp = ((CBORObject)objA).compareTo((CBORObject)objB);
                        }
                        break block16;
                    }
                    case 7: {
                        int valueA = (Integer)objA;
                        int valueB = (Integer)objB;
                        cmp = valueA == valueB ? 0 : (valueA < valueB ? -1 : 1);
                        break block16;
                    }
                    case 8: {
                        cmp = CBORUtilities.ByteArrayCompare(CBORObject.GetDoubleBytes(this.AsDoubleBits(), 0), CBORObject.GetDoubleBytes(other.AsDoubleBits(), 0));
                        break block16;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected data type");
                    }
                }
            }
            cmp = typeB == 0 && typeA == 1 || typeA == 0 && typeB == 1 ? CBORUtilities.ByteArrayCompare(this.EncodeToBytes(), other.EncodeToBytes()) : (typeA < typeB ? -1 : 1);
        }
        return cmp;
    }

    public int CompareToIgnoreTags(CBORObject other) {
        return other == null ? 1 : (this == other ? 0 : this.Untag().compareTo(other.Untag()));
    }

    public boolean ContainsKey(Object objKey) {
        return this.getItemType() == 5 ? this.ContainsKey(CBORObject.FromObject(objKey)) : false;
    }

    public boolean ContainsKey(CBORObject key) {
        CBORObject cBORObject = key = key == null ? Null : key;
        if (this.getItemType() == 5) {
            Map<CBORObject, CBORObject> map = this.AsMap();
            return map.containsKey(key);
        }
        return false;
    }

    public boolean ContainsKey(String key) {
        if (this.getItemType() == 5) {
            CBORObject ckey = key == null ? Null : CBORObject.FromObject(key);
            Map<CBORObject, CBORObject> map = this.AsMap();
            return map.containsKey(ckey);
        }
        return false;
    }

    private static byte[] GetDoubleBytes(long valueBits, int tagbyte) {
        byte[] byArray;
        int bits = CBORUtilities.DoubleToHalfPrecisionIfSameValue(valueBits);
        if (bits != -1) {
            byte[] byArray2;
            if (tagbyte != 0) {
                byte[] byArray3 = new byte[4];
                byArray3[0] = (byte)tagbyte;
                byArray3[1] = -7;
                byArray3[2] = (byte)(bits >> 8 & 0xFF);
                byArray2 = byArray3;
                byArray3[3] = (byte)(bits & 0xFF);
            } else {
                byte[] byArray4 = new byte[3];
                byArray4[0] = -7;
                byArray4[1] = (byte)(bits >> 8 & 0xFF);
                byArray2 = byArray4;
                byArray4[2] = (byte)(bits & 0xFF);
            }
            return byArray2;
        }
        if (CBORUtilities.DoubleRetainsSameValueInSingle(valueBits)) {
            byte[] byArray5;
            bits = CBORUtilities.DoubleToRoundedSinglePrecision(valueBits);
            if (tagbyte != 0) {
                byte[] byArray6 = new byte[6];
                byArray6[0] = (byte)tagbyte;
                byArray6[1] = -6;
                byArray6[2] = (byte)(bits >> 24 & 0xFF);
                byArray6[3] = (byte)(bits >> 16 & 0xFF);
                byArray6[4] = (byte)(bits >> 8 & 0xFF);
                byArray5 = byArray6;
                byArray6[5] = (byte)(bits & 0xFF);
            } else {
                byte[] byArray7 = new byte[5];
                byArray7[0] = -6;
                byArray7[1] = (byte)(bits >> 24 & 0xFF);
                byArray7[2] = (byte)(bits >> 16 & 0xFF);
                byArray7[3] = (byte)(bits >> 8 & 0xFF);
                byArray5 = byArray7;
                byArray7[4] = (byte)(bits & 0xFF);
            }
            return byArray5;
        }
        if (tagbyte != 0) {
            byte[] byArray8 = new byte[10];
            byArray8[0] = (byte)tagbyte;
            byArray8[1] = -5;
            byArray8[2] = (byte)(valueBits >> 56 & 0xFFL);
            byArray8[3] = (byte)(valueBits >> 48 & 0xFFL);
            byArray8[4] = (byte)(valueBits >> 40 & 0xFFL);
            byArray8[5] = (byte)(valueBits >> 32 & 0xFFL);
            byArray8[6] = (byte)(valueBits >> 24 & 0xFFL);
            byArray8[7] = (byte)(valueBits >> 16 & 0xFFL);
            byArray8[8] = (byte)(valueBits >> 8 & 0xFFL);
            byArray = byArray8;
            byArray8[9] = (byte)(valueBits & 0xFFL);
        } else {
            byte[] byArray9 = new byte[9];
            byArray9[0] = -5;
            byArray9[1] = (byte)(valueBits >> 56 & 0xFFL);
            byArray9[2] = (byte)(valueBits >> 48 & 0xFFL);
            byArray9[3] = (byte)(valueBits >> 40 & 0xFFL);
            byArray9[4] = (byte)(valueBits >> 32 & 0xFFL);
            byArray9[5] = (byte)(valueBits >> 24 & 0xFFL);
            byArray9[6] = (byte)(valueBits >> 16 & 0xFFL);
            byArray9[7] = (byte)(valueBits >> 8 & 0xFFL);
            byArray = byArray9;
            byArray9[8] = (byte)(valueBits & 0xFFL);
        }
        return byArray;
    }

    private static byte[] GetDoubleBytes(float value, int tagbyte) {
        byte[] byArray;
        int bits = CBORUtilities.SingleToHalfPrecisionIfSameValue(value);
        if (bits != -1) {
            byte[] byArray2;
            if (tagbyte != 0) {
                byte[] byArray3 = new byte[4];
                byArray3[0] = (byte)tagbyte;
                byArray3[1] = -7;
                byArray3[2] = (byte)(bits >> 8 & 0xFF);
                byArray2 = byArray3;
                byArray3[3] = (byte)(bits & 0xFF);
            } else {
                byte[] byArray4 = new byte[3];
                byArray4[0] = -7;
                byArray4[1] = (byte)(bits >> 8 & 0xFF);
                byArray2 = byArray4;
                byArray4[2] = (byte)(bits & 0xFF);
            }
            return byArray2;
        }
        bits = CBORUtilities.SingleToInt32Bits(value);
        if (tagbyte != 0) {
            byte[] byArray5 = new byte[6];
            byArray5[0] = (byte)tagbyte;
            byArray5[1] = -6;
            byArray5[2] = (byte)(bits >> 24 & 0xFF);
            byArray5[3] = (byte)(bits >> 16 & 0xFF);
            byArray5[4] = (byte)(bits >> 8 & 0xFF);
            byArray = byArray5;
            byArray5[5] = (byte)(bits & 0xFF);
        } else {
            byte[] byArray6 = new byte[5];
            byArray6[0] = -6;
            byArray6[1] = (byte)(bits >> 24 & 0xFF);
            byArray6[2] = (byte)(bits >> 16 & 0xFF);
            byArray6[3] = (byte)(bits >> 8 & 0xFF);
            byArray = byArray6;
            byArray6[4] = (byte)(bits & 0xFF);
        }
        return byArray;
    }

    public byte[] EncodeToBytes() {
        return this.EncodeToBytes(CBOREncodeOptions.Default);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] EncodeToBytes(CBOREncodeOptions options) {
        byte[] byArray;
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (options.getCtap2Canonical()) {
            return CBORCanonical.CtapCanonicalEncode(this);
        }
        boolean hasComplexTag = false;
        byte tagbyte = 0;
        boolean tagged = this.isTagged();
        if (this.isTagged()) {
            CBORObject taggedItem = (CBORObject)this.itemValue;
            if (taggedItem.isTagged() || this.tagHigh != 0 || this.tagLow >> 16 != 0 || this.tagLow >= 24) {
                hasComplexTag = true;
            } else {
                tagbyte = (byte)(192 + this.tagLow);
            }
        }
        if (!hasComplexTag) {
            switch (this.getItemType()) {
                case 3: {
                    byte[] ret = CBORObject.GetOptimizedBytesIfShortAscii(this.AsString(), tagged ? tagbyte & 0xFF : -1);
                    if (ret == null) break;
                    return ret;
                }
                case 7: {
                    if (tagged) {
                        byte[] simpleBytes = new byte[]{tagbyte, -12};
                        if (this.isFalse()) {
                            simpleBytes[1] = -12;
                            return simpleBytes;
                        }
                        if (this.isTrue()) {
                            simpleBytes[1] = -11;
                            return simpleBytes;
                        }
                        if (this.isNull()) {
                            simpleBytes[1] = -10;
                            return simpleBytes;
                        }
                        if (!this.isUndefined()) break;
                        simpleBytes[1] = -9;
                        return simpleBytes;
                    }
                    if (this.isFalse()) {
                        return new byte[]{-12};
                    }
                    if (this.isTrue()) {
                        return new byte[]{-11};
                    }
                    if (this.isNull()) {
                        return new byte[]{-10};
                    }
                    if (!this.isUndefined()) break;
                    return new byte[]{-9};
                }
                case 0: {
                    long value = (Long)this.getThisItem();
                    byte[] intBytes = null;
                    if (value >= 0L) {
                        intBytes = CBORObject.GetPositiveInt64Bytes(0, value);
                    } else {
                        ++value;
                        value = -value;
                        intBytes = CBORObject.GetPositiveInt64Bytes(1, value);
                    }
                    if (!tagged) {
                        return intBytes;
                    }
                    byte[] ret2 = new byte[intBytes.length + 1];
                    System.arraycopy(intBytes, 0, ret2, 1, intBytes.length);
                    ret2[0] = tagbyte;
                    return ret2;
                }
                case 8: {
                    return CBORObject.GetDoubleBytes(this.AsDoubleBits(), tagbyte & 0xFF);
                }
            }
        }
        ByteArrayOutputStream ms = null;
        try {
            ms = new ByteArrayOutputStream(16);
            this.WriteTo(ms, options);
            byArray = ms.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (ms != null) {
                        ms.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new CBORException("I/O Error occurred", ex);
            }
        }
        try {
            if (ms != null) {
                ms.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    public boolean equals(Object obj) {
        return this.equals(obj instanceof CBORObject ? (CBORObject)obj : null);
    }

    public boolean equals(CBORObject other) {
        CBORObject otherValue;
        CBORObject cBORObject = otherValue = other instanceof CBORObject ? other : null;
        if (otherValue == null) {
            return false;
        }
        if (this == otherValue) {
            return true;
        }
        if (this.itemtypeValue != otherValue.itemtypeValue) {
            return false;
        }
        switch (this.itemtypeValue) {
            case 2: {
                return CBORUtilities.ByteArrayEquals((byte[])this.itemValue, otherValue.itemValue instanceof byte[] ? (byte[])otherValue.itemValue : null);
            }
            case 5: {
                Map cbordict = otherValue.itemValue instanceof Map ? (Map)otherValue.itemValue : null;
                return CBORObject.CBORMapEquals(this.AsMap(), cbordict);
            }
            case 4: {
                return CBORObject.CBORArrayEquals(this.AsList(), otherValue.itemValue instanceof List ? (List)otherValue.itemValue : null);
            }
            case 6: {
                return this.tagLow == otherValue.tagLow && this.tagHigh == otherValue.tagHigh && (this.itemValue == null ? otherValue.itemValue == null : this.itemValue.equals(otherValue.itemValue));
            }
            case 8: {
                return this.AsDoubleBits() == otherValue.AsDoubleBits();
            }
        }
        return this.itemValue == null ? otherValue.itemValue == null : this.itemValue.equals(otherValue.itemValue);
    }

    public byte[] GetByteString() {
        if (this.getItemType() == 2) {
            return (byte[])this.getThisItem();
        }
        throw new IllegalStateException("Not a byte String");
    }

    public int hashCode() {
        int valueHashCode = 651869431;
        if (this.itemValue != null) {
            int itemHashCode = 0;
            long longValue = 0L;
            switch (this.itemtypeValue) {
                case 2: {
                    itemHashCode = CBORUtilities.ByteArrayHashCode((byte[])this.getThisItem());
                    break;
                }
                case 5: {
                    itemHashCode = CBORObject.CBORMapHashCode(this.AsMap());
                    break;
                }
                case 4: {
                    itemHashCode = CBORObject.CBORArrayHashCode(this.AsList());
                    break;
                }
                case 3: {
                    itemHashCode = CBORObject.StringHashCode((String)this.itemValue);
                    break;
                }
                case 7: {
                    itemHashCode = (Integer)this.itemValue;
                    break;
                }
                case 8: {
                    longValue = this.AsDoubleBits();
                    longValue |= longValue >> 32;
                    itemHashCode = (int)longValue;
                    break;
                }
                case 0: {
                    longValue = (Long)this.itemValue;
                    longValue |= longValue >> 32;
                    itemHashCode = (int)longValue;
                    break;
                }
                case 6: {
                    itemHashCode = this.tagLow + this.tagHigh;
                    itemHashCode += 651869483 * this.itemValue.hashCode();
                    break;
                }
                default: {
                    itemHashCode = this.itemValue.hashCode();
                }
            }
            valueHashCode += 651869479 * itemHashCode;
        }
        return valueHashCode;
    }

    public EInteger[] GetAllTags() {
        if (!this.isTagged()) {
            return ValueEmptyTags;
        }
        CBORObject curitem = this;
        if (curitem.isTagged()) {
            ArrayList<EInteger> list = new ArrayList<EInteger>();
            while (curitem.isTagged()) {
                list.add(CBORObject.LowHighToEInteger(curitem.tagLow, curitem.tagHigh));
                curitem = (CBORObject)curitem.itemValue;
            }
            return list.toArray(new EInteger[0]);
        }
        return new EInteger[]{CBORObject.LowHighToEInteger(this.tagLow, this.tagHigh)};
    }

    public boolean HasOneTag() {
        return this.isTagged() && !((CBORObject)this.itemValue).isTagged();
    }

    public boolean HasOneTag(int tagValue) {
        return this.HasOneTag() && this.HasMostOuterTag(tagValue);
    }

    public boolean HasOneTag(EInteger bigTagValue) {
        return this.HasOneTag() && this.HasMostOuterTag(bigTagValue);
    }

    public final int getTagCount() {
        int count = 0;
        CBORObject curitem = this;
        while (curitem.isTagged()) {
            ++count;
            curitem = (CBORObject)curitem.itemValue;
        }
        return count;
    }

    public boolean HasMostInnerTag(int tagValue) {
        if (tagValue < 0) {
            throw new IllegalArgumentException("tagValue (" + tagValue + ") is less than 0");
        }
        return this.isTagged() && this.HasMostInnerTag(EInteger.FromInt32(tagValue));
    }

    public boolean HasMostInnerTag(EInteger bigTagValue) {
        if (bigTagValue == null) {
            throw new NullPointerException("bigTagValue");
        }
        if (bigTagValue.signum() < 0) {
            throw new IllegalArgumentException("bigTagValue (" + bigTagValue + ") is less than 0");
        }
        return !this.isTagged() ? false : this.getMostInnerTag().equals(bigTagValue);
    }

    public boolean HasMostOuterTag(int tagValue) {
        if (tagValue < 0) {
            throw new IllegalArgumentException("tagValue (" + tagValue + ") is less than 0");
        }
        return this.isTagged() && this.tagHigh == 0 && this.tagLow == tagValue;
    }

    public boolean HasMostOuterTag(EInteger bigTagValue) {
        if (bigTagValue == null) {
            throw new NullPointerException("bigTagValue");
        }
        if (bigTagValue.signum() < 0) {
            throw new IllegalArgumentException("bigTagValue (" + bigTagValue + ") is less than 0");
        }
        return !this.isTagged() ? false : this.getMostOuterTag().equals(bigTagValue);
    }

    public boolean HasTag(int tagValue) {
        if (tagValue < 0) {
            throw new IllegalArgumentException("tagValue (" + tagValue + ") is less than 0");
        }
        CBORObject obj = this;
        while (obj.isTagged()) {
            if (obj.tagHigh == 0 && tagValue == obj.tagLow) {
                return true;
            }
            obj = (CBORObject)obj.itemValue;
        }
        return false;
    }

    public boolean HasTag(EInteger bigTagValue) {
        EInteger[] bigTags;
        if (bigTagValue == null) {
            throw new NullPointerException("bigTagValue");
        }
        if (bigTagValue.signum() < 0) {
            throw new IllegalArgumentException("doesn't satisfy bigTagValue.signum()>= 0");
        }
        for (EInteger bigTag : bigTags = this.GetAllTags()) {
            if (!bigTagValue.equals(bigTag)) continue;
            return true;
        }
        return false;
    }

    public CBORObject Insert(int index, Object valueOb) {
        CBORObject mapValue;
        List<CBORObject> list;
        if (this.getItemType() == 4) {
            list = this.AsList();
            if (index < 0 || index > list.size()) {
                throw new IllegalArgumentException("index");
            }
            if (valueOb == null) {
                mapValue = Null;
            } else {
                mapValue = valueOb instanceof CBORObject ? (CBORObject)valueOb : null;
                mapValue = mapValue == null ? CBORObject.FromObject(valueOb) : mapValue;
            }
        } else {
            throw new IllegalStateException("Not an array");
        }
        list.add(index, mapValue);
        return this;
    }

    public boolean IsInfinity() {
        CBORNumber cn = CBORNumber.FromCBORObject(this);
        return cn != null && cn.GetNumberInterface().IsInfinity(cn.GetValue());
    }

    public boolean IsNaN() {
        CBORNumber cn = CBORNumber.FromCBORObject(this);
        return cn != null && cn.GetNumberInterface().IsNaN(cn.GetValue());
    }

    public boolean IsNegativeInfinity() {
        CBORNumber cn = CBORNumber.FromCBORObject(this);
        return cn != null && cn.GetNumberInterface().IsNegativeInfinity(cn.GetValue());
    }

    public boolean IsPositiveInfinity() {
        CBORNumber cn = CBORNumber.FromCBORObject(this);
        return cn != null && cn.GetNumberInterface().IsPositiveInfinity(cn.GetValue());
    }

    public CBORObject Negate() {
        CBORNumber cn = CBORNumber.FromCBORObject(this);
        if (cn == null) {
            throw new IllegalStateException("This Object is not a number.");
        }
        Object newItem = cn.GetNumberInterface().Negate(cn.GetValue());
        if (newItem instanceof EDecimal) {
            return CBORObject.FromObject((EDecimal)newItem);
        }
        if (newItem instanceof EInteger) {
            return CBORObject.FromObject((EInteger)newItem);
        }
        if (newItem instanceof EFloat) {
            return CBORObject.FromObject((EFloat)newItem);
        }
        ERational rat = newItem instanceof ERational ? (ERational)newItem : null;
        return rat != null ? CBORObject.FromObject(rat) : CBORObject.FromObject(newItem);
    }

    public void Clear() {
        if (this.getItemType() == 4) {
            List<CBORObject> list = this.AsList();
            list.clear();
        } else if (this.getItemType() == 5) {
            Map<CBORObject, CBORObject> dict = this.AsMap();
            dict.clear();
        } else {
            throw new IllegalStateException("Not a map or array");
        }
    }

    public boolean Remove(Object obj) {
        return this.Remove(CBORObject.FromObject(obj));
    }

    public boolean RemoveAt(int index) {
        if (this.getItemType() != 4) {
            throw new IllegalStateException("Not an array");
        }
        if (index < 0 || index >= this.size()) {
            return false;
        }
        List<CBORObject> list = this.AsList();
        list.remove(index);
        return true;
    }

    public boolean Remove(CBORObject obj) {
        if (obj == null) {
            throw new NullPointerException("obj");
        }
        if (this.getItemType() == 5) {
            Map<CBORObject, CBORObject> dict = this.AsMap();
            boolean hasKey = dict.containsKey(obj);
            if (hasKey) {
                dict.remove(obj);
                return true;
            }
            return false;
        }
        if (this.getItemType() == 4) {
            List<CBORObject> list = this.AsList();
            return list.remove(obj);
        }
        throw new IllegalStateException("Not a map or array");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CBORObject Set(Object key, Object valueOb) {
        if (this.getItemType() == 5) {
            CBORObject mapValue;
            CBORObject mapKey;
            if (key == null) {
                mapKey = Null;
            } else {
                mapKey = key instanceof CBORObject ? (CBORObject)key : null;
                CBORObject cBORObject = mapKey = mapKey == null ? CBORObject.FromObject(key) : mapKey;
            }
            if (valueOb == null) {
                mapValue = Null;
            } else {
                mapValue = valueOb instanceof CBORObject ? (CBORObject)valueOb : null;
                mapValue = mapValue == null ? CBORObject.FromObject(valueOb) : mapValue;
            }
            Map<CBORObject, CBORObject> map = this.AsMap();
            if (map.containsKey(mapKey)) {
                map.put(mapKey, mapValue);
                return this;
            } else {
                map.put(mapKey, mapValue);
            }
            return this;
        } else {
            CBORObject mapValue;
            if (this.getItemType() != 4) throw new IllegalStateException("Not a map or array");
            if (!(key instanceof Integer)) throw new IllegalArgumentException("Is an array, but key is not int");
            List<CBORObject> list = this.AsList();
            int index = (Integer)key;
            if (index < 0 || index >= this.size()) {
                throw new IllegalArgumentException("key");
            }
            if (valueOb == null) {
                mapValue = Null;
            } else {
                mapValue = valueOb instanceof CBORObject ? (CBORObject)valueOb : null;
                mapValue = mapValue == null ? CBORObject.FromObject(valueOb) : mapValue;
            }
            list.set(index, mapValue);
        }
        return this;
    }

    public String ToJSONString() {
        return this.ToJSONString(JSONOptions.Default);
    }

    public String ToJSONString(JSONOptions options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        CBORType type = this.getType();
        switch (type) {
            case SimpleValue: {
                return this.isTrue() ? "true" : (this.isFalse() ? "false" : "null");
            }
            case Integer: {
                return this.AsEIntegerValue().toString();
            }
            case FloatingPoint: {
                return CBORNumber.FromObject(this.AsDoubleValue()).ToJSONString();
            }
        }
        StringBuilder sb = new StringBuilder();
        try {
            CBORJson.WriteJSONToInternal(this, new StringOutput(sb), options);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Internal error", ex);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = null;
        String simvalue = null;
        CBORType type = this.getType();
        if (this.isTagged()) {
            if (sb == null) {
                if (type == CBORType.TextString) {
                    String str = this.AsString();
                    sb = new StringBuilder(Math.min(str.length(), 4096) + 16);
                } else {
                    sb = new StringBuilder();
                }
            }
            this.AppendOpeningTags(sb);
        }
        switch (type) {
            case SimpleValue: {
                if (this.isTrue()) {
                    simvalue = "true";
                    if (sb == null) {
                        return simvalue;
                    }
                    sb.append(simvalue);
                    break;
                }
                if (this.isFalse()) {
                    simvalue = "false";
                    if (sb == null) {
                        return simvalue;
                    }
                    sb.append(simvalue);
                    break;
                }
                if (this.isNull()) {
                    simvalue = "null";
                    if (sb == null) {
                        return simvalue;
                    }
                    sb.append(simvalue);
                    break;
                }
                if (this.isUndefined()) {
                    simvalue = "undefined";
                    if (sb == null) {
                        return simvalue;
                    }
                    sb.append(simvalue);
                    break;
                }
                sb = sb == null ? new StringBuilder() : sb;
                sb.append("simple(");
                int thisItemInt = (Integer)this.getThisItem();
                sb.append(CBORUtilities.LongToString(thisItemInt));
                sb.append(")");
                break;
            }
            case FloatingPoint: {
                double f = this.AsDoubleValue();
                String string = f == Double.NEGATIVE_INFINITY ? "-Infinity" : (f == Double.POSITIVE_INFINITY ? "Infinity" : (simvalue = Double.isNaN(f) ? "NaN" : CBORUtilities.TrimDotZero(CBORUtilities.DoubleToString(f))));
                if (sb == null) {
                    return simvalue;
                }
                sb.append(simvalue);
                break;
            }
            case Integer: {
                if (this.CanValueFitInInt64()) {
                    long v = this.AsInt64Value();
                    simvalue = CBORUtilities.LongToString(v);
                } else {
                    simvalue = this.AsEIntegerValue().toString();
                }
                if (sb == null) {
                    return simvalue;
                }
                sb.append(simvalue);
                break;
            }
            case ByteString: {
                sb = sb == null ? new StringBuilder() : sb;
                sb.append("h'");
                CBORUtilities.ToBase16(sb, (byte[])this.getThisItem());
                sb.append("'");
                break;
            }
            case TextString: {
                if (sb == null) {
                    return "\"" + this.AsString() + "\"";
                }
                sb.append('\"');
                sb.append(this.AsString());
                sb.append('\"');
                break;
            }
            case Array: {
                sb = sb == null ? new StringBuilder() : sb;
                boolean first = true;
                sb.append("[");
                for (CBORObject i : this.AsList()) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(i.toString());
                    first = false;
                }
                sb.append("]");
                break;
            }
            case Map: {
                sb = sb == null ? new StringBuilder() : sb;
                boolean first = true;
                sb.append("{");
                Map<CBORObject, CBORObject> map = this.AsMap();
                for (Map.Entry<CBORObject, CBORObject> entry : map.entrySet()) {
                    CBORObject key = entry.getKey();
                    CBORObject value = entry.getValue();
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(key.toString());
                    sb.append(": ");
                    sb.append(value.toString());
                    first = false;
                }
                sb.append("}");
                break;
            }
            default: {
                if (sb == null) {
                    return this.getThisItem().toString();
                }
                sb.append(this.getThisItem().toString());
            }
        }
        if (this.isTagged()) {
            this.AppendClosingTags(sb);
        }
        return sb.toString();
    }

    public CBORObject Untag() {
        CBORObject curobject = this;
        while (curobject.itemtypeValue == 6) {
            curobject = (CBORObject)curobject.itemValue;
        }
        return curobject;
    }

    public CBORObject UntagOne() {
        return this.itemtypeValue == 6 ? (CBORObject)this.itemValue : this;
    }

    public void WriteJSONTo(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        CBORJson.WriteJSONToInternal(this, new StringOutput(outputStream), JSONOptions.Default);
    }

    public void WriteJSONTo(OutputStream outputStream, JSONOptions options) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        CBORJson.WriteJSONToInternal(this, new StringOutput(outputStream), options);
    }

    public static CBORObject FromFloatingPointBits(long floatingBits, int byteCount) {
        switch (byteCount) {
            case 2: {
                long value = CBORUtilities.HalfToDoublePrecision((int)(floatingBits & 0xFFFFL));
                return new CBORObject(8, value);
            }
            case 4: {
                long value = CBORUtilities.SingleToDoublePrecision((int)(floatingBits & 0xFFFFL));
                return new CBORObject(8, value);
            }
            case 8: {
                return new CBORObject(8, floatingBits);
            }
        }
        throw new IllegalArgumentException("byteCount");
    }

    public static int WriteFloatingPointBits(OutputStream outputStream, long floatingBits, int byteCount) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        switch (byteCount) {
            case 2: {
                byte[] bytes = new byte[]{-7, (byte)(floatingBits >> 8 & 0xFFL), (byte)(floatingBits & 0xFFL)};
                outputStream.write(bytes, 0, 3);
                return 3;
            }
            case 4: {
                byte[] bytes = new byte[]{-6, (byte)(floatingBits >> 24 & 0xFFL), (byte)(floatingBits >> 16 & 0xFFL), (byte)(floatingBits >> 8 & 0xFFL), (byte)(floatingBits & 0xFFL)};
                outputStream.write(bytes, 0, 5);
                return 5;
            }
            case 8: {
                byte[] bytes = new byte[]{-5, (byte)(floatingBits >> 56 & 0xFFL), (byte)(floatingBits >> 48 & 0xFFL), (byte)(floatingBits >> 40 & 0xFFL), (byte)(floatingBits >> 32 & 0xFFL), (byte)(floatingBits >> 24 & 0xFFL), (byte)(floatingBits >> 16 & 0xFFL), (byte)(floatingBits >> 8 & 0xFFL), (byte)(floatingBits & 0xFFL)};
                outputStream.write(bytes, 0, 9);
                return 9;
            }
        }
        throw new IllegalArgumentException("byteCount");
    }

    public static int WriteFloatingPointValue(OutputStream outputStream, double doubleVal, int byteCount) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        long bits = 0L;
        switch (byteCount) {
            case 2: {
                bits = CBORUtilities.DoubleToInt64Bits(doubleVal);
                bits = CBORUtilities.DoubleToRoundedHalfPrecision(bits);
                return CBORObject.WriteFloatingPointBits(outputStream, bits &= 0xFFFFL, 2);
            }
            case 4: {
                bits = CBORUtilities.DoubleToInt64Bits(doubleVal);
                bits = CBORUtilities.DoubleToRoundedSinglePrecision(bits);
                return CBORObject.WriteFloatingPointBits(outputStream, bits &= 0xFFFFFFFFL, 4);
            }
            case 8: {
                bits = CBORUtilities.DoubleToInt64Bits(doubleVal);
                return CBORObject.WriteFloatingPointBits(outputStream, bits, 8);
            }
        }
        throw new IllegalArgumentException("byteCount");
    }

    public static int WriteFloatingPointValue(OutputStream outputStream, float singleVal, int byteCount) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        int bits = 0;
        long longbits = 0L;
        switch (byteCount) {
            case 2: {
                bits = Float.floatToRawIntBits(singleVal);
                bits = CBORUtilities.SingleToRoundedHalfPrecision(bits);
                return CBORObject.WriteFloatingPointBits(outputStream, bits &= 0xFFFF, 2);
            }
            case 4: {
                bits = Float.floatToRawIntBits(singleVal);
                longbits = (long)bits & 0xFFFFFFFFL;
                return CBORObject.WriteFloatingPointBits(outputStream, longbits, 4);
            }
            case 8: {
                bits = Float.floatToRawIntBits(singleVal);
                longbits = CBORUtilities.SingleToDoublePrecision(bits);
                return CBORObject.WriteFloatingPointBits(outputStream, longbits, 8);
            }
        }
        throw new IllegalArgumentException("byteCount");
    }

    public static int WriteValue(OutputStream outputStream, int majorType, long value) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        if (majorType < 0) {
            throw new IllegalArgumentException("majorType (" + majorType + ") is less than 0");
        }
        if (majorType > 7) {
            throw new IllegalArgumentException("majorType (" + majorType + ") is more than 7");
        }
        if (value < 0L) {
            throw new IllegalArgumentException("value (" + value + ") is less than 0");
        }
        if (majorType == 7) {
            if (value > 255L) {
                throw new IllegalArgumentException("value (" + value + ") is more than 255");
            }
            if (value <= 23L) {
                outputStream.write((byte)(224 + (int)value));
                return 1;
            }
            if (value < 32L) {
                throw new IllegalArgumentException("value is from 24 to 31 and major type is 7");
            }
            outputStream.write(-8);
            outputStream.write((byte)value);
            return 2;
        }
        return CBORObject.WritePositiveInt64(majorType, value, outputStream);
    }

    public static int WriteValue(OutputStream outputStream, int majorType, int value) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        if (majorType < 0) {
            throw new IllegalArgumentException("majorType (" + majorType + ") is less than 0");
        }
        if (majorType > 7) {
            throw new IllegalArgumentException("majorType (" + majorType + ") is more than 7");
        }
        if (value < 0) {
            throw new IllegalArgumentException("value (" + value + ") is less than 0");
        }
        if (majorType == 7) {
            if (value > 255) {
                throw new IllegalArgumentException("value (" + value + ") is more than 255");
            }
            if (value <= 23) {
                outputStream.write((byte)(224 + value));
                return 1;
            }
            if (value < 32) {
                throw new IllegalArgumentException("value is from 24 to 31 and major type is 7");
            }
            outputStream.write(-8);
            outputStream.write((byte)value);
            return 2;
        }
        return CBORObject.WritePositiveInt(majorType, value, outputStream);
    }

    public static int WriteValue(OutputStream outputStream, int majorType, EInteger bigintValue) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        if (bigintValue == null) {
            throw new NullPointerException("bigintValue");
        }
        if (bigintValue.signum() < 0) {
            throw new IllegalArgumentException("tagEInt's sign (" + bigintValue.signum() + ") is less than 0");
        }
        if (bigintValue.compareTo(UInt64MaxValue) > 0) {
            throw new IllegalArgumentException("tag more than 18446744073709551615 (" + bigintValue + ")");
        }
        if (bigintValue.CanFitInInt64()) {
            return CBORObject.WriteValue(outputStream, majorType, bigintValue.ToInt64Checked());
        }
        long longVal = bigintValue.ToInt64Unchecked();
        int highbyte = (int)(longVal >> 56 & 0xFFL);
        if (majorType < 0) {
            throw new IllegalArgumentException("majorType (" + majorType + ") is less than 0");
        }
        if (majorType > 7) {
            throw new IllegalArgumentException("majorType (" + majorType + ") is more than 7");
        }
        if (majorType == 7) {
            throw new IllegalArgumentException("majorType is 7 and value is greater than 255");
        }
        byte[] bytes = new byte[]{(byte)(0x1B | majorType << 5), (byte)highbyte, (byte)(longVal >> 48 & 0xFFL), (byte)(longVal >> 40 & 0xFFL), (byte)(longVal >> 32 & 0xFFL), (byte)(longVal >> 24 & 0xFFL), (byte)(longVal >> 16 & 0xFFL), (byte)(longVal >> 8 & 0xFFL), (byte)(longVal & 0xFFL)};
        outputStream.write(bytes, 0, bytes.length);
        return bytes.length;
    }

    public void WriteTo(OutputStream stream) throws IOException {
        this.WriteTo(stream, CBOREncodeOptions.Default);
    }

    public void WriteTo(OutputStream stream, CBOREncodeOptions options) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (options.getCtap2Canonical()) {
            byte[] bytes = CBORCanonical.CtapCanonicalEncode(this);
            stream.write(bytes, 0, bytes.length);
            return;
        }
        this.WriteTags(stream);
        int type = this.getItemType();
        switch (type) {
            case 0: {
                CBORObject.Write((Long)this.getThisItem(), stream);
                break;
            }
            case 1: {
                CBORObject.Write((EInteger)this.getThisItem(), stream);
                break;
            }
            case 2: {
                byte[] arr = (byte[])this.getThisItem();
                CBORObject.WritePositiveInt(this.getItemType() == 2 ? 2 : 3, arr.length, stream);
                stream.write(arr, 0, arr.length);
                break;
            }
            case 3: {
                CBORObject.Write((String)this.getThisItem(), stream, options);
                break;
            }
            case 4: {
                CBORObject.WriteObjectArray(this.AsList(), stream, options);
                break;
            }
            case 5: {
                CBORObject.WriteObjectMap(this.AsMap(), stream, options);
                break;
            }
            case 7: {
                int value = (Integer)this.getThisItem();
                if (value < 24) {
                    stream.write((byte)(224 + value));
                    break;
                }
                stream.write(248);
                stream.write((byte)value);
                break;
            }
            case 8: {
                byte[] data = CBORObject.GetDoubleBytes(this.AsDoubleBits(), 0);
                stream.write(data, 0, data.length);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected data type");
            }
        }
    }

    static CBORObject FromRaw(byte[] bytes) {
        return new CBORObject(2, bytes);
    }

    static CBORObject FromRaw(String str) {
        return new CBORObject(3, str);
    }

    static CBORObject FromRaw(List<CBORObject> list) {
        return new CBORObject(4, list);
    }

    static CBORObject FromRaw(Map<CBORObject, CBORObject> map) {
        return new CBORObject(5, map);
    }

    static int GetExpectedLength(int value) {
        return ValueExpectedLengths[value];
    }

    static CBORObject GetFixedLengthObject(int firstbyte, byte[] data) {
        Object ret;
        String s;
        CBORObject fixedObj = FixedObjects[firstbyte];
        if (fixedObj != null) {
            return fixedObj;
        }
        int majortype = firstbyte >> 5;
        if (firstbyte >= 97 && firstbyte < 120 && (s = CBORObject.GetOptimizedStringIfShortAscii(data, 0)) != null) {
            return new CBORObject(3, s);
        }
        if ((firstbyte & 0x1C) == 24) {
            long uadditional = 0L;
            switch (firstbyte & 0x1F) {
                case 24: {
                    uadditional = data[1] & 0xFF;
                    break;
                }
                case 25: {
                    uadditional = ((long)data[1] & 0xFFL) << 8;
                    uadditional |= (long)data[2] & 0xFFL;
                    break;
                }
                case 26: {
                    uadditional = ((long)data[1] & 0xFFL) << 24;
                    uadditional |= ((long)data[2] & 0xFFL) << 16;
                    uadditional |= ((long)data[3] & 0xFFL) << 8;
                    uadditional |= (long)data[4] & 0xFFL;
                    break;
                }
                case 27: {
                    uadditional = ((long)data[1] & 0xFFL) << 56;
                    uadditional |= ((long)data[2] & 0xFFL) << 48;
                    uadditional |= ((long)data[3] & 0xFFL) << 40;
                    uadditional |= ((long)data[4] & 0xFFL) << 32;
                    uadditional |= ((long)data[5] & 0xFFL) << 24;
                    uadditional |= ((long)data[6] & 0xFFL) << 16;
                    uadditional |= ((long)data[7] & 0xFFL) << 8;
                    uadditional |= (long)data[8] & 0xFFL;
                    break;
                }
                default: {
                    throw new CBORException("Unexpected data encountered");
                }
            }
            switch (majortype) {
                case 0: {
                    if (uadditional >> 63 == 0L) {
                        return new CBORObject(0, uadditional);
                    }
                    int low = (int)(uadditional & 0xFFFFFFFFL);
                    int high = (int)(uadditional >> 32 & 0xFFFFFFFFL);
                    return CBORObject.FromObject(CBORObject.LowHighToEInteger(low, high));
                }
                case 1: {
                    if (uadditional >> 63 == 0L) {
                        return new CBORObject(0, -1L - uadditional);
                    }
                    int low = (int)(uadditional & 0xFFFFFFFFL);
                    int high = (int)(uadditional >> 32 & 0xFFFFFFFFL);
                    EInteger bigintAdditional = CBORObject.LowHighToEInteger(low, high);
                    EInteger minusOne = EInteger.FromInt64(-1L);
                    bigintAdditional = minusOne.Subtract(bigintAdditional);
                    return CBORObject.FromObject(bigintAdditional);
                }
                case 7: {
                    if (firstbyte >= 249 && firstbyte <= 251) {
                        long dblbits = uadditional;
                        if (firstbyte == 249) {
                            dblbits = CBORUtilities.HalfToDoublePrecision((int)uadditional);
                        } else if (firstbyte == 250) {
                            dblbits = CBORUtilities.SingleToDoublePrecision((int)uadditional);
                        }
                        return new CBORObject(8, dblbits);
                    }
                    if (firstbyte == 248) {
                        if ((int)uadditional < 32) {
                            throw new CBORException("Invalid overlong simple value");
                        }
                        return new CBORObject(7, (int)uadditional);
                    }
                    throw new CBORException("Unexpected data encountered");
                }
            }
            throw new CBORException("Unexpected data encountered");
        }
        if (majortype == 2) {
            ret = new byte[firstbyte - 64];
            System.arraycopy(data, 1, ret, 0, firstbyte - 64);
            return new CBORObject(2, ret);
        }
        if (majortype == 3) {
            ret = new StringBuilder(firstbyte - 96);
            DataUtilities.ReadUtf8FromBytes(data, 1, firstbyte - 96, (StringBuilder)ret, false);
            return new CBORObject(3, ((StringBuilder)ret).toString());
        }
        if (firstbyte == 128) {
            return CBORObject.NewArray();
        }
        if (firstbyte == 160) {
            return CBORObject.NewMap();
        }
        throw new CBORException("Unexpected data encountered");
    }

    static CBORObject GetFixedObject(int value) {
        return FixedObjects[value];
    }

    List<CBORObject> AsList() {
        return (List)this.getThisItem();
    }

    Map<CBORObject, CBORObject> AsMap() {
        return (Map)this.getThisItem();
    }

    private static boolean CBORArrayEquals(List<CBORObject> listA, List<CBORObject> listB) {
        int listBCount;
        if (listA == null) {
            return listB == null;
        }
        if (listB == null) {
            return false;
        }
        int listACount = listA.size();
        if (listACount != (listBCount = listB.size())) {
            return false;
        }
        for (int i = 0; i < listACount; ++i) {
            CBORObject itemA = listA.get(i);
            CBORObject itemB = listB.get(i);
            if (itemA != null ? itemA.equals(itemB) : itemB == null) continue;
            return false;
        }
        return true;
    }

    private static int CBORArrayHashCode(List<CBORObject> list) {
        if (list == null) {
            return 0;
        }
        int ret = 19;
        int count = list.size();
        ret = ret * 31 + count;
        for (int i = 0; i < count; ++i) {
            ret = ret * 31 + list.get(i).hashCode();
        }
        return ret;
    }

    private static int StringHashCode(String str) {
        if (str == null) {
            return 0;
        }
        int ret = 19;
        int count = str.length();
        ret = ret * 31 + count;
        for (int i = 0; i < count; ++i) {
            ret = ret * 31 + str.charAt(i);
        }
        return ret;
    }

    private static boolean StringEquals(String str, String str2) {
        if (str == str2) {
            return true;
        }
        if (str.length() != str2.length()) {
            return false;
        }
        int count = str.length();
        for (int i = 0; i < count; ++i) {
            if (str.charAt(i) == str2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static boolean CBORMapEquals(Map<CBORObject, CBORObject> mapA, Map<CBORObject, CBORObject> mapB) {
        if (mapA == null) {
            return mapB == null;
        }
        if (mapB == null) {
            return false;
        }
        if (mapA.size() != mapB.size()) {
            return false;
        }
        for (Map.Entry<CBORObject, CBORObject> kvp : mapA.entrySet()) {
            boolean hasKey;
            CBORObject valueB = null;
            valueB = mapB.get(kvp.getKey());
            boolean bl = hasKey = valueB == null ? mapB.containsKey(kvp.getKey()) : true;
            if (hasKey) {
                CBORObject valueA = kvp.getValue();
                if (valueA != null ? valueA.equals(valueB) : valueB == null) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static int CBORMapHashCode(Map<CBORObject, CBORObject> a) {
        return a.size() * 19;
    }

    private static void CheckCBORLength(long expectedLength, long actualLength) {
        if (actualLength < expectedLength) {
            throw new CBORException("Premature end of data");
        }
        if (actualLength > expectedLength) {
            throw new CBORException("Too many bytes");
        }
    }

    private static void CheckCBORLength(int expectedLength, int actualLength) {
        if (actualLength < expectedLength) {
            throw new CBORException("Premature end of data");
        }
        if (actualLength > expectedLength) {
            throw new CBORException("Too many bytes");
        }
    }

    private static String ExtendedToString(EFloat ef) {
        if (ef.isFinite() && (ef.getExponent().compareTo(EInteger.FromInt64(2500L)) > 0 || ef.getExponent().compareTo(EInteger.FromInt64(-2500L)) < 0)) {
            return ef.getMantissa() + "p" + ef.getExponent();
        }
        return ef.toString();
    }

    private static byte[] GetOptimizedBytesIfShortAscii(String str, int tagbyteInt) {
        if (str.length() <= 255) {
            int extra;
            int offset = 0;
            int length = str.length();
            int n = extra = length < 24 ? 1 : 2;
            if (tagbyteInt >= 0) {
                ++extra;
            }
            byte[] bytes = new byte[length + extra];
            if (tagbyteInt >= 0) {
                bytes[offset] = (byte)tagbyteInt;
                ++offset;
            }
            if (length < 24) {
                bytes[offset] = (byte)(96 + str.length());
                ++offset;
            } else {
                bytes[offset] = 120;
                bytes[offset + 1] = (byte)str.length();
                offset += 2;
            }
            boolean issimple = true;
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c >= '\u0080') {
                    issimple = false;
                    break;
                }
                bytes[i + offset] = (byte)c;
            }
            if (issimple) {
                return bytes;
            }
        }
        return null;
    }

    private static String GetOptimizedStringIfShortAscii(byte[] data, int offset) {
        int nextbyte;
        int length = data.length;
        if (length > offset && (nextbyte = data[offset] & 0xFF) >= 96 && nextbyte < 120) {
            int offsetp1 = 1 + offset;
            int rightLength = offsetp1 + (nextbyte - 96);
            CBORObject.CheckCBORLength(rightLength, length);
            for (int i = offsetp1; i < length; ++i) {
                if ((data[i] & 0xFFFFFF80) == 0) continue;
                return null;
            }
            char[] c = new char[length - offsetp1];
            for (int i = offsetp1; i < length; ++i) {
                c[i - offsetp1] = (char)(data[i] & 0xFF);
            }
            return new String(c);
        }
        return null;
    }

    private static byte[] GetPositiveInt64Bytes(int type, long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("value (" + value + ") is less than 0");
        }
        if (value < 24L) {
            return new byte[]{(byte)((byte)value | (byte)(type << 5))};
        }
        if (value <= 255L) {
            return new byte[]{(byte)(0x18 | type << 5), (byte)(value & 0xFFL)};
        }
        if (value <= 65535L) {
            return new byte[]{(byte)(0x19 | type << 5), (byte)(value >> 8 & 0xFFL), (byte)(value & 0xFFL)};
        }
        if (value <= 0xFFFFFFFFL) {
            return new byte[]{(byte)(0x1A | type << 5), (byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value & 0xFFL)};
        }
        return new byte[]{(byte)(0x1B | type << 5), (byte)(value >> 56 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value & 0xFFL)};
    }

    private static byte[] GetPositiveIntBytes(int type, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value (" + value + ") is less than 0");
        }
        if (value < 24) {
            return new byte[]{(byte)((byte)value | (byte)(type << 5))};
        }
        if (value <= 255) {
            return new byte[]{(byte)(0x18 | type << 5), (byte)(value & 0xFF)};
        }
        if (value <= 65535) {
            return new byte[]{(byte)(0x19 | type << 5), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        }
        return new byte[]{(byte)(0x1A | type << 5), (byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    private static CBORObject[] InitializeFixedObjects() {
        int i;
        CBORObject[] fixedObjects = new CBORObject[256];
        for (i = 0; i < 24; ++i) {
            fixedObjects[i] = new CBORObject(0, i);
        }
        for (i = 32; i < 56; ++i) {
            fixedObjects[i] = new CBORObject(0, -1 - (i - 32));
        }
        fixedObjects[96] = new CBORObject(3, "");
        for (i = 224; i < 248; ++i) {
            fixedObjects[i] = new CBORObject(7, i - 224);
        }
        return fixedObjects;
    }

    private static int ListCompare(List<CBORObject> listA, List<CBORObject> listB) {
        int listBCount;
        if (listA == null) {
            return listB == null ? 0 : -1;
        }
        if (listB == null) {
            return 1;
        }
        int listACount = listA.size();
        if (listACount != (listBCount = listB.size())) {
            return listACount < listBCount ? -1 : 1;
        }
        for (int i = 0; i < listACount; ++i) {
            int cmp = listA.get(i).compareTo(listB.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private static EInteger LowHighToEInteger(int tagLow, int tagHigh) {
        byte[] uabytes = null;
        if (tagHigh != 0) {
            uabytes = new byte[9];
            uabytes[7] = (byte)(tagHigh >> 24 & 0xFF);
            uabytes[6] = (byte)(tagHigh >> 16 & 0xFF);
            uabytes[5] = (byte)(tagHigh >> 8 & 0xFF);
            uabytes[4] = (byte)(tagHigh & 0xFF);
            uabytes[3] = (byte)(tagLow >> 24 & 0xFF);
            uabytes[2] = (byte)(tagLow >> 16 & 0xFF);
            uabytes[1] = (byte)(tagLow >> 8 & 0xFF);
            uabytes[0] = (byte)(tagLow & 0xFF);
            uabytes[8] = 0;
            return EInteger.FromBytes(uabytes, true);
        }
        if (tagLow != 0) {
            uabytes = new byte[5];
            uabytes[3] = (byte)(tagLow >> 24 & 0xFF);
            uabytes[2] = (byte)(tagLow >> 16 & 0xFF);
            uabytes[1] = (byte)(tagLow >> 8 & 0xFF);
            uabytes[0] = (byte)(tagLow & 0xFF);
            uabytes[4] = 0;
            return EInteger.FromBytes(uabytes, true);
        }
        return EInteger.FromInt32(0);
    }

    private static int MapCompare(Map<CBORObject, CBORObject> mapA, Map<CBORObject, CBORObject> mapB) {
        if (mapA == null) {
            return mapB == null ? 0 : -1;
        }
        if (mapB == null) {
            return 1;
        }
        if (mapA == mapB) {
            return 0;
        }
        int listACount = mapA.size();
        int listBCount = mapB.size();
        if (listACount == 0 && listBCount == 0) {
            return 0;
        }
        if (listACount == 0) {
            return -1;
        }
        if (listBCount == 0) {
            return 1;
        }
        if (listACount != listBCount) {
            return listACount < listBCount ? -1 : 1;
        }
        ArrayList<CBORObject> sortedASet = new ArrayList<CBORObject>(mapA.keySet());
        ArrayList<CBORObject> sortedBSet = new ArrayList<CBORObject>(mapB.keySet());
        Collections.sort(sortedASet);
        Collections.sort(sortedBSet);
        listACount = sortedASet.size();
        listBCount = sortedBSet.size();
        for (int i = 0; i < listACount; ++i) {
            CBORObject itemA = sortedASet.get(i);
            CBORObject itemB = sortedBSet.get(i);
            if (itemA == null) {
                return -1;
            }
            int cmp = itemA.compareTo(itemB);
            if (cmp != 0) {
                return cmp;
            }
            cmp = mapA.get(itemA).compareTo(mapB.get(itemB));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private static List<Object> PushObject(List<Object> stack, Object parent, Object child) {
        if (stack == null) {
            stack = new ArrayList<Object>();
            stack.add(parent);
        }
        for (Object o : stack) {
            if (o != child) continue;
            throw new IllegalArgumentException("Circular reference in data structure");
        }
        stack.add(child);
        return stack;
    }

    private static int TagsCompare(EInteger[] tagsA, EInteger[] tagsB) {
        if (tagsA == null) {
            return tagsB == null ? 0 : -1;
        }
        if (tagsB == null) {
            return 1;
        }
        int listACount = tagsA.length;
        int listBCount = tagsB.length;
        int c = Math.min(listACount, listBCount);
        for (int i = 0; i < c; ++i) {
            int cmp = tagsA[i].compareTo(tagsB[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return listACount != listBCount ? (listACount < listBCount ? -1 : 1) : 0;
    }

    private static List<Object> WriteChildObject(Object parentThisItem, CBORObject child, OutputStream outputStream, List<Object> stack, CBOREncodeOptions options) throws IOException {
        if (child == null) {
            outputStream.write(246);
        } else {
            int type = child.getItemType();
            if (type == 4) {
                stack = CBORObject.PushObject(stack, parentThisItem, child.getThisItem());
                child.WriteTags(outputStream);
                CBORObject.WriteObjectArray(child.AsList(), outputStream, stack, options);
                stack.remove(stack.size() - 1);
            } else if (type == 5) {
                stack = CBORObject.PushObject(stack, parentThisItem, child.getThisItem());
                child.WriteTags(outputStream);
                CBORObject.WriteObjectMap(child.AsMap(), outputStream, stack, options);
                stack.remove(stack.size() - 1);
            } else {
                child.WriteTo(outputStream, options);
            }
        }
        return stack;
    }

    private static void WriteObjectArray(List<CBORObject> list, OutputStream outputStream, CBOREncodeOptions options) throws IOException {
        CBORObject.WriteObjectArray(list, outputStream, null, options);
    }

    private static void WriteObjectArray(List<CBORObject> list, OutputStream outputStream, List<Object> stack, CBOREncodeOptions options) throws IOException {
        List<CBORObject> thisObj = list;
        CBORObject.WritePositiveInt(4, list.size(), outputStream);
        for (CBORObject i : list) {
            stack = CBORObject.WriteChildObject(thisObj, i, outputStream, stack, options);
        }
    }

    private static void WriteObjectMap(Map<CBORObject, CBORObject> map, OutputStream outputStream, CBOREncodeOptions options) throws IOException {
        CBORObject.WriteObjectMap(map, outputStream, null, options);
    }

    private static void WriteObjectMap(Map<CBORObject, CBORObject> map, OutputStream outputStream, List<Object> stack, CBOREncodeOptions options) throws IOException {
        Map<CBORObject, CBORObject> thisObj = map;
        CBORObject.WritePositiveInt(5, map.size(), outputStream);
        for (Map.Entry<CBORObject, CBORObject> entry : map.entrySet()) {
            CBORObject key = entry.getKey();
            CBORObject value = entry.getValue();
            stack = CBORObject.WriteChildObject(thisObj, key, outputStream, stack, options);
            stack = CBORObject.WriteChildObject(thisObj, value, outputStream, stack, options);
        }
    }

    private static int WritePositiveInt(int type, int value, OutputStream s) throws IOException {
        byte[] bytes = CBORObject.GetPositiveIntBytes(type, value);
        s.write(bytes, 0, bytes.length);
        return bytes.length;
    }

    private static int WritePositiveInt64(int type, long value, OutputStream s) throws IOException {
        byte[] bytes = CBORObject.GetPositiveInt64Bytes(type, value);
        s.write(bytes, 0, bytes.length);
        return bytes.length;
    }

    private static void WriteStreamedString(String str, OutputStream stream) throws IOException {
        byte[] bytes = CBORObject.GetOptimizedBytesIfShortAscii(str, -1);
        if (bytes != null) {
            stream.write(bytes, 0, bytes.length);
            return;
        }
        bytes = new byte[4096];
        int byteIndex = 0;
        boolean streaming = false;
        for (int index = 0; index < str.length(); ++index) {
            int c = str.charAt(index);
            if (c <= 127) {
                if (byteIndex >= 4096) {
                    if (!streaming) {
                        stream.write(127);
                    }
                    CBORObject.WritePositiveInt(3, byteIndex, stream);
                    stream.write(bytes, 0, byteIndex);
                    byteIndex = 0;
                    streaming = true;
                }
                bytes[byteIndex++] = (byte)c;
                continue;
            }
            if (c <= 2047) {
                if (byteIndex + 2 > 4096) {
                    if (!streaming) {
                        stream.write(127);
                    }
                    CBORObject.WritePositiveInt(3, byteIndex, stream);
                    stream.write(bytes, 0, byteIndex);
                    byteIndex = 0;
                    streaming = true;
                }
                bytes[byteIndex++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytes[byteIndex++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if ((c & 0xFC00) == 55296 && index + 1 < str.length() && (str.charAt(index + 1) & 0xFC00) == 56320) {
                c = 65536 + ((c & 0x3FF) << 10) + (str.charAt(index + 1) & 0x3FF);
                ++index;
            } else if ((c & 0xF800) == 55296) {
                c = 65533;
            }
            if (c <= 65535) {
                if (byteIndex + 3 > 4096) {
                    if (!streaming) {
                        stream.write(127);
                    }
                    CBORObject.WritePositiveInt(3, byteIndex, stream);
                    stream.write(bytes, 0, byteIndex);
                    byteIndex = 0;
                    streaming = true;
                }
                bytes[byteIndex++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytes[byteIndex++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytes[byteIndex++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (byteIndex + 4 > 4096) {
                if (!streaming) {
                    stream.write(127);
                }
                CBORObject.WritePositiveInt(3, byteIndex, stream);
                stream.write(bytes, 0, byteIndex);
                byteIndex = 0;
                streaming = true;
            }
            bytes[byteIndex++] = (byte)(0xF0 | c >> 18 & 7);
            bytes[byteIndex++] = (byte)(0x80 | c >> 12 & 0x3F);
            bytes[byteIndex++] = (byte)(0x80 | c >> 6 & 0x3F);
            bytes[byteIndex++] = (byte)(0x80 | c & 0x3F);
        }
        CBORObject.WritePositiveInt(3, byteIndex, stream);
        stream.write(bytes, 0, byteIndex);
        if (streaming) {
            stream.write(-1);
        }
    }

    private void AppendClosingTags(StringBuilder sb) {
        CBORObject curobject = this;
        while (curobject.isTagged()) {
            sb.append(')');
            curobject = (CBORObject)curobject.itemValue;
        }
    }

    private void AppendOpeningTags(StringBuilder sb) {
        CBORObject curobject = this;
        while (curobject.isTagged()) {
            int low = curobject.tagLow;
            int high = curobject.tagHigh;
            if (high == 0 && low >> 16 == 0) {
                sb.append(CBORUtilities.LongToString(low));
            } else {
                EInteger bi = CBORObject.LowHighToEInteger(low, high);
                sb.append(bi.toString());
            }
            sb.append('(');
            curobject = (CBORObject)curobject.itemValue;
        }
    }

    private int AsInt32(int minValue, int maxValue) {
        CBORNumber cn = CBORNumber.FromCBORObject(this);
        if (cn == null) {
            throw new IllegalStateException("not a number type");
        }
        return cn.GetNumberInterface().AsInt32(cn.GetValue(), minValue, maxValue);
    }

    private void WriteTags(OutputStream s) throws IOException {
        CBORObject curobject = this;
        while (curobject.isTagged()) {
            int low = curobject.tagLow;
            int high = curobject.tagHigh;
            if (high == 0 && low >> 16 == 0) {
                CBORObject.WritePositiveInt(6, low, s);
            } else if (high == 0) {
                long value = (long)low & 0xFFFFFFFFL;
                CBORObject.WritePositiveInt64(6, value, s);
            } else if (high >> 16 == 0) {
                long value = (long)low & 0xFFFFFFFFL;
                long highValue = (long)high & 0xFFFFFFFFL;
                CBORObject.WritePositiveInt64(6, value |= highValue << 32, s);
            } else {
                byte[] arrayToWrite = new byte[]{-37, (byte)(high >> 24 & 0xFF), (byte)(high >> 16 & 0xFF), (byte)(high >> 8 & 0xFF), (byte)(high & 0xFF), (byte)(low >> 24 & 0xFF), (byte)(low >> 16 & 0xFF), (byte)(low >> 8 & 0xFF), (byte)(low & 0xFF)};
                s.write(arrayToWrite, 0, 9);
            }
            curobject = (CBORObject)curobject.itemValue;
        }
    }
}

