/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.security.Principal;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.DTLSConnectionState;
import org.eclipse.californium.scandium.dtls.HandshakeParameter;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.RecordSizeLimitExtension;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SessionTicket;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerName;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DTLSSession
implements Destroyable {
    public static final int DTLS_HEADER_LENGTH = 25;
    @Deprecated
    public static final int HEADER_LENGTH = 89;
    private static final Logger LOGGER = LoggerFactory.getLogger(DTLSSession.class);
    private static final long RECEIVE_WINDOW_SIZE = 64L;
    private static final long MAX_SEQUENCE_NO = 0xFFFFFFFFFFFFL;
    private static final int MAX_FRAGMENT_LENGTH_DEFAULT = 16384;
    private static final int MASTER_SECRET_LENGTH = 48;
    private InetSocketAddress peer;
    private SessionId sessionIdentifier;
    private Principal peerIdentity;
    private Integer recordSizeLimit;
    private int maxFragmentLength = 16384;
    private CipherSuite cipherSuite = CipherSuite.TLS_NULL_WITH_NULL_NULL;
    private SignatureAndHashAlgorithm signatureAndHashAlgorithm;
    private CompressionMethod compressionMethod = CompressionMethod.NULL;
    private SecretKey masterSecret = null;
    private ConnectionId writeConnectionId = null;
    private DTLSConnectionState readState = DTLSConnectionState.NULL;
    private DTLSConnectionState writeState = DTLSConnectionState.NULL;
    private int readEpoch = 0;
    private int writeEpoch = 0;
    private long[] sequenceNumbers = new long[2];
    private int readEpochClosed;
    private long readSequenceNumberClosed;
    private boolean markedAsclosed;
    private CertificateType sendCertificateType = CertificateType.X_509;
    private CertificateType receiveCertificateType = CertificateType.X_509;
    private boolean parameterAvailable = false;
    private volatile long receiveWindowUpperCurrent = -1L;
    private volatile long receiveWindowLowerBoundary = 0L;
    private volatile long receivedRecordsVector = 0L;
    private long creationTime;
    private String hostName;
    private ServerNames serverNames;
    private boolean peerSupportsSni;
    private final String handshakeTimeTag;

    public DTLSSession(InetSocketAddress peerAddress) {
        this(peerAddress, 0L, System.currentTimeMillis());
    }

    public DTLSSession(SessionId id, InetSocketAddress peerAddress, SessionTicket ticket, long initialSequenceNo) {
        this(peerAddress, initialSequenceNo, ticket.getTimestamp());
        this.sessionIdentifier = id;
        this.masterSecret = SecretUtil.create(ticket.getMasterSecret());
        this.peerIdentity = ticket.getClientIdentity();
        this.cipherSuite = ticket.getCipherSuite();
        this.serverNames = ticket.getServerNames();
        this.compressionMethod = ticket.getCompressionMethod();
    }

    public DTLSSession(InetSocketAddress peerAddress, long initialSequenceNo) {
        this(peerAddress, initialSequenceNo, System.currentTimeMillis());
    }

    public DTLSSession(InetSocketAddress peerAddress, long initialSequenceNo, long creationTime) {
        if (peerAddress == null) {
            throw new NullPointerException("Peer address must not be null");
        }
        if (initialSequenceNo < 0L || initialSequenceNo > 0xFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("Initial sequence number must be greater than 0 and less than 2^48");
        }
        this.creationTime = creationTime;
        this.handshakeTimeTag = Long.toString(System.currentTimeMillis());
        this.peer = peerAddress;
        this.sequenceNumbers[0] = initialSequenceNo;
    }

    @Override
    public void destroy() throws DestroyFailedException {
        SecretUtil.destroy(this.masterSecret);
        this.masterSecret = null;
        if (this.readState != DTLSConnectionState.NULL) {
            this.readState.destroy();
            this.readState = DTLSConnectionState.NULL;
        }
        if (this.writeState != DTLSConnectionState.NULL) {
            this.writeState.destroy();
            this.writeState = DTLSConnectionState.NULL;
        }
    }

    @Override
    public boolean isDestroyed() {
        return SecretUtil.isDestroyed(this.masterSecret) && SecretUtil.isDestroyed(this.readState) && SecretUtil.isDestroyed(this.writeState);
    }

    public SessionId getSessionIdentifier() {
        return this.sessionIdentifier;
    }

    void setSessionIdentifier(SessionId sessionIdentifier) {
        if (sessionIdentifier == null) {
            throw new NullPointerException("session identifier must not be null!");
        }
        if (!sessionIdentifier.equals(this.sessionIdentifier)) {
            SecretUtil.destroy(this.masterSecret);
            this.masterSecret = null;
            this.sessionIdentifier = sessionIdentifier;
        }
    }

    public ConnectionId getWriteConnectionId() {
        return this.writeConnectionId;
    }

    void setWriteConnectionId(ConnectionId connectionId) {
        this.writeConnectionId = connectionId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getLastHandshakeTime() {
        return this.handshakeTimeTag;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostname) {
        this.serverNames = null;
        this.hostName = hostname;
        if (hostname != null) {
            this.serverNames = ServerNames.newInstance(ServerName.from(ServerName.NameType.HOST_NAME, hostname.getBytes(ServerName.CHARSET)));
        }
    }

    public ServerNames getServerNames() {
        return this.serverNames;
    }

    public void setServerNames(ServerNames serverNames) {
        ServerName serverName;
        this.hostName = null;
        this.serverNames = serverNames;
        if (serverNames != null && (serverName = serverNames.getServerName(ServerName.NameType.HOST_NAME)) != null) {
            this.hostName = serverName.getNameAsString();
        }
    }

    public boolean isSniSupported() {
        return this.peerSupportsSni;
    }

    void setSniSupported(boolean flag) {
        this.peerSupportsSni = flag;
    }

    public DtlsEndpointContext getConnectionWriteContext() {
        String id = this.sessionIdentifier.isEmpty() ? "TIME:" + Long.toString(this.creationTime) : this.sessionIdentifier.toString();
        return new DtlsEndpointContext(this.peer, this.hostName, this.peerIdentity, id, Integer.toString(this.writeEpoch), this.cipherSuite.name(), this.handshakeTimeTag);
    }

    public DtlsEndpointContext getConnectionReadContext() {
        String id = this.sessionIdentifier.isEmpty() ? "TIME:" + Long.toString(this.creationTime) : this.sessionIdentifier.toString();
        return new DtlsEndpointContext(this.peer, this.hostName, this.peerIdentity, id, Integer.toString(this.readEpoch), this.cipherSuite.name(), this.handshakeTimeTag);
    }

    public CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    void setCipherSuite(CipherSuite cipherSuite) {
        if (cipherSuite == null || CipherSuite.TLS_NULL_WITH_NULL_NULL == cipherSuite) {
            throw new IllegalArgumentException("Negotiated cipher suite must not be null");
        }
        this.cipherSuite = cipherSuite;
    }

    CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    void setCompressionMethod(CompressionMethod compressionMethod) {
        this.compressionMethod = compressionMethod;
    }

    public int getWriteEpoch() {
        return this.writeEpoch;
    }

    void setWriteEpoch(int epoch) {
        if (epoch < 0) {
            throw new IllegalArgumentException("Write epoch must not be negative");
        }
        this.writeEpoch = epoch;
    }

    public int getReadEpoch() {
        return this.readEpoch;
    }

    void setReadEpoch(int epoch) {
        if (epoch < 0) {
            throw new IllegalArgumentException("Read epoch must not be negative");
        }
        this.resetReceiveWindow();
        this.readEpoch = epoch;
    }

    private void incrementReadEpoch() {
        this.resetReceiveWindow();
        ++this.readEpoch;
    }

    private void incrementWriteEpoch() {
        ++this.writeEpoch;
        this.sequenceNumbers[this.writeEpoch] = 0L;
    }

    public long getSequenceNumber() {
        return this.getSequenceNumber(this.writeEpoch);
    }

    public long getSequenceNumber(int epoch) {
        long sequenceNumber = this.sequenceNumbers[epoch];
        if (sequenceNumber < 0xFFFFFFFFFFFFL) {
            this.sequenceNumbers[epoch] = sequenceNumber + 1L;
            return sequenceNumber;
        }
        throw new IllegalStateException("Maximum sequence number for epoch has been reached");
    }

    DTLSConnectionState getReadState() {
        return this.readState;
    }

    void setReadState(DTLSConnectionState readState) {
        if (readState == null) {
            throw new NullPointerException("Read state must not be null");
        }
        SecretUtil.destroy(this.readState);
        this.readState = readState;
        this.incrementReadEpoch();
        LOGGER.trace("Setting current read state to{}{}", (Object)StringUtil.lineSeparator(), (Object)readState);
    }

    public String getReadStateCipher() {
        return this.readState.getCipherSuite().name();
    }

    DTLSConnectionState getWriteState() {
        return this.getWriteState(this.writeEpoch);
    }

    DTLSConnectionState getWriteState(int epoch) {
        if (epoch == 0) {
            return DTLSConnectionState.NULL;
        }
        return this.writeState;
    }

    void setWriteState(DTLSConnectionState writeState) {
        if (writeState == null) {
            throw new NullPointerException("Write state must not be null");
        }
        SecretUtil.destroy(this.writeState);
        this.writeState = writeState;
        this.incrementWriteEpoch();
        LOGGER.trace("Setting current write state to{}{}", (Object)StringUtil.lineSeparator(), (Object)writeState);
    }

    public String getWriteStateCipher() {
        return this.writeState.getCipherSuite().name();
    }

    public void setParameterAvailable() {
        this.parameterAvailable = true;
    }

    public HandshakeParameter getParameter() {
        if (this.parameterAvailable) {
            return new HandshakeParameter(this.cipherSuite.getKeyExchange(), this.receiveCertificateType);
        }
        return null;
    }

    final CipherSuite.KeyExchangeAlgorithm getKeyExchange() {
        if (this.cipherSuite == null) {
            throw new IllegalStateException("Cipher suite has not been set (yet)");
        }
        return this.cipherSuite.getKeyExchange();
    }

    SecretKey getMasterSecret() {
        return SecretUtil.create(this.masterSecret);
    }

    void setMasterSecret(SecretKey masterSecret) {
        if (this.masterSecret == null) {
            if (!this.sessionIdentifier.isEmpty()) {
                if (masterSecret == null) {
                    throw new NullPointerException("Master secret must not be null");
                }
                byte[] secret = masterSecret.getEncoded();
                Bytes.clear(secret);
                if (secret.length != 48) {
                    throw new IllegalArgumentException(String.format("Master secret must consist of of exactly %d bytes but has %d bytes", 48, secret.length));
                }
                this.masterSecret = SecretUtil.create(masterSecret);
            }
        } else {
            throw new IllegalStateException("master secret already available!");
        }
        this.creationTime = System.currentTimeMillis();
    }

    public int getMaxCiphertextExpansion() {
        if (this.cipherSuite == null) {
            throw new IllegalStateException("Missing cipher suite.");
        }
        return this.cipherSuite.getMaxCiphertextExpansion();
    }

    void setMaxFragmentLength(int length) {
        if (length < 0 || length > 16384) {
            throw new IllegalArgumentException("Max. fragment length must be in range [0...16384]");
        }
        this.maxFragmentLength = length;
    }

    public int getMaxFragmentLength() {
        return this.maxFragmentLength;
    }

    void setRecordSizeLimit(int limit) {
        this.recordSizeLimit = RecordSizeLimitExtension.ensureInRange(limit);
    }

    public Integer getRecordSizeLimit() {
        return this.recordSizeLimit;
    }

    public int getEffectiveFragmentLimit() {
        if (this.recordSizeLimit != null) {
            return this.recordSizeLimit;
        }
        return this.maxFragmentLength;
    }

    CertificateType sendCertificateType() {
        return this.sendCertificateType;
    }

    void setSendCertificateType(CertificateType sendCertificateType) {
        this.sendCertificateType = sendCertificateType;
    }

    CertificateType receiveCertificateType() {
        return this.receiveCertificateType;
    }

    void setReceiveCertificateType(CertificateType receiveCertificateType) {
        this.receiveCertificateType = receiveCertificateType;
    }

    public SignatureAndHashAlgorithm getSignatureAndHashAlgorithm() {
        return this.signatureAndHashAlgorithm;
    }

    void setSignatureAndHashAlgorithm(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
    }

    public InetSocketAddress getPeer() {
        return this.peer;
    }

    public void setPeer(InetSocketAddress peer) {
        this.peer = peer;
    }

    public Principal getPeerIdentity() {
        return this.peerIdentity;
    }

    void setPeerIdentity(Principal peerIdentity) {
        if (peerIdentity == null) {
            throw new NullPointerException("Peer identity must not be null");
        }
        this.peerIdentity = peerIdentity;
    }

    @Deprecated
    public boolean isRecordProcessable(long epoch, long sequenceNo, boolean useWindowOnly) {
        return this.isRecordProcessable(epoch, sequenceNo, useWindowOnly ? -1 : 0);
    }

    public boolean isRecordProcessable(long epoch, long sequenceNo, int useExtendedWindow) {
        if (epoch < (long)this.getReadEpoch()) {
            return false;
        }
        if (epoch > (long)this.getReadEpoch()) {
            return false;
        }
        if (sequenceNo < this.receiveWindowLowerBoundary) {
            if (useExtendedWindow < 0) {
                return true;
            }
            return sequenceNo > this.receiveWindowLowerBoundary - (long)useExtendedWindow;
        }
        if (this.markedAsclosed) {
            if (epoch > (long)this.readEpochClosed) {
                return false;
            }
            if (epoch == (long)this.readEpochClosed && sequenceNo >= this.readSequenceNumberClosed) {
                return false;
            }
        }
        return !this.isDuplicate(sequenceNo);
    }

    boolean isDuplicate(long sequenceNo) {
        if (sequenceNo > this.receiveWindowUpperCurrent) {
            return false;
        }
        long idx = sequenceNo - this.receiveWindowLowerBoundary;
        long bitMask = 1L << (int)idx;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Checking sequence no [{}] using bit mask [{}] against received records [{}] with lower boundary [{}]", sequenceNo, Long.toBinaryString(bitMask), Long.toBinaryString(this.receivedRecordsVector), this.receiveWindowLowerBoundary);
        }
        return (this.receivedRecordsVector & bitMask) == bitMask;
    }

    public boolean markRecordAsRead(long epoch, long sequenceNo) {
        if (epoch == (long)this.getReadEpoch()) {
            boolean newest;
            boolean bl = newest = sequenceNo > this.receiveWindowUpperCurrent;
            if (newest) {
                this.receiveWindowUpperCurrent = sequenceNo;
                long lowerBoundary = Math.max(0L, sequenceNo - 64L + 1L);
                long incr = lowerBoundary - this.receiveWindowLowerBoundary;
                if (incr > 0L) {
                    this.receivedRecordsVector >>>= (int)incr;
                    this.receiveWindowLowerBoundary = lowerBoundary;
                }
            }
            long bitMask = 1L << (int)(sequenceNo - this.receiveWindowLowerBoundary);
            this.receivedRecordsVector |= bitMask;
            LOGGER.debug("Updated receive window with sequence number [{}]: new upper boundary [{}], new bit vector [{}]", sequenceNo, this.receiveWindowUpperCurrent, Long.toBinaryString(this.receivedRecordsVector));
            return newest;
        }
        return epoch > (long)this.getReadEpoch();
    }

    public boolean isMarkedAsClosed() {
        return this.markedAsclosed;
    }

    public void markCloseNotiy(int epoch, long sequenceNo) {
        this.markedAsclosed = true;
        this.readEpochClosed = epoch;
        this.readSequenceNumberClosed = sequenceNo;
    }

    private void resetReceiveWindow() {
        this.receivedRecordsVector = 0L;
        this.receiveWindowUpperCurrent = -1L;
        this.receiveWindowLowerBoundary = 0L;
    }

    public SessionTicket getSessionTicket() {
        DTLSConnectionState writeState = this.getWriteState();
        if (!writeState.hasValidCipherSuite()) {
            throw new IllegalStateException("session has no valid crypto params, not fully negotiated yet?");
        }
        if (this.sessionIdentifier.isEmpty()) {
            return null;
        }
        return new SessionTicket(ProtocolVersion.VERSION_DTLS_1_2, writeState.getCipherSuite(), writeState.getCompressionMethod(), this.masterSecret, this.getServerNames(), this.getPeerIdentity(), this.creationTime);
    }
}

