/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests;

import java.io.File;
import java.net.SocketException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.EndpointObserver;
import org.eclipse.californium.core.network.MessagePostProcessInterceptors;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.config.NetworkConfigDefaultHandler;
import org.eclipse.californium.core.network.interceptors.AnonymizedOriginTracer;
import org.eclipse.californium.core.network.interceptors.HealthStatisticLogger;
import org.eclipse.californium.core.network.interceptors.MessageTracer;
import org.eclipse.californium.elements.tcp.netty.TlsServerConnector;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.plugtests.AbstractTestServer;
import org.eclipse.californium.plugtests.resources.Create;
import org.eclipse.californium.plugtests.resources.DefaultTest;
import org.eclipse.californium.plugtests.resources.Large;
import org.eclipse.californium.plugtests.resources.LargeCreate;
import org.eclipse.californium.plugtests.resources.LargePost;
import org.eclipse.californium.plugtests.resources.LargeSeparate;
import org.eclipse.californium.plugtests.resources.LargeUpdate;
import org.eclipse.californium.plugtests.resources.Link1;
import org.eclipse.californium.plugtests.resources.Link2;
import org.eclipse.californium.plugtests.resources.Link3;
import org.eclipse.californium.plugtests.resources.LocationQuery;
import org.eclipse.californium.plugtests.resources.LongPath;
import org.eclipse.californium.plugtests.resources.MultiFormat;
import org.eclipse.californium.plugtests.resources.Observe;
import org.eclipse.californium.plugtests.resources.ObserveLarge;
import org.eclipse.californium.plugtests.resources.ObserveNon;
import org.eclipse.californium.plugtests.resources.ObservePumping;
import org.eclipse.californium.plugtests.resources.ObserveReset;
import org.eclipse.californium.plugtests.resources.Path;
import org.eclipse.californium.plugtests.resources.Query;
import org.eclipse.californium.plugtests.resources.Separate;
import org.eclipse.californium.plugtests.resources.Shutdown;
import org.eclipse.californium.plugtests.resources.Validate;
import picocli.CommandLine;

public class PlugtestServer
extends AbstractTestServer {
    private static final File CONFIG_FILE = new File("CaliforniumPlugtest.properties");
    private static final String CONFIG_HEADER = "Californium CoAP Properties file for Plugtest Server";
    private static final int DEFAULT_MAX_RESOURCE_SIZE = 8192;
    private static final int DEFAULT_BLOCK_SIZE = 64;
    public static final int ERR_INIT_FAILED = 1;
    private static NetworkConfigDefaultHandler DEFAULTS = new NetworkConfigDefaultHandler(){

        @Override
        public void applyDefaults(NetworkConfig config) {
            config.setInt("DTLS_AUTO_RESUME_TIMEOUT", 0);
            config.setInt("DTLS_CONNECTION_ID_LENGTH", 6);
            config.setInt("MAX_RESOURCE_BODY_SIZE", 8192);
            config.setInt("MAX_MESSAGE_SIZE", 64);
            config.setInt("PREFERRED_BLOCK_SIZE", 64);
            config.setInt("NOTIFICATION_CHECK_INTERVAL_COUNT", 4);
            config.setInt("NOTIFICATION_CHECK_INTERVAL", 30000);
            config.setInt("HEALTH_STATUS_INTERVAL", 300);
            config.setInt("UDP_CONNECTOR_RECEIVE_BUFFER", 0);
            config.setInt("UDP_CONNECTOR_SEND_BUFFER", 0);
        }
    };
    private static final Config config = new Config();

    public static void main(String[] args) {
        CommandLine cmd = new CommandLine(config);
        try {
            CommandLine.ParseResult result = cmd.parseArgs(args);
            if (result.isVersionHelpRequested()) {
                String version = StringUtil.CALIFORNIUM_VERSION == null ? "" : StringUtil.CALIFORNIUM_VERSION;
                System.out.println("\nCalifornium (Cf) " + cmd.getCommandName() + " " + version);
                cmd.printVersionHelp(System.out);
                System.out.println();
            }
            if (result.isUsageHelpRequested()) {
                cmd.usage(System.out);
                return;
            }
        }
        catch (CommandLine.ParameterException ex) {
            System.err.println(ex.getMessage());
            System.err.println();
            cmd.usage(System.err);
            System.exit(-1);
        }
        PlugtestServer.start(config);
    }

    public static void start(BaseConfig config) {
        NetworkConfig netconfig = NetworkConfig.createWithFile(CONFIG_FILE, CONFIG_HEADER, DEFAULTS);
        try {
            int s;
            List<AbstractTestServer.Protocol> protocols = config.onlyDtls ? Arrays.asList(AbstractTestServer.Protocol.DTLS) : (config.tcp ? Arrays.asList(AbstractTestServer.Protocol.UDP, AbstractTestServer.Protocol.DTLS, AbstractTestServer.Protocol.TCP, AbstractTestServer.Protocol.TLS) : Arrays.asList(AbstractTestServer.Protocol.UDP, AbstractTestServer.Protocol.DTLS));
            ArrayList<AbstractTestServer.InterfaceType> types = new ArrayList<AbstractTestServer.InterfaceType>();
            if (config.external) {
                types.add(AbstractTestServer.InterfaceType.EXTERNAL);
            }
            if (config.loopback) {
                types.add(AbstractTestServer.InterfaceType.LOCAL);
            }
            if ((s = types.size()) == 0) {
                System.err.println("Either --loopback or --external must be enabled!");
                System.exit(1);
            }
            if (config.ipv6) {
                types.add(AbstractTestServer.InterfaceType.IPV6);
            }
            if (config.ipv4) {
                types.add(AbstractTestServer.InterfaceType.IPV4);
            }
            if (s == types.size()) {
                System.err.println("Either --ipv4 or --ipv6 must be enabled!");
            }
            String pattern = config.interfacePatterns != null && !config.interfacePatterns.isEmpty() ? config.interfacePatterns.get(0) : null;
            PlugtestServer server = new PlugtestServer(netconfig);
            server.addEndpoints(pattern, types, protocols, config);
            server.start();
            ScheduledThreadPoolExecutor executor = ExecutorsUtil.newDefaultSecondaryScheduler("Health#");
            for (Endpoint ep : server.getEndpoints()) {
                URI uri = ep.getUri();
                ep.addInterceptor(new MessageTracer());
                ep.addInterceptor(new AnonymizedOriginTracer(uri.getPort() + "-" + uri.getScheme()));
                if (!(ep instanceof MessagePostProcessInterceptors)) continue;
                int interval = ep.getConfig().getInt("HEALTH_STATUS_INTERVAL");
                final HealthStatisticLogger healthLogger = new HealthStatisticLogger(uri.getScheme(), !CoAP.isTcpScheme(uri.getScheme()), interval, executor);
                if (!healthLogger.isEnabled()) continue;
                ((MessagePostProcessInterceptors)((Object)ep)).addPostProcessInterceptor(healthLogger);
                ep.addObserver(new EndpointObserver(){

                    @Override
                    public void stopped(Endpoint endpoint) {
                        healthLogger.stop();
                    }

                    @Override
                    public void started(Endpoint endpoint) {
                        healthLogger.start();
                    }

                    @Override
                    public void destroyed(Endpoint endpoint) {
                        healthLogger.stop();
                    }
                });
                healthLogger.start();
            }
            System.out.println(PlugtestServer.class.getSimpleName() + " started ...");
        }
        catch (Exception e) {
            System.err.printf("Failed to create " + PlugtestServer.class.getSimpleName() + ": %s\n", e.getMessage());
            e.printStackTrace(System.err);
            System.err.println("Exiting");
            System.exit(1);
        }
    }

    public PlugtestServer(NetworkConfig config) throws SocketException {
        super(config, null);
        this.add(new DefaultTest());
        this.add(new LongPath());
        this.add(new Query());
        this.add(new Separate());
        this.add(new Large());
        this.add(new LargeUpdate());
        this.add(new LargeCreate());
        this.add(new LargePost());
        this.add(new LargeSeparate());
        this.add(new Observe());
        this.add(new ObserveNon());
        this.add(new ObserveReset());
        this.add(new ObserveLarge());
        this.add(new ObservePumping());
        this.add(new ObservePumping(CoAP.Type.NON));
        this.add(new LocationQuery());
        this.add(new MultiFormat());
        this.add(new Link1());
        this.add(new Link2());
        this.add(new Link3());
        this.add(new Path());
        this.add(new Validate());
        this.add(new Create());
        this.add(new Shutdown());
    }

    @CommandLine.Command(name="PlugtestServer", version={"(c) 2014, Institute for Pervasive Computing, ETH Zurich."})
    public static class Config
    extends BaseConfig {
    }

    public static class BaseConfig {
        @CommandLine.Option(names={"--no-loopback"}, negatable=true, description={"enable endpoints on loopback network."})
        public boolean loopback = true;
        @CommandLine.Option(names={"--no-external"}, negatable=true, description={"enable endpoints on external network."})
        public boolean external = true;
        @CommandLine.Option(names={"--no-ipv4"}, negatable=true, description={"enable endpoints for ipv4."})
        public boolean ipv4 = true;
        @CommandLine.Option(names={"--no-ipv6"}, negatable=true, description={"enable endpoints for ipv6."})
        public boolean ipv6 = true;
        @CommandLine.Option(names={"--no-tcp"}, negatable=true, description={"enable endpoints for tcp."})
        public boolean tcp = true;
        @CommandLine.Option(names={"--dtls-only"}, description={"only dtls endpoints."})
        public boolean onlyDtls;
        @CommandLine.Option(names={"--trust-all"}, description={"trust all valid certificates."})
        public boolean trustall;
        @CommandLine.Option(names={"--client-auth"}, description={"client authentication."})
        public TlsServerConnector.ClientAuthMode clientAuth = TlsServerConnector.ClientAuthMode.NEEDED;
        @CommandLine.Option(names={"--interfaces"}, split=",", description={"interfaces for endpoints."})
        public List<String> interfaceNames;
        @CommandLine.Option(names={"--interfaces-pattern"}, split=",", description={"interface patterns for endpoints."})
        public List<String> interfacePatterns;
    }
}

