/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.ClientKeyExchange;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;

public final class PSKClientKeyExchange
extends ClientKeyExchange {
    private static final int IDENTITY_LENGTH_BITS = 16;
    private final PskPublicInformation identity;

    public PSKClientKeyExchange(PskPublicInformation identity, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.identity = identity;
    }

    private PSKClientKeyExchange(byte[] identityEncoded, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.identity = PskPublicInformation.fromByteArray(identityEncoded);
    }

    @Override
    public int getMessageLength() {
        return 2 + this.identity.length();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\t\tPSK Identity: ").append(this.identity).append(StringUtil.lineSeparator());
        return sb.toString();
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.identity.length(), 16);
        writer.writeBytes(this.identity.getBytes());
        return writer.toByteArray();
    }

    public static HandshakeMessage fromReader(DatagramReader reader, InetSocketAddress peerAddress) {
        int length = reader.read(16);
        byte[] identityEncoded = reader.readBytes(length);
        return new PSKClientKeyExchange(identityEncoded, peerAddress);
    }

    public PskPublicInformation getIdentity() {
        return this.identity;
    }
}

