/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.List;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalCryptoMap;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalKeyFactory;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CertificateVerify
extends HandshakeMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateVerify.class);
    private static final int HASH_ALGORITHM_BITS = 8;
    private static final int SIGNATURE_ALGORITHM_BITS = 8;
    private static final int SIGNATURE_LENGTH_BITS = 16;
    private static final ThreadLocalCryptoMap<ThreadLocalKeyFactory> KEY_FACTORIES = new ThreadLocalCryptoMap<ThreadLocalKeyFactory>(new ThreadLocalCryptoMap.Factory<ThreadLocalKeyFactory>(){

        @Override
        public ThreadLocalKeyFactory getInstance(String algorithm) {
            return new ThreadLocalKeyFactory(algorithm);
        }
    });
    private byte[] signatureBytes;
    private final SignatureAndHashAlgorithm signatureAndHashAlgorithm;

    public CertificateVerify(SignatureAndHashAlgorithm signatureAndHashAlgorithm, PrivateKey clientPrivateKey, List<HandshakeMessage> handshakeMessages, InetSocketAddress peerAddress) {
        this(signatureAndHashAlgorithm, peerAddress);
        this.signatureBytes = this.setSignature(clientPrivateKey, handshakeMessages);
    }

    private CertificateVerify(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] signatureBytes, InetSocketAddress peerAddress) {
        this(signatureAndHashAlgorithm, peerAddress);
        this.signatureBytes = Arrays.copyOf(signatureBytes, signatureBytes.length);
    }

    private CertificateVerify(SignatureAndHashAlgorithm signatureAndHashAlgorithm, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
    }

    @Override
    public HandshakeType getMessageType() {
        return HandshakeType.CERTIFICATE_VERIFY;
    }

    @Override
    public int getMessageLength() {
        return 4 + this.signatureBytes.length;
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.signatureAndHashAlgorithm.getHash().getCode(), 8);
        writer.write(this.signatureAndHashAlgorithm.getSignature().getCode(), 8);
        writer.write(this.signatureBytes.length, 16);
        writer.writeBytes(this.signatureBytes);
        return writer.toByteArray();
    }

    public static HandshakeMessage fromReader(DatagramReader reader, InetSocketAddress peerAddress) {
        int hashAlgorithm = reader.read(8);
        int signatureAlgorithm = reader.read(8);
        SignatureAndHashAlgorithm signAndHash = new SignatureAndHashAlgorithm(hashAlgorithm, signatureAlgorithm);
        int length = reader.read(16);
        byte[] signature = reader.readBytes(length);
        return new CertificateVerify(signAndHash, signature, peerAddress);
    }

    private byte[] setSignature(PrivateKey clientPrivateKey, List<HandshakeMessage> handshakeMessages) {
        this.signatureBytes = Bytes.EMPTY;
        try {
            Signature signature;
            boolean init;
            block7: {
                init = false;
                ThreadLocalSignature localSignature = this.signatureAndHashAlgorithm.getThreadLocalSignature();
                signature = (Signature)localSignature.currentWithCause();
                try {
                    signature.initSign(clientPrivateKey);
                    init = true;
                }
                catch (InvalidKeyException e) {
                    KeyFactory factory;
                    String algorithm = Asn1DerDecoder.getEdDsaStandardAlgorithmName(clientPrivateKey.getAlgorithm(), null);
                    if (algorithm == null || (factory = (KeyFactory)KEY_FACTORIES.get(algorithm).current()) == null) break block7;
                    PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(clientPrivateKey.getEncoded());
                    signature.initSign(factory.generatePrivate(privateKeySpec));
                    init = true;
                }
            }
            if (init) {
                int index = 0;
                for (HandshakeMessage message : handshakeMessages) {
                    signature.update(message.toByteArray());
                    LOGGER.trace("  [{}] - {}", (Object)index, (Object)message.getMessageType());
                    ++index;
                }
                this.signatureBytes = signature.sign();
            } else {
                LOGGER.error("Could not create signature for {}", (Object)clientPrivateKey.getAlgorithm());
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not create signature.", e);
        }
        return this.signatureBytes;
    }

    public void verifySignature(PublicKey clientPublicKey, List<HandshakeMessage> handshakeMessages) throws HandshakeException {
        try {
            ThreadLocalSignature localSignature = this.signatureAndHashAlgorithm.getThreadLocalSignature();
            Signature signature = (Signature)localSignature.currentWithCause();
            signature.initVerify(clientPublicKey);
            int index = 0;
            for (HandshakeMessage message : handshakeMessages) {
                signature.update(message.toByteArray());
                LOGGER.trace("  [{}] - {}", (Object)index, (Object)message.getMessageType());
                ++index;
            }
            if (signature.verify(this.signatureBytes)) {
                return;
            }
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Could not verify the client's signature.", e);
        }
        String message = "The client's CertificateVerify message could not be verified.";
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.getPeer());
        throw new HandshakeException(message, alert);
    }
}

