/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.ConnectionIdExtension;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ServerNameExtension;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SignatureAlgorithmsExtension;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.SupportedEllipticCurvesExtension;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;

@NoPublicAPI
public final class ClientHello
extends HandshakeMessage {
    private static final int VERSION_BITS = 8;
    private static final int RANDOM_BYTES = 32;
    private static final int SESSION_ID_LENGTH_BITS = 8;
    private static final int COOKIE_LENGTH = 8;
    private static final int CIPHER_SUITS_LENGTH_BITS = 16;
    private static final int COMPRESSION_METHODS_LENGTH_BITS = 8;
    private ProtocolVersion clientVersion = new ProtocolVersion();
    private Random random;
    private SessionId sessionId;
    private byte[] cookie;
    private List<CipherSuite> supportedCipherSuites = new ArrayList<CipherSuite>();
    private List<CompressionMethod> compressionMethods = new ArrayList<CompressionMethod>();
    private HelloExtensions extensions = new HelloExtensions();

    public ClientHello(ProtocolVersion version, List<CipherSuite> supportedCipherSuites, List<SignatureAndHashAlgorithm> supportedSignatureAndHashAlgorithms, List<CertificateType> supportedClientCertificateTypes, List<CertificateType> supportedServerCertificateTypes, List<XECDHECryptography.SupportedGroup> supportedGroups, InetSocketAddress peerAddress) {
        this(version, null, supportedCipherSuites, supportedSignatureAndHashAlgorithms, supportedClientCertificateTypes, supportedServerCertificateTypes, supportedGroups, peerAddress);
    }

    public ClientHello(ProtocolVersion version, DTLSSession session, List<SignatureAndHashAlgorithm> supportedSignatureAndHashAlgorithms, List<CertificateType> supportedClientCertificateTypes, List<CertificateType> supportedServerCertificateTypes, List<XECDHECryptography.SupportedGroup> supportedGroups) {
        this(version, session.getSessionIdentifier(), Arrays.asList(session.getCipherSuite()), supportedSignatureAndHashAlgorithms, supportedClientCertificateTypes, supportedServerCertificateTypes, supportedGroups, session.getPeer());
        this.addCompressionMethod(session.getWriteState().getCompressionMethod());
    }

    private ClientHello(ProtocolVersion version, SessionId sessionId, List<CipherSuite> supportedCipherSuites, List<SignatureAndHashAlgorithm> supportedSignatureAndHashAlgorithms, List<CertificateType> supportedClientCertificateTypes, List<CertificateType> supportedServerCertificateTypes, List<XECDHECryptography.SupportedGroup> supportedGroups, InetSocketAddress peerAddress) {
        this(peerAddress);
        this.clientVersion = version;
        this.random = new Random();
        this.cookie = Bytes.EMPTY;
        this.sessionId = sessionId != null ? sessionId : SessionId.emptySessionId();
        if (supportedCipherSuites != null) {
            this.supportedCipherSuites.addAll(supportedCipherSuites);
        }
        if (CipherSuite.containsEccBasedCipherSuite(supportedCipherSuites)) {
            this.extensions.addExtension(new SupportedEllipticCurvesExtension(supportedGroups));
            this.extensions.addExtension(SupportedPointFormatsExtension.DEFAULT_POINT_FORMATS_EXTENSION);
        }
        if (!supportedSignatureAndHashAlgorithms.isEmpty()) {
            this.extensions.addExtension(new SignatureAlgorithmsExtension(supportedSignatureAndHashAlgorithms));
        }
        if (this.useCertificateTypeExtension(supportedClientCertificateTypes)) {
            ClientCertificateTypeExtension clientCertificateType = new ClientCertificateTypeExtension(supportedClientCertificateTypes);
            this.extensions.addExtension(clientCertificateType);
        }
        if (this.useCertificateTypeExtension(supportedServerCertificateTypes)) {
            ServerCertificateTypeExtension serverCertificateType = new ServerCertificateTypeExtension(supportedServerCertificateTypes);
            this.extensions.addExtension(serverCertificateType);
        }
    }

    private boolean useCertificateTypeExtension(List<CertificateType> supportedCertificateTypes) {
        if (supportedCertificateTypes != null && !supportedCertificateTypes.isEmpty()) {
            return supportedCertificateTypes.size() > 1 || !supportedCertificateTypes.contains((Object)CertificateType.X_509);
        }
        return false;
    }

    private ClientHello(InetSocketAddress peerAddress) {
        super(peerAddress);
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.clientVersion.getMajor(), 8);
        writer.write(this.clientVersion.getMinor(), 8);
        writer.writeBytes(this.random.getBytes());
        writer.write(this.sessionId.length(), 8);
        writer.writeBytes(this.sessionId.getBytes());
        writer.write(this.cookie.length, 8);
        writer.writeBytes(this.cookie);
        writer.write(this.supportedCipherSuites.size() * 2, 16);
        writer.writeBytes(CipherSuite.listToByteArray(this.supportedCipherSuites));
        writer.write(this.compressionMethods.size(), 8);
        writer.writeBytes(CompressionMethod.listToByteArray(this.compressionMethods));
        if (this.extensions != null) {
            writer.writeBytes(this.extensions.toByteArray());
        }
        return writer.toByteArray();
    }

    public static HandshakeMessage fromReader(DatagramReader reader, InetSocketAddress peerAddress) throws HandshakeException {
        ClientHello result = new ClientHello(peerAddress);
        int major = reader.read(8);
        int minor = reader.read(8);
        result.clientVersion = new ProtocolVersion(major, minor);
        result.random = new Random(reader.readBytes(32));
        int sessionIdLength = reader.read(8);
        result.sessionId = new SessionId(reader.readBytes(sessionIdLength));
        int cookieLength = reader.read(8);
        result.cookie = reader.readBytes(cookieLength);
        int cipherSuitesLength = reader.read(16);
        DatagramReader rangeReader = reader.createRangeReader(cipherSuitesLength);
        result.supportedCipherSuites = CipherSuite.listFromReader(rangeReader);
        int compressionMethodsLength = reader.read(8);
        rangeReader = reader.createRangeReader(compressionMethodsLength);
        result.compressionMethods = CompressionMethod.listFromReader(rangeReader);
        if (reader.bytesAvailable()) {
            result.extensions = HelloExtensions.fromReader(reader, peerAddress);
        }
        return result;
    }

    @Override
    public HandshakeType getMessageType() {
        return HandshakeType.CLIENT_HELLO;
    }

    @Override
    public int getMessageLength() {
        int extensionsLength = this.extensions == null || this.extensions.isEmpty() ? 0 : 2 + this.extensions.getLength();
        return 39 + this.sessionId.length() + this.cookie.length + this.supportedCipherSuites.size() * 2 + this.compressionMethods.size() + extensionsLength;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\t\tVersion: ").append(this.clientVersion.getMajor()).append(", ").append(this.clientVersion.getMinor());
        sb.append(StringUtil.lineSeparator()).append("\t\tRandom:").append(StringUtil.lineSeparator()).append(this.random);
        sb.append("\t\tSession ID Length: ").append(this.sessionId.length());
        if (this.sessionId.length() > 0) {
            sb.append(StringUtil.lineSeparator()).append("\t\tSession ID: ").append(this.sessionId);
        }
        sb.append(StringUtil.lineSeparator()).append("\t\tCookie Length: ").append(this.cookie.length);
        if (this.cookie.length > 0) {
            sb.append(StringUtil.lineSeparator()).append("\t\tCookie: ").append(StringUtil.byteArray2HexString(this.cookie));
        }
        sb.append(StringUtil.lineSeparator()).append("\t\tCipher Suites Length: ").append(this.supportedCipherSuites.size() * 2);
        sb.append(StringUtil.lineSeparator()).append("\t\tCipher Suites (").append(this.supportedCipherSuites.size()).append(" suites)");
        for (CipherSuite cipher : this.supportedCipherSuites) {
            sb.append(StringUtil.lineSeparator()).append("\t\t\tCipher Suite: ").append((Object)cipher);
        }
        sb.append(StringUtil.lineSeparator()).append("\t\tCompression Methods Length: ").append(this.compressionMethods.size());
        sb.append(StringUtil.lineSeparator()).append("\t\tCompression Methods (").append(this.compressionMethods.size()).append(" method)");
        for (CompressionMethod method : this.compressionMethods) {
            sb.append(StringUtil.lineSeparator()).append("\t\t\tCompression Method: ").append((Object)method);
        }
        if (this.extensions != null) {
            sb.append(StringUtil.lineSeparator()).append(this.extensions);
        }
        return sb.toString();
    }

    public ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    public Random getRandom() {
        return this.random;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public boolean hasSessionId() {
        return this.sessionId != null && this.sessionId.length() > 0;
    }

    void setSessionId(SessionId sessionId) {
        this.sessionId = sessionId;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie must not be null!");
        }
        if (cookie.length == 0) {
            throw new IllegalArgumentException("cookie must not be empty!");
        }
        this.cookie = Arrays.copyOf(cookie, cookie.length);
        this.fragmentChanged();
    }

    public List<CipherSuite> getCipherSuites() {
        return Collections.unmodifiableList(this.supportedCipherSuites);
    }

    public List<CompressionMethod> getCompressionMethods() {
        return Collections.unmodifiableList(this.compressionMethods);
    }

    public void setCompressionMethods(List<CompressionMethod> compressionMethods) {
        this.compressionMethods.addAll(compressionMethods);
    }

    public void addCompressionMethod(CompressionMethod compressionMethod) {
        if (this.compressionMethods == null) {
            this.compressionMethods = new ArrayList<CompressionMethod>();
        }
        this.compressionMethods.add(compressionMethod);
    }

    void addExtension(HelloExtension extension) {
        if (this.extensions != null) {
            this.extensions.addExtension(extension);
        }
    }

    public HelloExtensions getExtensions() {
        return this.extensions;
    }

    public SupportedEllipticCurvesExtension getSupportedEllipticCurvesExtension() {
        if (this.extensions != null) {
            return (SupportedEllipticCurvesExtension)this.extensions.getExtension(HelloExtension.ExtensionType.ELLIPTIC_CURVES);
        }
        return null;
    }

    public SupportedPointFormatsExtension getSupportedPointFormatsExtension() {
        if (this.extensions != null) {
            return (SupportedPointFormatsExtension)this.extensions.getExtension(HelloExtension.ExtensionType.EC_POINT_FORMATS);
        }
        return null;
    }

    public ClientCertificateTypeExtension getClientCertificateTypeExtension() {
        if (this.extensions != null) {
            return (ClientCertificateTypeExtension)this.extensions.getExtension(HelloExtension.ExtensionType.CLIENT_CERT_TYPE);
        }
        return null;
    }

    public ServerCertificateTypeExtension getServerCertificateTypeExtension() {
        if (this.extensions != null) {
            return (ServerCertificateTypeExtension)this.extensions.getExtension(HelloExtension.ExtensionType.SERVER_CERT_TYPE);
        }
        return null;
    }

    public SignatureAlgorithmsExtension getSupportedSignatureAlgorithms() {
        if (this.extensions != null) {
            return (SignatureAlgorithmsExtension)this.extensions.getExtension(HelloExtension.ExtensionType.SIGNATURE_ALGORITHMS);
        }
        return null;
    }

    public MaxFragmentLengthExtension getMaxFragmentLengthExtension() {
        if (this.extensions != null) {
            return (MaxFragmentLengthExtension)this.extensions.getExtension(HelloExtension.ExtensionType.MAX_FRAGMENT_LENGTH);
        }
        return null;
    }

    public ServerNameExtension getServerNameExtension() {
        if (this.extensions != null) {
            return (ServerNameExtension)this.extensions.getExtension(HelloExtension.ExtensionType.SERVER_NAME);
        }
        return null;
    }

    public ConnectionIdExtension getConnectionIdExtension() {
        if (this.extensions != null) {
            return (ConnectionIdExtension)this.extensions.getExtension(HelloExtension.ExtensionType.CONNECTION_ID);
        }
        return null;
    }
}

