/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.eclipse.californium.elements.auth.PreSharedKeyIdentity;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PskUtil
implements Destroyable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PskUtil.class);
    private final SecretKey pskSecret;
    private final PskPublicInformation pskIdentity;
    private final PreSharedKeyIdentity pskPrincipal;

    public PskUtil(boolean sniEnabled, DTLSSession session, PskStore pskStore) throws HandshakeException {
        this(sniEnabled, session, pskStore, PskUtil.lookupIdentity(sniEnabled, session, pskStore));
    }

    public PskUtil(boolean sniEnabled, DTLSSession session, PskStore pskStore, PskPublicInformation pskIdentity) throws HandshakeException {
        if (session == null) {
            throw new NullPointerException("Dtls session must not be null");
        }
        if (pskStore == null) {
            throw new NullPointerException("psk store must not be null");
        }
        if (pskIdentity == null) {
            throw new NullPointerException("psk identity must not be null");
        }
        this.pskIdentity = pskIdentity;
        String hostName = null;
        ServerNames serverNames = session.getServerNames();
        if (sniEnabled && serverNames != null) {
            hostName = session.getHostName();
            LOGGER.debug("client [{}] uses PSK identity [{}] for server [{}]", session.getPeer(), pskIdentity, hostName);
            this.pskSecret = pskStore.getKey(serverNames, pskIdentity);
        } else {
            LOGGER.debug("client [{}] uses PSK identity [{}]", (Object)session.getPeer(), (Object)pskIdentity);
            this.pskSecret = pskStore.getKey(pskIdentity);
        }
        if (this.pskSecret == null) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNKNOWN_PSK_IDENTITY, session.getPeer());
            if (hostName != null) {
                throw new HandshakeException(String.format("No pre-shared key found for [virtual host: %s, identity: %s]", hostName, pskIdentity), alert);
            }
            throw new HandshakeException(String.format("No pre-shared key found for [identity: %s]", pskIdentity), alert);
        }
        this.pskPrincipal = sniEnabled ? new PreSharedKeyIdentity(hostName, pskIdentity.getPublicInfoAsString()) : new PreSharedKeyIdentity(pskIdentity.getPublicInfoAsString());
        session.setPeerIdentity(this.pskPrincipal);
    }

    private static PskPublicInformation lookupIdentity(boolean sniEnabled, DTLSSession session, PskStore pskStore) throws HandshakeException {
        PskPublicInformation pskIdentity;
        if (session == null) {
            throw new NullPointerException("Dtls session must not be null");
        }
        if (pskStore == null) {
            throw new NullPointerException("psk store must not be null");
        }
        ServerNames serverName = session.getServerNames();
        if (sniEnabled && serverName != null) {
            if (!session.isSniSupported()) {
                LOGGER.warn("client is configured to use SNI but server does not support it, PSK authentication is likely to fail");
            }
            if ((pskIdentity = pskStore.getIdentity(session.getPeer(), serverName)) == null) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, session.getPeer());
                throw new HandshakeException(String.format("No Identity found for peer [address: %s, virtual host: %s]", session.getPeer(), session.getHostName()), alert);
            }
        } else {
            pskIdentity = pskStore.getIdentity(session.getPeer());
            if (pskIdentity == null) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, session.getPeer());
                throw new HandshakeException(String.format("No Identity found for peer [address: %s]", session.getPeer()), alert);
            }
        }
        return pskIdentity;
    }

    public PreSharedKeyIdentity getPskPrincipal() {
        return this.pskPrincipal;
    }

    public PskPublicInformation getPskPublicIdentity() {
        return this.pskIdentity;
    }

    public SecretKey generatePremasterSecretFromPSK(SecretKey otherSecret) {
        byte[] pskBytes = this.pskSecret.getEncoded();
        int pskLength = pskBytes.length;
        byte[] otherBytes = otherSecret != null ? otherSecret.getEncoded() : new byte[pskLength];
        DatagramWriter writer = new DatagramWriter(true);
        writer.write(otherBytes.length, 16);
        writer.writeBytes(otherBytes);
        writer.write(pskLength, 16);
        writer.writeBytes(pskBytes);
        byte[] secret = writer.toByteArray();
        writer.close();
        SecretKey premaster = SecretUtil.create(secret, "MAC");
        Bytes.clear(pskBytes);
        Bytes.clear(otherBytes);
        Bytes.clear(secret);
        return premaster;
    }

    @Override
    public void destroy() throws DestroyFailedException {
        SecretUtil.destroy(this.pskSecret);
    }

    @Override
    public boolean isDestroyed() {
        return SecretUtil.isDestroyed(this.pskSecret);
    }
}

