/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.elements.util.SimpleCounterStatistic;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.DtlsHealth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtlsHealthLogger
implements DtlsHealth {
    private static final Logger LOGGER = LoggerFactory.getLogger(DTLSConnector.class.getCanonicalName() + ".health");
    private final AtomicInteger pendingHandshakes = new AtomicInteger();
    private final SimpleCounterStatistic.AlignGroup align = new SimpleCounterStatistic.AlignGroup();
    private final SimpleCounterStatistic succeededHandshakes = new SimpleCounterStatistic("handshakes succeeded", this.align);
    private final SimpleCounterStatistic failedHandshakes = new SimpleCounterStatistic("handshakes failed", this.align);
    private final SimpleCounterStatistic receivedRecords = new SimpleCounterStatistic("received records", this.align);
    private final SimpleCounterStatistic droppedReceivedRecords = new SimpleCounterStatistic("dropped received records", this.align);
    private final SimpleCounterStatistic sentRecords = new SimpleCounterStatistic("sending records", this.align);
    private final SimpleCounterStatistic droppedSentRecords = new SimpleCounterStatistic("dropped sending records", this.align);

    @Override
    public void dump(String tag, int maxConnections, int remainingCapacity, int pendingWithoutVerify) {
        try {
            if (this.receivedRecords.isUsed() || this.sentRecords.isUsed()) {
                String eol = StringUtil.lineSeparator();
                String head = "   " + tag;
                String associations = "associations";
                String handshakes = "handshakes pending";
                this.align.add(associations);
                this.align.add(handshakes);
                StringBuilder log = new StringBuilder();
                log.append(tag).append("statistic:").append(eol);
                String msg = SimpleCounterStatistic.format(this.align.getAlign(), associations, maxConnections - remainingCapacity);
                log.append(head).append(msg);
                log.append(" (").append(remainingCapacity).append(" remaining capacity).").append(eol);
                msg = SimpleCounterStatistic.format(this.align.getAlign(), handshakes, this.pendingHandshakes.get());
                log.append(head).append(msg);
                log.append(" (").append(pendingWithoutVerify).append(" without verify).").append(eol);
                log.append(head).append(this.succeededHandshakes).append(eol);
                log.append(head).append(this.failedHandshakes).append(eol);
                log.append(head).append(this.sentRecords).append(eol);
                log.append(head).append(this.droppedSentRecords).append(eol);
                log.append(head).append(this.receivedRecords).append(eol);
                log.append(head).append(this.droppedReceivedRecords);
                LOGGER.debug("{}", (Object)log);
            }
        }
        catch (Throwable e) {
            LOGGER.error("{}", (Object)tag, (Object)e);
        }
    }

    @Override
    public boolean isEnabled() {
        return LOGGER.isDebugEnabled();
    }

    @Override
    public void startHandshake() {
        this.pendingHandshakes.incrementAndGet();
    }

    @Override
    public void endHandshake(boolean success) {
        this.pendingHandshakes.decrementAndGet();
        if (success) {
            this.succeededHandshakes.increment();
        } else {
            this.failedHandshakes.increment();
        }
    }

    @Override
    public void receivingRecord(boolean drop) {
        if (drop) {
            this.droppedReceivedRecords.increment();
        } else {
            this.receivedRecords.increment();
        }
    }

    @Override
    public void sendingRecord(boolean drop) {
        if (drop) {
            this.droppedSentRecords.increment();
        } else {
            this.sentRecords.increment();
        }
    }
}

