/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkInterfacesUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkInterfacesUtil.class);
    public static final int MAX_MTU = 65535;
    private static int anyMtu;
    private static boolean anyIpv4;
    private static boolean anyIpv6;

    private static synchronized void initialize() {
        if (anyMtu == 0) {
            int mtu = 65535;
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface iface = interfaces.nextElement();
                    int ifaceMtu = iface.getMTU();
                    if (ifaceMtu > 0 && ifaceMtu < mtu) {
                        mtu = ifaceMtu;
                    }
                    Enumeration<InetAddress> inetAddresses = iface.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        InetAddress address = inetAddresses.nextElement();
                        if (address instanceof Inet4Address) {
                            anyIpv4 = true;
                            continue;
                        }
                        if (!(address instanceof Inet6Address)) continue;
                        anyIpv6 = true;
                    }
                }
            }
            catch (SocketException ex) {
                LOGGER.warn("discover any interface failed!", ex);
                anyIpv4 = true;
                anyIpv6 = true;
            }
            anyMtu = mtu;
        }
    }

    public static int getAnyMtu() {
        NetworkInterfacesUtil.initialize();
        return anyMtu;
    }

    public static boolean isAnyIpv4() {
        NetworkInterfacesUtil.initialize();
        return anyIpv4;
    }

    public static boolean isAnyIpv6() {
        NetworkInterfacesUtil.initialize();
        return anyIpv6;
    }

    public static Collection<InetAddress> getNetworkInterfaces() {
        LinkedList<InetAddress> interfaces = new LinkedList<InetAddress>();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            while (nets.hasMoreElements()) {
                Enumeration<InetAddress> inetAddresses = nets.nextElement().getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    interfaces.add(inetAddresses.nextElement());
                }
            }
        }
        catch (SocketException e) {
            LOGGER.error("could not fetch all interface addresses", e);
        }
        return interfaces;
    }
}

