/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.server.MessageDeliverer;
import org.eclipse.californium.elements.util.NetworkInterfacesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointManager.class);
    private static final EndpointManager manager = new EndpointManager();
    private final Map<String, Endpoint> endpoints = new ConcurrentHashMap<String, Endpoint>();

    public static EndpointManager getEndpointManager() {
        return manager;
    }

    public synchronized Endpoint getDefaultEndpoint(String uriScheme) {
        if (null == uriScheme) {
            uriScheme = "coap";
        }
        if (!CoAP.isSupportedScheme(uriScheme)) {
            throw new IllegalArgumentException("URI scheme " + uriScheme + " not supported!");
        }
        Endpoint endpoint = this.endpoints.get(uriScheme = uriScheme.toLowerCase());
        if (null == endpoint) {
            if ("coaps".equalsIgnoreCase(uriScheme)) {
                throw new IllegalStateException("URI scheme " + uriScheme + " requires a previous set connector!");
            }
            if ("coap+tcp".equalsIgnoreCase(uriScheme)) {
                throw new IllegalStateException("URI scheme " + uriScheme + " requires a previous set connector!");
            }
            if ("coaps+tcp".equalsIgnoreCase(uriScheme)) {
                throw new IllegalStateException("URI scheme " + uriScheme + " requires a previous set connector!");
            }
            endpoint = new CoapEndpoint.Builder().build();
            try {
                endpoint.start();
                LOGGER.info("created implicit endpoint {} for {}", new Object[]{endpoint.getUri(), uriScheme});
            }
            catch (IOException e) {
                LOGGER.error("could not create {} endpoint", (Object)uriScheme, (Object)e);
            }
            this.endpoints.put(uriScheme, endpoint);
        }
        return endpoint;
    }

    public synchronized void setDefaultEndpoint(Endpoint newEndpoint) {
        if (null == newEndpoint) {
            throw new NullPointerException("endpoint required!");
        }
        URI uri = newEndpoint.getUri();
        if (null == uri) {
            throw new IllegalArgumentException("Endpoint protocol not supported!");
        }
        String uriScheme = uri.getScheme();
        if (!CoAP.isSupportedScheme(uriScheme)) {
            throw new IllegalArgumentException("URI scheme " + uriScheme + " not supported!");
        }
        Endpoint oldEndpoint = this.endpoints.put(uriScheme, newEndpoint);
        if (null != oldEndpoint) {
            oldEndpoint.destroy();
        }
        if (!newEndpoint.isStarted()) {
            try {
                newEndpoint.start();
            }
            catch (IOException e) {
                LOGGER.error("could not start new {} endpoint", (Object)uriScheme, (Object)e);
            }
        }
    }

    public Endpoint getDefaultEndpoint() {
        return this.getDefaultEndpoint("coap");
    }

    @Deprecated
    public Collection<InetAddress> getNetworkInterfaces() {
        return NetworkInterfacesUtil.getNetworkInterfaces();
    }

    public static void clear() {
        EndpointManager it = EndpointManager.getEndpointManager();
        for (Endpoint endpoint : it.endpoints.values()) {
            endpoint.clear();
        }
    }

    public static void reset() {
        EndpointManager it = EndpointManager.getEndpointManager();
        for (Endpoint endpoint : it.endpoints.values()) {
            endpoint.destroy();
        }
        it.endpoints.clear();
    }

    public static class ClientMessageDeliverer
    implements MessageDeliverer {
        @Override
        public void deliverRequest(Exchange exchange) {
            LOGGER.error("Default endpoint without CoapServer has received a request.");
            exchange.sendReject();
        }

        @Override
        public void deliverResponse(Exchange exchange, Response response) {
            if (exchange == null) {
                throw new NullPointerException("no CoAP exchange!");
            }
            if (exchange.getRequest() == null) {
                throw new NullPointerException("no CoAP request!");
            }
            if (response == null) {
                throw new NullPointerException("no CoAP response!");
            }
            exchange.getRequest().setResponse(response);
        }
    }
}

