/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.Arrays;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.ServerKeyExchange;
import org.eclipse.californium.scandium.dtls.cipher.ECDHECryptography;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EcdhPskServerKeyExchange
extends ServerKeyExchange {
    private static final Logger LOGGER = LoggerFactory.getLogger(EcdhPskServerKeyExchange.class);
    private static final int IDENTITY_HINT_LENGTH_BITS = 16;
    private static final String MSG_UNKNOWN_CURVE_TYPE = "Unknown curve type [{}]";
    private static final int CURVE_TYPE_BITS = 8;
    private static final int NAMED_CURVE_BITS = 16;
    private static final int PUBLIC_LENGTH_BITS = 8;
    private final PskPublicInformation hint;
    private static final int EXPLICIT_PRIME = 1;
    private static final int EXPLICIT_CHAR2 = 2;
    private static final int NAMED_CURVE = 3;
    private ECPublicKey publicKey = null;
    private byte[] pointEncoded = null;
    private final int curveId;
    private int curveType = 3;

    public EcdhPskServerKeyExchange(PskPublicInformation pskHint, ECDHECryptography ecdhe, Random clientRandom, Random serverRandom, int namedCurveId, InetSocketAddress peerAddress) {
        super(peerAddress);
        if (ecdhe == null) {
            throw new NullPointerException("ECDHECryptography class object cannot be null");
        }
        if (clientRandom == null || serverRandom == null) {
            throw new NullPointerException("nonce cannot be null");
        }
        this.hint = pskHint;
        this.curveId = namedCurveId;
        this.publicKey = ecdhe.getPublicKey();
        ECParameterSpec parameters = this.publicKey.getParams();
        this.pointEncoded = ECDHECryptography.encodePoint(this.publicKey.getW(), parameters.getCurve());
    }

    private EcdhPskServerKeyExchange(byte[] hintEncoded, int curveId, byte[] pointEncoded, InetSocketAddress peerAddress) throws HandshakeException {
        super(peerAddress);
        this.curveId = curveId;
        this.hint = PskPublicInformation.fromByteArray(hintEncoded);
        if (pointEncoded == null) {
            throw new NullPointerException("ephemeral public key cannot be null");
        }
        this.pointEncoded = Arrays.copyOf(pointEncoded, pointEncoded.length);
        ECDHECryptography.SupportedGroup group = ECDHECryptography.SupportedGroup.fromId(curveId);
        if (group == null || !group.isUsable()) {
            throw new HandshakeException(String.format("Server used unsupported elliptic curve (%d) for ECDH", curveId), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, peerAddress));
        }
        try {
            ECParameterSpec params = group.getEcParams();
            DatagramReader reader = new DatagramReader(pointEncoded, false);
            this.publicKey = Asn1DerDecoder.readEcPublicKey(reader, params);
        }
        catch (GeneralSecurityException e) {
            LOGGER.debug("Cannot re-create server's public key from params", e);
            throw new HandshakeException(String.format("Cannot re-create server's public key from params: %s", e.getMessage()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, peerAddress));
        }
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.hint.length(), 16);
        writer.writeBytes(this.hint.getBytes());
        switch (this.curveType) {
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                this.writeNamedCurve(writer);
                break;
            }
            default: {
                LOGGER.warn(MSG_UNKNOWN_CURVE_TYPE, (Object)this.curveType);
            }
        }
        return writer.toByteArray();
    }

    private void writeNamedCurve(DatagramWriter writer) {
        writer.write(3, 8);
        writer.write(this.curveId, 16);
        writer.write(this.pointEncoded.length, 8);
        writer.writeBytes(this.pointEncoded);
    }

    public static HandshakeMessage fromReader(DatagramReader reader, InetSocketAddress peerAddress) throws HandshakeException {
        if (peerAddress == null) {
            throw new NullPointerException("peer address cannot be null");
        }
        int hintLength = reader.read(16);
        byte[] hintEncoded = reader.readBytes(hintLength);
        int curveType = reader.read(8);
        switch (curveType) {
            case 3: {
                int curveId = reader.read(16);
                int length = reader.read(8);
                byte[] pointEncoded = reader.readBytes(length);
                return new EcdhPskServerKeyExchange(hintEncoded, curveId, pointEncoded, peerAddress);
            }
        }
        throw new HandshakeException(String.format("Curve type [%s] received in ServerKeyExchange message from peer [%s] is unsupported", curveType, peerAddress), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, peerAddress));
    }

    @Override
    public int getMessageLength() {
        int length = 0;
        switch (this.curveType) {
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                length = 6 + this.hint.length() + this.pointEncoded.length;
                break;
            }
            default: {
                LOGGER.warn(MSG_UNKNOWN_CURVE_TYPE, (Object)this.curveType);
            }
        }
        return length;
    }

    public ECPublicKey getPublicKey() {
        return this.publicKey;
    }

    public int getCurveId() {
        return this.curveId;
    }

    public PskPublicInformation getHint() {
        return this.hint;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this.hint.isEmpty()) {
            sb.append("\t\tPSK Identity Hint: ").append("psk hint not present");
        } else {
            sb.append("\t\tPSK Identity Hint: ").append(this.hint);
        }
        sb.append("\t\tEC Diffie-Hellman public key: ");
        sb.append(this.getPublicKey().toString());
        sb.append(StringUtil.lineSeparator());
        return sb.toString();
    }
}

