/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.tcp.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.RawDataChannel;
import org.eclipse.californium.elements.exception.EndpointMismatchException;
import org.eclipse.californium.elements.exception.EndpointUnconnectedException;
import org.eclipse.californium.elements.exception.MulticastNotSupportedException;
import org.eclipse.californium.elements.tcp.netty.CloseOnErrorHandler;
import org.eclipse.californium.elements.tcp.netty.CloseOnIdleHandler;
import org.eclipse.californium.elements.tcp.netty.DatagramFramer;
import org.eclipse.californium.elements.tcp.netty.DispatchHandler;
import org.eclipse.californium.elements.tcp.netty.TcpContextUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpServerConnector
implements Connector {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass().getName());
    private final int numberOfThreads;
    private final int connectionIdleTimeoutSeconds;
    private final InetSocketAddress localAddress;
    private final TcpContextUtil contextUtil;
    private final ConcurrentMap<SocketAddress, Channel> activeChannels = new ConcurrentHashMap<SocketAddress, Channel>();
    private volatile EndpointContextMatcher endpointContextMatcher;
    private volatile InetSocketAddress effectiveLocalAddress;
    private RawDataChannel rawDataChannel;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public TcpServerConnector(InetSocketAddress localAddress, int numberOfThreads, int idleTimeout) {
        this(localAddress, numberOfThreads, idleTimeout, new TcpContextUtil());
    }

    protected TcpServerConnector(InetSocketAddress localAddress, int numberOfThreads, int idleTimeout, TcpContextUtil contextUtil) {
        this.numberOfThreads = numberOfThreads;
        this.connectionIdleTimeoutSeconds = idleTimeout;
        this.localAddress = localAddress;
        this.contextUtil = contextUtil;
        this.effectiveLocalAddress = localAddress;
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.rawDataChannel == null) {
            throw new IllegalStateException("Cannot start without message handler.");
        }
        if (this.bossGroup != null) {
            throw new IllegalStateException("Connector already started");
        }
        if (this.workerGroup != null) {
            throw new IllegalStateException("Connector already started");
        }
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup(this.numberOfThreads);
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler(new ChannelRegistry()).option(ChannelOption.SO_BACKLOG, 100)).option(ChannelOption.AUTO_READ, true)).childOption(ChannelOption.SO_KEEPALIVE, true);
        ChannelFuture channelFuture = bootstrap.bind(this.localAddress).syncUninterruptibly();
        if (channelFuture.isSuccess() && 0 == this.localAddress.getPort()) {
            InetSocketAddress listenAddress = (InetSocketAddress)channelFuture.channel().localAddress();
            this.effectiveLocalAddress = new InetSocketAddress(this.localAddress.getAddress(), listenAddress.getPort());
        }
    }

    @Override
    public synchronized void stop() {
        if (null != this.bossGroup) {
            this.bossGroup.shutdownGracefully(0L, 500L, TimeUnit.MILLISECONDS).syncUninterruptibly();
            this.bossGroup = null;
        }
        if (null != this.workerGroup) {
            this.workerGroup.shutdownGracefully(0L, 500L, TimeUnit.MILLISECONDS).syncUninterruptibly();
            this.workerGroup = null;
        }
        this.effectiveLocalAddress = this.localAddress;
    }

    @Override
    public void destroy() {
        this.stop();
    }

    @Override
    public void send(final RawData msg) {
        if (msg == null) {
            throw new NullPointerException("Message must not be null");
        }
        if (msg.isMulticast()) {
            this.LOGGER.warn("TcpConnector drops {} bytes to multicast {}:{}", msg.getSize(), msg.getAddress(), msg.getPort());
            msg.onError(new MulticastNotSupportedException("TCP doesn't support multicast!"));
            return;
        }
        if (this.bossGroup == null) {
            msg.onError(new IllegalStateException("TCP server connector not running!"));
            return;
        }
        Channel channel = (Channel)this.activeChannels.get(msg.getInetSocketAddress());
        if (channel == null) {
            this.LOGGER.debug("Attempting to send message to an address without an active connection {}", (Object)msg.getAddress());
            msg.onError(new EndpointUnconnectedException());
            return;
        }
        EndpointContext context = this.contextUtil.buildEndpointContext(channel);
        EndpointContextMatcher endpointMatcher = this.getEndpointContextMatcher();
        if (null != endpointMatcher && !endpointMatcher.isToBeSent(msg.getEndpointContext(), context)) {
            this.LOGGER.warn("TcpConnector drops {} bytes to {}:{}", msg.getSize(), msg.getAddress(), msg.getPort());
            msg.onError(new EndpointMismatchException());
            return;
        }
        msg.onContextEstablished(context);
        ChannelFuture channelFuture = channel.writeAndFlush(Unpooled.wrappedBuffer(msg.getBytes()));
        channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<ChannelFuture>(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    msg.onSent();
                } else if (future.isCancelled()) {
                    msg.onError(new CancellationException());
                } else {
                    msg.onError(future.cause());
                }
            }
        });
    }

    @Override
    public void setRawDataReceiver(RawDataChannel messageHandler) {
        if (this.rawDataChannel != null) {
            throw new IllegalStateException("RawDataChannel already set");
        }
        this.rawDataChannel = messageHandler;
    }

    @Override
    public void setEndpointContextMatcher(EndpointContextMatcher matcher) {
        this.endpointContextMatcher = matcher;
    }

    private EndpointContextMatcher getEndpointContextMatcher() {
        return this.endpointContextMatcher;
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.effectiveLocalAddress;
    }

    protected void onNewChannelCreated(Channel ch) {
    }

    @Override
    public String getProtocol() {
        return "TCP";
    }

    public String toString() {
        return this.getProtocol() + "-" + StringUtil.toString(this.getAddress());
    }

    private class ChannelTracker
    extends ChannelInboundHandlerAdapter {
        private ChannelTracker() {
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            TcpServerConnector.this.activeChannels.put(ctx.channel().remoteAddress(), ctx.channel());
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            TcpServerConnector.this.activeChannels.remove(ctx.channel().remoteAddress());
        }
    }

    private class ChannelRegistry
    extends ChannelInitializer<SocketChannel> {
        private ChannelRegistry() {
        }

        @Override
        protected void initChannel(SocketChannel ch) throws Exception {
            TcpServerConnector.this.onNewChannelCreated(ch);
            ch.pipeline().addLast(new ChannelTracker());
            ch.pipeline().addLast(new IdleStateHandler(0, 0, TcpServerConnector.this.connectionIdleTimeoutSeconds));
            ch.pipeline().addLast(new CloseOnIdleHandler());
            ch.pipeline().addLast(new DatagramFramer(TcpServerConnector.this.contextUtil));
            ch.pipeline().addLast(new DispatchHandler(TcpServerConnector.this.rawDataChannel));
            ch.pipeline().addLast(new CloseOnErrorHandler());
        }
    }
}

