/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.californium.elements.util.Base64;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class Base64Test {
    @Parameterized.Parameter
    public byte[] input;

    @Parameterized.Parameters
    public static List<byte[]> params() {
        return Arrays.asList({1, 2, 3}, {1, 2, 3, 4}, {1, 2, 3, 4, 5});
    }

    @Test
    public void testEncodeBytesRecognizesNoPaddingOption() throws IOException {
        String result = Base64.encodeBytes(this.input, 17);
        int excessBytes = this.input.length % 3;
        int expectedLength = (1 + (excessBytes > 0 ? 1 : 0)) * 4;
        Assert.assertThat((Object)result.length(), (Matcher)CoreMatchers.is((Object)expectedLength));
        if (this.input.length % 3 > 0) {
            Assert.assertTrue((boolean)result.endsWith("="));
        }
        result = Base64.encodeBytes(this.input, 81);
        Assert.assertFalse((boolean)result.endsWith("="));
        expectedLength = 4 + (excessBytes > 0 ? excessBytes + 1 : 0);
        Assert.assertThat((Object)result.length(), (Matcher)CoreMatchers.is((Object)expectedLength));
    }
}

