/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import java.security.Principal;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.util.StringUtil;

public class DtlsEndpointContext
extends MapBasedEndpointContext {
    public static final String KEY_SESSION_ID = "DTLS_SESSION_ID";
    public static final String KEY_EPOCH = "DTLS_EPOCH";
    public static final String KEY_CIPHER = "DTLS_CIPHER";
    public static final String KEY_HANDSHAKE_TIMESTAMP = "DTLS_HANDSHAKE_TIMESTAMP";
    public static final String KEY_HANDSHAKE_MODE = "*DTLS_HANDSHAKE_MODE";
    public static final String HANDSHAKE_MODE_FORCE_FULL = "full";
    public static final String HANDSHAKE_MODE_FORCE = "force";
    public static final String HANDSHAKE_MODE_NONE = "none";
    public static final String KEY_RESUMPTION_TIMEOUT = "*DTLS_RESUMPTION_TIMEOUT";

    public DtlsEndpointContext(InetSocketAddress peerAddress, Principal peerIdentity, String sessionId, String epoch, String cipher, String timestamp) {
        this(peerAddress, (String)null, peerIdentity, sessionId, epoch, cipher, timestamp);
    }

    public DtlsEndpointContext(InetSocketAddress peerAddress, String virtualHost, Principal peerIdentity, String sessionId, String epoch, String cipher, String timestamp) {
        super(peerAddress, virtualHost, peerIdentity, KEY_SESSION_ID, sessionId, KEY_CIPHER, cipher, KEY_EPOCH, epoch, KEY_HANDSHAKE_TIMESTAMP, timestamp);
    }

    public final String getSessionId() {
        return this.get(KEY_SESSION_ID);
    }

    public final String getEpoch() {
        return this.get(KEY_EPOCH);
    }

    public final String getCipher() {
        return this.get(KEY_CIPHER);
    }

    public final String getHandshakeTimestamp() {
        return this.get(KEY_HANDSHAKE_TIMESTAMP);
    }

    @Override
    public String toString() {
        return String.format("DTLS(%s,ID:%s)", this.getPeerAddressAsString(), StringUtil.trunc(this.getSessionId(), 10));
    }
}

