/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.stack.AbstractLayer;
import org.eclipse.californium.core.observe.ObserveRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpObserveLayer
extends AbstractLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpObserveLayer.class.getName());
    private static final Integer CANCEL = 1;

    public TcpObserveLayer(NetworkConfig config) {
    }

    @Override
    public void sendRequest(Exchange exchange, Request request) {
        if (CANCEL.equals(request.getOptions().getObserve())) {
            // empty if block
        }
        this.lower().sendRequest(exchange, request);
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        ObserveRelation relation = exchange.getRelation();
        if (relation != null && relation.isEstablished() && !response.getOptions().hasObserve()) {
            relation.cancel();
        }
        this.lower().sendResponse(exchange, response);
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        if (response.getOptions().hasObserve() && exchange.getRequest().isCanceled()) {
            LOGGER.debug("ignoring notification for canceled TCP Exchange");
        } else {
            this.upper().receiveResponse(exchange, response);
        }
    }
}

