/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.ICBORNumber;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;

class CBOREInteger
implements ICBORNumber {
    CBOREInteger() {
    }

    public boolean IsPositiveInfinity(Object obj) {
        return false;
    }

    public boolean IsInfinity(Object obj) {
        return false;
    }

    public boolean IsNegativeInfinity(Object obj) {
        return false;
    }

    public boolean IsNaN(Object obj) {
        return false;
    }

    public double AsDouble(Object obj) {
        return EFloat.FromEInteger((EInteger)obj).ToDouble();
    }

    public EDecimal AsExtendedDecimal(Object obj) {
        return EDecimal.FromEInteger((EInteger)obj);
    }

    public EFloat AsExtendedFloat(Object obj) {
        return EFloat.FromEInteger((EInteger)obj);
    }

    public float AsSingle(Object obj) {
        return EFloat.FromEInteger((EInteger)obj).ToSingle();
    }

    public EInteger AsEInteger(Object obj) {
        return (EInteger)obj;
    }

    public long AsInt64(Object obj) {
        EInteger bi = (EInteger)obj;
        if (bi.compareTo(CBORObject.Int64MaxValue) > 0 || bi.compareTo(CBORObject.Int64MinValue) < 0) {
            throw new ArithmeticException("This Object's value is out of range");
        }
        return bi.ToInt64Checked();
    }

    public boolean CanFitInSingle(Object obj) {
        EFloat ef2;
        EInteger bigintItem = (EInteger)obj;
        EFloat ef = EFloat.FromEInteger(bigintItem);
        return ef.compareTo(ef2 = EFloat.FromSingle(ef.ToSingle())) == 0;
    }

    public boolean CanFitInDouble(Object obj) {
        EFloat ef2;
        EInteger bigintItem = (EInteger)obj;
        EFloat ef = EFloat.FromEInteger(bigintItem);
        return ef.compareTo(ef2 = EFloat.FromDouble(ef.ToDouble())) == 0;
    }

    public boolean CanFitInInt32(Object obj) {
        EInteger bi = (EInteger)obj;
        return bi.CanFitInInt32();
    }

    public boolean CanFitInInt64(Object obj) {
        EInteger bi = (EInteger)obj;
        return bi.GetSignedBitLength() <= 63;
    }

    public boolean CanTruncatedIntFitInInt64(Object obj) {
        return this.CanFitInInt64(obj);
    }

    public boolean CanTruncatedIntFitInInt32(Object obj) {
        return this.CanFitInInt32(obj);
    }

    public boolean IsZero(Object obj) {
        return ((EInteger)obj).isZero();
    }

    public int Sign(Object obj) {
        return ((EInteger)obj).signum();
    }

    public boolean IsIntegral(Object obj) {
        return true;
    }

    public int AsInt32(Object obj, int minValue, int maxValue) {
        int ret;
        EInteger bi = (EInteger)obj;
        if (bi.CanFitInInt32() && (ret = bi.ToInt32Checked()) >= minValue && ret <= maxValue) {
            return ret;
        }
        throw new ArithmeticException("This Object's value is out of range");
    }

    public Object Negate(Object obj) {
        EInteger bigobj = (EInteger)obj;
        bigobj = bigobj.Negate();
        return bigobj;
    }

    public Object Abs(Object obj) {
        return ((EInteger)obj).Abs();
    }

    public ERational AsExtendedRational(Object obj) {
        return ERational.FromEInteger((EInteger)obj);
    }

    public boolean IsNegative(Object obj) {
        return ((EInteger)obj).signum() < 0;
    }
}

