/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.eclipse.californium.elements.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatagramWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatagramWriter.class.getCanonicalName());
    private final ByteArrayOutputStream byteStream;
    private byte currentByte;
    private int currentBitIndex;

    public DatagramWriter() {
        this(false);
    }

    public DatagramWriter(boolean secureClose) {
        this.byteStream = secureClose ? new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                Bytes.clear(this.buf);
                super.close();
            }
        } : new ByteArrayOutputStream();
        this.resetCurrentByte();
    }

    public DatagramWriter(int size) {
        this.byteStream = new ByteArrayOutputStream(size);
        this.resetCurrentByte();
    }

    public void writeLong(long data, int numBits) {
        if (numBits < 32 && data >= (long)(1 << numBits)) {
            throw new IllegalArgumentException(String.format("Truncating value %d to %d-bit integer", data, numBits));
        }
        for (int i = numBits - 1; i >= 0; --i) {
            boolean bit;
            boolean bl = bit = (data >> i & 1L) != 0L;
            if (bit) {
                this.currentByte = (byte)(this.currentByte | 1 << this.currentBitIndex);
            }
            --this.currentBitIndex;
            if (this.currentBitIndex >= 0) continue;
            this.writeCurrentByte();
        }
    }

    public void write(int data, int numBits) {
        if (numBits < 32 && data >= 1 << numBits) {
            throw new IllegalArgumentException(String.format("Truncating value %d to %d-bit integer", data, numBits));
        }
        for (int i = numBits - 1; i >= 0; --i) {
            boolean bit;
            boolean bl = bit = (data >> i & 1) != 0;
            if (bit) {
                this.currentByte = (byte)(this.currentByte | 1 << this.currentBitIndex);
            }
            --this.currentBitIndex;
            if (this.currentBitIndex >= 0) continue;
            this.writeCurrentByte();
        }
    }

    public void writeBytes(byte[] bytes) {
        if (bytes == null) {
            return;
        }
        if (this.isBytePending()) {
            for (int i = 0; i < bytes.length; ++i) {
                this.write(bytes[i], 8);
            }
        } else {
            this.byteStream.write(bytes, 0, bytes.length);
        }
    }

    public void writeByte(byte b) {
        if (this.isBytePending()) {
            this.writeBytes(new byte[]{b});
        } else {
            this.byteStream.write(b);
        }
    }

    public byte[] toByteArray() {
        this.writeCurrentByte();
        byte[] byteArray = this.byteStream.toByteArray();
        this.byteStream.reset();
        return byteArray;
    }

    public void write(DatagramWriter data) {
        try {
            data.writeCurrentByte();
            data.byteStream.writeTo(this.byteStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int size() {
        return this.byteStream.size();
    }

    public void close() {
        try {
            this.byteStream.close();
        }
        catch (IOException e) {
            LOGGER.warn("{}.close() failed!", (Object)this.byteStream.getClass(), (Object)e);
        }
    }

    public void writeCurrentByte() {
        if (this.isBytePending()) {
            this.byteStream.write(this.currentByte);
            this.resetCurrentByte();
        }
    }

    public final boolean isBytePending() {
        return this.currentBitIndex < 7;
    }

    private final void resetCurrentByte() {
        this.currentByte = 0;
        this.currentBitIndex = 7;
    }

    public String toString() {
        byte[] byteArray = this.byteStream.toByteArray();
        if (byteArray != null && byteArray.length != 0) {
            StringBuilder builder = new StringBuilder(byteArray.length * 3);
            for (int i = 0; i < byteArray.length; ++i) {
                builder.append(String.format("%02X", 0xFF & byteArray[i]));
                if (i >= byteArray.length - 1) continue;
                builder.append(' ');
            }
            return builder.toString();
        }
        return "--";
    }
}

