/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORUtilities;
import com.upokecenter.cbor.ICBORNumber;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;

final class CBORSingle
implements ICBORNumber {
    private static final float SingleOneLsh64 = 9.223372E18f;

    CBORSingle() {
    }

    public boolean IsPositiveInfinity(Object obj) {
        return ((Float)obj).floatValue() == Float.POSITIVE_INFINITY;
    }

    public boolean IsInfinity(Object obj) {
        return Float.valueOf(((Float)obj).floatValue()).isInfinite();
    }

    public boolean IsNegativeInfinity(Object obj) {
        return ((Float)obj).floatValue() == Float.NEGATIVE_INFINITY;
    }

    public boolean IsNaN(Object obj) {
        return Float.isNaN(((Float)obj).floatValue());
    }

    public double AsDouble(Object obj) {
        return ((Float)obj).doubleValue();
    }

    public EDecimal AsExtendedDecimal(Object obj) {
        return EDecimal.FromSingle(((Float)obj).floatValue());
    }

    public EFloat AsExtendedFloat(Object obj) {
        return EFloat.FromSingle(((Float)obj).floatValue());
    }

    public float AsSingle(Object obj) {
        return ((Float)obj).floatValue();
    }

    public EInteger AsEInteger(Object obj) {
        return CBORUtilities.BigIntegerFromSingle(((Float)obj).floatValue());
    }

    public long AsInt64(Object obj) {
        float fltItem = ((Float)obj).floatValue();
        if (Float.isNaN(fltItem)) {
            throw new ArithmeticException("This Object's value is out of range");
        }
        float f = fltItem = fltItem < 0.0f ? (float)Math.ceil(fltItem) : (float)Math.floor(fltItem);
        if (fltItem >= -9.223372E18f && fltItem < 9.223372E18f) {
            return (long)fltItem;
        }
        throw new ArithmeticException("This Object's value is out of range");
    }

    public boolean CanFitInSingle(Object obj) {
        return true;
    }

    public boolean CanFitInDouble(Object obj) {
        return true;
    }

    public boolean CanFitInInt32(Object obj) {
        return this.IsIntegral(obj) && this.CanTruncatedIntFitInInt32(obj);
    }

    public boolean CanFitInInt64(Object obj) {
        return this.IsIntegral(obj) && this.CanTruncatedIntFitInInt64(obj);
    }

    public boolean CanTruncatedIntFitInInt64(Object obj) {
        float fltItem = ((Float)obj).floatValue();
        if (Float.isNaN(fltItem) || Float.valueOf(fltItem).isInfinite()) {
            return false;
        }
        float fltItem2 = fltItem < 0.0f ? (float)Math.ceil(fltItem) : (float)Math.floor(fltItem);
        return fltItem2 >= -9.223372E18f && fltItem2 < 9.223372E18f;
    }

    public boolean CanTruncatedIntFitInInt32(Object obj) {
        float fltItem = ((Float)obj).floatValue();
        if (Float.isNaN(fltItem) || Float.valueOf(fltItem).isInfinite()) {
            return false;
        }
        float fltItem2 = fltItem < 0.0f ? (float)Math.ceil(fltItem) : (float)Math.floor(fltItem);
        return (double)fltItem2 >= -2.147483648E9 && (double)fltItem2 <= 2.147483647E9;
    }

    public int AsInt32(Object obj, int minValue, int maxValue) {
        float fltItem = ((Float)obj).floatValue();
        if (Float.isNaN(fltItem)) {
            throw new ArithmeticException("This Object's value is out of range");
        }
        float f = fltItem = fltItem < 0.0f ? (float)Math.ceil(fltItem) : (float)Math.floor(fltItem);
        if ((double)fltItem >= -2.147483648E9 && (double)fltItem <= 2.147483647E9) {
            int ret = (int)fltItem;
            return ret;
        }
        throw new ArithmeticException("This Object's value is out of range");
    }

    public boolean IsZero(Object obj) {
        return ((Float)obj).floatValue() == 0.0f;
    }

    public int Sign(Object obj) {
        float flt = ((Float)obj).floatValue();
        return Float.isNaN(flt) ? 2 : (flt == 0.0f ? 0 : (flt < 0.0f ? -1 : 1));
    }

    public boolean IsIntegral(Object obj) {
        float fltItem = ((Float)obj).floatValue();
        if (Float.isNaN(fltItem) || Float.valueOf(fltItem).isInfinite()) {
            return false;
        }
        float fltItem2 = fltItem < 0.0f ? (float)Math.ceil(fltItem) : (float)Math.floor(fltItem);
        return fltItem == fltItem2;
    }

    public Object Negate(Object obj) {
        float val = ((Float)obj).floatValue();
        return Float.valueOf(-val);
    }

    public Object Abs(Object obj) {
        float val = ((Float)obj).floatValue();
        return val < 0.0f ? Float.valueOf(-val) : obj;
    }

    public ERational AsExtendedRational(Object obj) {
        return ERational.FromSingle(((Float)obj).floatValue());
    }

    public boolean IsNegative(Object obj) {
        float val = ((Float)obj).floatValue();
        int ivalue = Float.floatToRawIntBits(val);
        return ivalue >> 31 != 0;
    }
}

