/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.InvalidMacException;

public class CbcBlockCipher {
    public static byte[] decrypt(CipherSuite suite, SecretKey key, SecretKey macKey, byte[] additionalData, byte[] ciphertext) throws GeneralSecurityException {
        DatagramReader reader = new DatagramReader(ciphertext);
        byte[] iv = reader.readBytes(suite.getRecordIvLength());
        Cipher blockCipher = suite.getThreadLocalCipher();
        blockCipher.init(2, (Key)key, new IvParameterSpec(iv));
        byte[] plaintext = blockCipher.doFinal(reader.readBytesLeft());
        int macLength = suite.getMacLength();
        int paddingLength = plaintext[plaintext.length - 1] & 0xFF;
        int fragmentLength = plaintext.length - 1 - paddingLength - macLength;
        if (fragmentLength < 0) {
            throw new InvalidMacException();
        }
        for (int index = fragmentLength + macLength; index < plaintext.length; ++index) {
            if (plaintext[index] == (byte)paddingLength) continue;
            throw new InvalidMacException();
        }
        byte[] content = Arrays.copyOf(plaintext, fragmentLength);
        byte[] macFromMessage = Arrays.copyOfRange(plaintext, fragmentLength, fragmentLength + macLength);
        int additionalIndex = additionalData.length - 2;
        additionalData[additionalIndex] = (byte)(fragmentLength >> 8 & 0xFF);
        additionalData[additionalIndex + 1] = (byte)(fragmentLength & 0xFF);
        byte[] mac = CbcBlockCipher.getBlockCipherMac(suite.getThreadLocalMac(), macKey, additionalData, plaintext, fragmentLength);
        if (Arrays.equals(macFromMessage, mac)) {
            return content;
        }
        throw new InvalidMacException(mac, macFromMessage);
    }

    public static byte[] encrypt(CipherSuite suite, SecretKey key, SecretKey macKey, byte[] additionalData, byte[] plaintext) throws GeneralSecurityException {
        DatagramWriter message = new DatagramWriter();
        message.writeBytes(plaintext);
        message.writeBytes(CbcBlockCipher.getBlockCipherMac(suite.getThreadLocalMac(), macKey, additionalData, plaintext, plaintext.length));
        int ciphertextLength = plaintext.length + suite.getMacLength() + 1;
        int blocksize = suite.getRecordIvLength();
        int lastBlockBytes = ciphertextLength % blocksize;
        int paddingLength = lastBlockBytes > 0 ? blocksize - lastBlockBytes : 0;
        byte[] padding = new byte[paddingLength + 1];
        Arrays.fill(padding, (byte)paddingLength);
        message.writeBytes(padding);
        Cipher blockCipher = suite.getThreadLocalCipher();
        blockCipher.init(1, key);
        DatagramWriter result = new DatagramWriter();
        result.writeBytes(blockCipher.getIV());
        result.writeBytes(blockCipher.doFinal(message.toByteArray()));
        return result.toByteArray();
    }

    public static byte[] getBlockCipherMac(Mac hmac, SecretKey macKey, byte[] additionalData, byte[] content, int length) throws InvalidKeyException {
        hmac.init(macKey);
        hmac.update(additionalData);
        hmac.update(content, 0, length);
        return hmac.doFinal();
    }
}

