/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.DatagramSocketImplFactory;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.californium.elements.util.AbstractDatagramSocketImpl;
import org.eclipse.californium.elements.util.DatagramFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectDatagramSocketImpl
extends AbstractDatagramSocketImpl {
    public static final int AUTO_PORT_RANGE_MIN = 8192;
    public static final int AUTO_PORT_RANGE_MAX = 65535;
    public static final int AUTO_PORT_RANGE_SIZE = 57344;
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectDatagramSocketImpl.class.getName());
    private static final DatagramSocketImplFactory DEFAULT = new DirectDatagramSocketImplFactory();
    private static final ConcurrentMap<Integer, List<DirectDatagramSocketImpl>> map = new ConcurrentHashMap<Integer, List<DirectDatagramSocketImpl>>();
    private static final ConcurrentLinkedQueue<String> logBuffer = new ConcurrentLinkedQueue();
    private static final AtomicBoolean enableLoggingBuffer = new AtomicBoolean();
    private static final AtomicLong loggingBufferStartTimeNanos = new AtomicLong();
    private static final AtomicReference<DatagramSocketImplFactory> init = new AtomicReference();
    private static final AtomicInteger nextPort = new AtomicInteger(0);
    private static final AtomicReference<Setup> setup = new AtomicReference();
    private final BlockingQueue<DatagramExchange> incomingQueue = new LinkedBlockingQueue<DatagramExchange>();
    private InetAddress localAddress;
    private boolean closed;
    private final Set<InetAddress> multicast = new HashSet<InetAddress>();

    private DirectDatagramSocketImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void bind(int lport, InetAddress laddr) throws SocketException {
        LOGGER.debug("binding to port {}, address {}", (Object)lport, (Object)laddr);
        int port = this.bind(lport);
        DirectDatagramSocketImpl directDatagramSocketImpl = this;
        synchronized (directDatagramSocketImpl) {
            this.localPort = port;
            this.localAddress = laddr;
        }
        this.setOption(15, laddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() {
        InetAddress addr;
        int port;
        boolean isClosed;
        DirectDatagramSocketImpl directDatagramSocketImpl = this;
        synchronized (directDatagramSocketImpl) {
            isClosed = this.closed;
            port = this.localPort;
            addr = this.localAddress;
            this.closed = true;
        }
        LOGGER.debug("closing port {}, address {}", (Object)port, (Object)addr);
        if (!isClosed) {
            List destinations = (List)map.get(port);
            if (destinations == null) {
                LOGGER.info("cannot close unknown port {}, address {}", (Object)port, (Object)addr);
            } else if (!destinations.remove(this)) {
                LOGGER.info("cannot close unknown port {}, address {}", (Object)port, (Object)addr);
            } else if (destinations.isEmpty()) {
                map.remove(port, destinations);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void receive(DatagramPacket destPacket) throws IOException {
        boolean isClosed;
        DatagramExchange exchange;
        InetAddress addr;
        int port;
        DirectDatagramSocketImpl directDatagramSocketImpl = this;
        synchronized (directDatagramSocketImpl) {
            port = this.localPort;
            addr = this.localAddress;
        }
        int timeout = this.getSoTimeout();
        Setup currentSetup = setup.get();
        try {
            if (0 < timeout) {
                exchange = this.incomingQueue.poll(timeout, TimeUnit.MILLISECONDS);
                if (null == exchange) {
                    throw new SocketTimeoutException("no data available for port " + port);
                }
            } else {
                exchange = this.incomingQueue.take();
            }
            if (0 < currentSetup.delayInMs) {
                Thread.sleep(currentSetup.delayInMs);
            }
        }
        catch (InterruptedException exception) {
            if (!this.incomingQueue.isEmpty()) {
                LOGGER.warn("interrupted while receiving!");
            }
            throw new InterruptedIOException(addr + ":" + port);
        }
        DirectDatagramSocketImpl directDatagramSocketImpl2 = this;
        synchronized (directDatagramSocketImpl2) {
            isClosed = this.closed;
        }
        if (isClosed) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("socket already closed {}", (Object)exchange.format(currentSetup));
            }
            throw new SocketException("Socket " + addr + ":" + port + " already closed!");
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("incoming {}", (Object)exchange.format(currentSetup));
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">> {}", (Object)exchange.format(currentSetup));
        } else if (LOGGER.isInfoEnabled() && enableLoggingBuffer.get()) {
            String line = exchange.format(currentSetup);
            long time = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - loggingBufferStartTimeNanos.get());
            logBuffer.offer(String.format("%04d: %s", time, line));
        }
        int receivedLength = exchange.data.length;
        int destPacketLength = destPacket.getLength();
        byte[] destPacketData = destPacket.getData();
        if (destPacketLength < receivedLength) {
            if (destPacketData.length > destPacketLength) {
                LOGGER.debug("increasing receive buffer from {} to full buffer capacity [{}]", (Object)destPacketLength, (Object)destPacketData.length);
                destPacketLength = destPacketData.length;
            }
            if (destPacketLength < receivedLength) {
                LOGGER.debug("truncating data [length: {}] to fit into receive buffer [size: {}]", (Object)receivedLength, (Object)destPacketLength);
                receivedLength = destPacketLength;
            }
        }
        destPacket.setLength(receivedLength);
        System.arraycopy(exchange.data, 0, destPacketData, 0, receivedLength);
        destPacket.setPort(exchange.sourcePort);
        destPacket.setAddress(exchange.sourceAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void send(DatagramPacket packet) throws IOException {
        InetAddress local;
        int port;
        boolean isClosed;
        DirectDatagramSocketImpl directDatagramSocketImpl = this;
        synchronized (directDatagramSocketImpl) {
            isClosed = this.closed;
            port = this.localPort;
            local = this.localAddress;
        }
        InetAddress destinationAddress = packet.getAddress();
        if (local.isAnyLocalAddress()) {
            local = destinationAddress.isMulticastAddress() ? InetAddress.getLocalHost() : destinationAddress;
        }
        Setup currentSetup = setup.get();
        DatagramExchange exchange = new DatagramExchange(local, port, packet);
        if (isClosed) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("closed/packet dropped! {}", (Object)exchange.format(currentSetup));
            }
            throw new SocketException("socket is closed");
        }
        ArrayList destinations = (ArrayList)map.get(exchange.destinationPort);
        if (null == destinations) {
            String message = String.format("destination port %s not available!", exchange.destinationPort);
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("{} {}", (Object)message, (Object)exchange.format(currentSetup));
            }
            throw new PortUnreachableException(message);
        }
        if ((destinations = new ArrayList(destinations)).isEmpty()) {
            String message = String.format("destination port %s not longer available!", exchange.destinationPort);
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("{} {}", (Object)message, (Object)exchange.format(currentSetup));
            }
            throw new PortUnreachableException(message);
        }
        for (DirectDatagramSocketImpl destinationSocket : destinations) {
            if (!destinationSocket.matches(destinationAddress) || destinationSocket.incomingQueue.offer(exchange)) continue;
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("packet dropped! {}", (Object)exchange.format(currentSetup));
            }
            throw new PortUnreachableException("buffer exhausted");
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("outgoing {}", (Object)exchange.format(currentSetup));
        }
    }

    @Override
    protected int peekData(DatagramPacket p) throws IOException {
        throw new IOException("peekData(DatagramPacket) not supported!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void join(InetAddress inetaddr) throws IOException {
        Set<InetAddress> set = this.multicast;
        synchronized (set) {
            this.multicast.add(inetaddr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void leave(InetAddress inetaddr) throws IOException {
        Set<InetAddress> set = this.multicast;
        synchronized (set) {
            this.multicast.remove(inetaddr);
        }
    }

    private int bind(int lport) throws SocketException {
        ArrayList<DirectDatagramSocketImpl> newDestinations = new ArrayList<DirectDatagramSocketImpl>();
        newDestinations.add(this);
        if (0 >= lport) {
            int count = 57344;
            int port = 8192 + nextPort.getAndIncrement() % 57344;
            while (null != map.putIfAbsent(port, newDestinations)) {
                port = 8192 + nextPort.getAndIncrement() % 57344;
                if (0 < --count) continue;
                throw new SocketException("No left free port!");
            }
            LOGGER.debug("assigned port {}", (Object)port);
            return port;
        }
        List destinations = map.putIfAbsent(lport, newDestinations);
        if (null != destinations) {
            boolean reuse = this.getReuseAddress();
            if (reuse) {
                for (DirectDatagramSocketImpl destination : destinations) {
                    if (destination.getReuseAddress()) continue;
                    reuse = false;
                    break;
                }
            }
            if (reuse) {
                destinations.add(this);
                map.putIfAbsent(lport, destinations);
            } else {
                throw new SocketException("Port " + lport + " already used!");
            }
        }
        return lport;
    }

    private int getSoTimeout() throws SocketException {
        Object option = this.getOption(4102);
        if (option instanceof Integer) {
            return (Integer)option;
        }
        return 0;
    }

    private boolean getReuseAddress() throws SocketException {
        Object option = this.getOption(4);
        if (option instanceof Boolean) {
            return (Boolean)option;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matches(InetAddress destination) {
        if (destination.isMulticastAddress()) {
            Set<InetAddress> set = this.multicast;
            synchronized (set) {
                return this.multicast.contains(destination);
            }
        }
        return true;
    }

    public static boolean initialize(DatagramSocketImplFactory factory) {
        StackTraceElement[] stack;
        boolean calledFromTest = false;
        for (StackTraceElement call : stack = Thread.currentThread().getStackTrace()) {
            if (!call.getClassName().startsWith("junit.") && !call.getClassName().startsWith("org.junit.")) continue;
            calledFromTest = true;
            break;
        }
        if (!calledFromTest) {
            throw new IllegalAccessError("The DirectDatagramSocketImpl is intended to be used for tests only!");
        }
        if (null == factory) {
            factory = DEFAULT;
        }
        if (init.compareAndSet(null, factory)) {
            try {
                DatagramSocket.setDatagramSocketImplFactory(factory);
                return true;
            }
            catch (IOException ex) {
                LOGGER.error("DatagramSocketImplFactory", ex);
            }
        } else if (factory != init.get()) {
            LOGGER.warn("DatagramSocketImplFactory already set to {}", (Object)init.get().getClass());
        }
        return false;
    }

    public static void configure(DatagramFormatter formatter, int delayInMs) {
        setup.set(new Setup(formatter, delayInMs));
    }

    public static boolean isEnabled() {
        return null != init.get();
    }

    public static boolean isEmpty() {
        return map.isEmpty();
    }

    public static void clearAll() {
        map.clear();
    }

    public static void clearBufferLogging() {
        loggingBufferStartTimeNanos.set(System.nanoTime());
        logBuffer.clear();
        enableLoggingBuffer.set(true);
    }

    public static void flushBufferLogging() {
        String message;
        enableLoggingBuffer.set(false);
        int counter = 0;
        while ((message = logBuffer.poll()) != null) {
            LOGGER.info(String.format("--%02d--> %s", ++counter, message));
        }
    }

    public static class DirectDatagramSocketImplFactory
    implements DatagramSocketImplFactory {
        @Override
        public DatagramSocketImpl createDatagramSocketImpl() {
            return new DirectDatagramSocketImpl();
        }
    }

    private static class Setup {
        public final DatagramFormatter formatter;
        public final int delayInMs;

        public Setup(DatagramFormatter formatter, int delayInMs) {
            this.formatter = formatter;
            this.delayInMs = delayInMs;
        }
    }

    private static class DatagramExchange {
        private static final AtomicInteger ID = new AtomicInteger();
        public final InetAddress sourceAddress;
        public final InetAddress destinationAddress;
        public final int sourcePort;
        public final int destinationPort;
        public final int id;
        public final byte[] data;

        public DatagramExchange(InetAddress address, int port, DatagramPacket packet) {
            this.sourceAddress = address;
            this.destinationAddress = packet.getAddress();
            this.sourcePort = port;
            this.destinationPort = packet.getPort();
            this.id = ID.incrementAndGet();
            this.data = new byte[packet.getLength()];
            System.arraycopy(packet.getData(), packet.getOffset(), this.data, 0, packet.getLength());
        }

        public String format(Setup currentSetup) {
            long tid = Thread.currentThread().getId();
            String delay = "";
            String content = "";
            String destination = "";
            if (null != currentSetup) {
                if (null != currentSetup.formatter) {
                    content = currentSetup.formatter.format(this.data);
                }
                if (0 < currentSetup.delayInMs) {
                    delay = String.format("%dms", currentSetup.delayInMs);
                }
            }
            if (!this.sourceAddress.equals(this.destinationAddress)) {
                destination = this.destinationAddress.getHostAddress();
            }
            return MessageFormat.format("(E{0},T{1}) {2}:{3} ={4}=> {5}:{6} [{7}]", this.id, tid, this.sourceAddress.getHostAddress(), this.sourcePort, delay, destination, this.destinationPort, content);
        }
    }
}

