/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.tcp;

import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.eclipse.californium.elements.tcp.TcpServerConnector;
import org.eclipse.californium.elements.tcp.TlsContextUtil;

public class TlsServerConnector
extends TcpServerConnector {
    private static final int DEFAULT_HANDSHAKE_TIMEOUT_MILLIS = 10000;
    private final ClientAuthMode clientAuthMode;
    private final SSLContext sslContext;
    private final long handshakeTimeoutMillis;

    public TlsServerConnector(SSLContext sslContext, ClientAuthMode clientAuthMode, InetSocketAddress socketAddress, int numberOfThreads, int handshakeTimeoutMillis, int idleTimeout) {
        super(socketAddress, numberOfThreads, idleTimeout, new TlsContextUtil(clientAuthMode == ClientAuthMode.NEEDED));
        this.sslContext = sslContext;
        this.clientAuthMode = clientAuthMode;
        this.handshakeTimeoutMillis = handshakeTimeoutMillis;
    }

    public TlsServerConnector(SSLContext sslContext, ClientAuthMode clientAuthMode, InetSocketAddress socketAddress, int numberOfThreads, int idleTimeout) {
        this(sslContext, clientAuthMode, socketAddress, numberOfThreads, 10000, idleTimeout);
    }

    public TlsServerConnector(SSLContext sslContext, InetSocketAddress socketAddress, int numberOfThreads, int idleTimeout) {
        this(sslContext, ClientAuthMode.NONE, socketAddress, numberOfThreads, 10000, idleTimeout);
    }

    @Override
    protected void onNewChannelCreated(Channel ch) {
        SSLEngine sslEngine = this.createSllEngineForChannel(ch);
        switch (this.clientAuthMode) {
            case NONE: {
                break;
            }
            case WANTED: {
                sslEngine.setWantClientAuth(true);
                break;
            }
            case NEEDED: {
                sslEngine.setNeedClientAuth(true);
            }
        }
        sslEngine.setUseClientMode(false);
        SslHandler sslHandler = new SslHandler(sslEngine);
        sslHandler.setHandshakeTimeoutMillis(this.handshakeTimeoutMillis);
        ch.pipeline().addFirst(sslHandler);
    }

    @Override
    public String getProtocol() {
        return "TLS";
    }

    private SSLEngine createSllEngineForChannel(Channel ch) {
        SocketAddress remoteAddress = ch.remoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress remote = (InetSocketAddress)remoteAddress;
            this.LOGGER.info("Connection from inet {}", (Object)remote);
            return this.sslContext.createSSLEngine(remote.getAddress().getHostAddress(), remote.getPort());
        }
        this.LOGGER.info("Connection from {}", (Object)remoteAddress);
        return this.sslContext.createSSLEngine();
    }

    public static enum ClientAuthMode {
        NONE,
        WANTED,
        NEEDED;

    }
}

