/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.assume;

import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.util.StringUtil;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.junit.AssumptionViolatedException;

public class TimeAssume {
    private boolean enabled = Boolean.getBoolean(TimeAssume.class.getName() + ".enable");
    private long end;

    public TimeAssume() {
    }

    public TimeAssume(long timeout) {
        this();
        if (timeout <= 0L) {
            throw new IllegalArgumentException("timeout must be larger than 0!");
        }
        if (this.enabled) {
            this.end = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeout);
        }
    }

    public void sleep(long milliseconds) {
        this.sleep(milliseconds, milliseconds / 10L);
    }

    public void sleep(long milliseconds, long timeout) {
        if (milliseconds <= 0L) {
            throw new IllegalArgumentException("sleep milliseconds must be larger than 0!");
        }
        if (timeout <= 0L) {
            throw new IllegalArgumentException("timeout must be larger than 0!");
        }
        long start = System.nanoTime();
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long tolerance = milliseconds / 10L;
        long now = System.nanoTime();
        long time = TimeUnit.NANOSECONDS.toMillis(now - start);
        if (time < milliseconds - tolerance) {
            throw new AssumptionViolatedException("sleep too short! " + time + " instead of " + milliseconds + " ms");
        }
        if (milliseconds + timeout < time) {
            throw new AssumptionViolatedException("sleep too long! " + time + " instead of " + milliseconds + " ms");
        }
        this.end = start + TimeUnit.MILLISECONDS.toNanos(milliseconds + timeout);
    }

    public boolean inTime() {
        return !this.enabled || 0L == this.end || System.nanoTime() <= this.end;
    }

    public <T> Matcher<T> inTime(final Matcher<T> matcher) {
        return new BaseMatcher<T>(){

            public void describeTo(Description description) {
                matcher.describeTo(description);
            }

            public boolean matches(Object item) {
                boolean result = matcher.matches(item);
                if (!result && !TimeAssume.this.inTime()) {
                    StringDescription description = new StringDescription();
                    description.appendText("expected: ");
                    matcher.describeTo((Description)description);
                    description.appendText(StringUtil.lineSeparator());
                    description.appendText("actual: ");
                    this.describeMismatch(item, (Description)description);
                    description.appendText(", assumed time expired!");
                    throw new AssumptionViolatedException(description.toString());
                }
                return result;
            }

            public void describeMismatch(Object item, Description mismatchDescription) {
                long left;
                matcher.describeMismatch(item, mismatchDescription);
                if (!TimeAssume.this.enabled && 0L < TimeAssume.this.end && (left = TimeAssume.this.end - System.nanoTime()) < 0L) {
                    mismatchDescription.appendText(", assumed time expired! ");
                    mismatchDescription.appendText(Long.toString(TimeUnit.NANOSECONDS.toMillis(-left)));
                    mismatchDescription.appendText("ms");
                }
            }
        };
    }
}

