/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.serialization;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.network.serialization.DataParser;
import org.eclipse.californium.core.network.serialization.MessageHeader;
import org.eclipse.californium.elements.util.DatagramReader;

public final class TcpDataParser
extends DataParser {
    @Override
    protected MessageHeader parseHeader(DatagramReader reader) {
        int len = reader.read(4);
        int tokenLength = reader.read(4);
        int lengthSize = 0;
        TcpDataParser.assertValidTokenLength(tokenLength);
        if (len == 13) {
            lengthSize = 1;
        } else if (len == 14) {
            lengthSize = 2;
        } else if (len == 15) {
            lengthSize = 4;
        }
        reader.readBytes(lengthSize);
        int code = reader.read(8);
        Token token = Token.fromProvider(reader.readBytes(tokenLength));
        return new MessageHeader(1, CoAP.Type.CON, token, code, -1, 0);
    }
}

