/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AbstractMessage;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSConnectionState;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.FragmentedHandshakeMessage;
import org.eclipse.californium.scandium.dtls.GenericHandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeParameter;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.ReassemblingHandshakeMessage;
import org.eclipse.californium.scandium.dtls.Record;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.SessionListener;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.ECDHECryptography;
import org.eclipse.californium.scandium.dtls.cipher.PseudoRandomFunction;
import org.eclipse.californium.scandium.dtls.rpkstore.TrustedRpkStore;
import org.eclipse.californium.scandium.dtls.x509.CertificateVerifier;
import org.eclipse.californium.scandium.util.ByteArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Handshaker {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass().getName());
    protected final boolean isClient;
    protected int state = -1;
    protected ProtocolVersion usedProtocol;
    protected Random clientRandom;
    protected Random serverRandom;
    protected ECDHECryptography ecdhe;
    private SecretKey clientWriteMACKey;
    private SecretKey serverWriteMACKey;
    private IvParameterSpec clientWriteIV;
    private IvParameterSpec serverWriteIV;
    private SecretKey clientWriteKey;
    private SecretKey serverWriteKey;
    protected final DTLSSession session;
    protected final CertificateVerifier certificateVerifier;
    protected final TrustedRpkStore rpkStore;
    protected final ConnectionIdGenerator connectionIdGenerator;
    private int sequenceNumber = 0;
    private int nextReceiveSeq = 0;
    protected int flightNumber = 0;
    private final int maxFragmentedHandshakeMessageLength;
    private final int maxDeferredProcessedApplicationDataMessages;
    private final List<RawData> deferredApplicationData;
    private final List<Record> deferredRecords;
    private final AtomicReference<DTLSFlight> pendingFlight = new AtomicReference();
    private final RecordLayer recordLayer;
    private final Connection connection;
    protected InboundMessageBuffer inboundMessageBuffer;
    protected Map<Integer, ReassemblingHandshakeMessage> reassembledMessages = new HashMap<Integer, ReassemblingHandshakeMessage>();
    protected MessageDigest md;
    protected byte[] handshakeMessages = Bytes.EMPTY;
    protected PrivateKey privateKey;
    protected PublicKey publicKey;
    protected List<X509Certificate> certificateChain;
    protected boolean sniEnabled = true;
    private final Set<SessionListener> sessionListeners = new LinkedHashSet<SessionListener>();
    private boolean changeCipherSuiteMessageExpected = false;
    private boolean sessionEstablished = false;
    private boolean handshakeFailed = false;
    private Throwable cause;

    protected Handshaker(boolean isClient, int initialMessageSeq, DTLSSession session, RecordLayer recordLayer, Connection connection, DtlsConnectorConfig config, int maxTransmissionUnit) {
        if (session == null) {
            throw new NullPointerException("DTLS Session must not be null");
        }
        if (recordLayer == null) {
            throw new NullPointerException("Record layer must not be null");
        }
        if (config == null) {
            throw new NullPointerException("Dtls Connector Config must not be null");
        }
        if (initialMessageSeq < 0) {
            throw new IllegalArgumentException("Initial message sequence number must not be negative");
        }
        this.isClient = isClient;
        this.sequenceNumber = initialMessageSeq;
        this.nextReceiveSeq = initialMessageSeq;
        this.session = session;
        this.recordLayer = recordLayer;
        this.connection = connection;
        this.connectionIdGenerator = config.getConnectionIdGenerator();
        this.maxFragmentedHandshakeMessageLength = config.getMaxFragmentedHandshakeMessageLength();
        this.maxDeferredProcessedApplicationDataMessages = config.getMaxDeferredProcessedApplicationDataMessages();
        this.deferredApplicationData = new ArrayList<RawData>(this.maxDeferredProcessedApplicationDataMessages);
        this.deferredRecords = new ArrayList<Record>(this.maxDeferredProcessedApplicationDataMessages);
        if (connection != null) {
            this.addSessionListener(connection.getSessionListener());
        }
        this.certificateVerifier = config.getCertificateVerifier();
        this.session.setMaxTransmissionUnit(maxTransmissionUnit);
        this.inboundMessageBuffer = new InboundMessageBuffer();
        this.rpkStore = config.getRpkTrustStore();
    }

    public final void processMessage(Record record) throws HandshakeException {
        boolean sameEpoch;
        boolean bl = sameEpoch = this.session.getReadEpoch() == record.getEpoch();
        if (sameEpoch && !this.session.isDuplicate(record.getSequenceNumber()) || this.session.getReadEpoch() + 1 == record.getEpoch()) {
            try {
                record.setSession(this.session);
                DTLSMessage messageToProcess = this.inboundMessageBuffer.getNextMessage(record);
                while (messageToProcess != null) {
                    if (messageToProcess instanceof FragmentedHandshakeMessage) {
                        messageToProcess = this.handleFragmentation((FragmentedHandshakeMessage)messageToProcess);
                    }
                    if (messageToProcess != null) {
                        DTLSFlight flight;
                        if (messageToProcess instanceof GenericHandshakeMessage) {
                            HandshakeParameter parameter = this.session.getParameter();
                            if (parameter == null) {
                                throw new IllegalStateException("handshake parameter are required!");
                            }
                            messageToProcess = ((GenericHandshakeMessage)messageToProcess).getSpecificHandshakeMessage(parameter);
                        }
                        if (messageToProcess.getContentType() == ContentType.HANDSHAKE && (flight = this.pendingFlight.get()) != null) {
                            this.LOGGER.debug("response for flight {} started", (Object)flight.getFlightNumber());
                            flight.setResponseStarted();
                        }
                        this.doProcessMessage(messageToProcess);
                    }
                    messageToProcess = this.inboundMessageBuffer.getNextMessage();
                }
                this.session.markRecordAsRead(record.getEpoch(), record.getSequenceNumber());
            }
            catch (GeneralSecurityException e) {
                this.LOGGER.warn("Cannot process handshake message from peer [{}] due to [{}]", this.getSession().getPeer(), e.getMessage(), e);
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.session.getPeer());
                throw new HandshakeException("Cannot process handshake message", alert);
            }
        } else if (sameEpoch) {
            this.LOGGER.trace("Discarding duplicate HANDSHAKE message received from peer [{}]:{}{}", record.getPeerAddress(), StringUtil.lineSeparator(), record);
        } else {
            this.LOGGER.trace("Discarding HANDSHAKE message with wrong epoch received from peer [{}]:{}{}", record.getPeerAddress(), StringUtil.lineSeparator(), record);
        }
    }

    protected abstract void doProcessMessage(DTLSMessage var1) throws HandshakeException, GeneralSecurityException;

    public abstract void startHandshake() throws HandshakeException;

    protected final void initMessageDigest() {
        String hashName = this.session.getCipherSuite().getPseudoRandomFunctionHashName();
        try {
            this.md = MessageDigest.getInstance(hashName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(String.format("Message digest algorithm %s is not available on JVM", hashName));
        }
    }

    protected final void generateKeys(byte[] premasterSecret) {
        byte[] masterSecret = this.generateMasterSecret(premasterSecret);
        this.session.setMasterSecret(masterSecret);
        this.calculateKeys(masterSecret);
    }

    protected void calculateKeys(byte[] masterSecret) {
        String prfMacName = this.session.getCipherSuite().getPseudoRandomFunctionMacName();
        int macKeyLength = this.session.getCipherSuite().getMacKeyLength();
        int encKeyLength = this.session.getCipherSuite().getEncKeyLength();
        int fixedIvLength = this.session.getCipherSuite().getFixedIvLength();
        int totalLength = (macKeyLength + encKeyLength + fixedIvLength) * 2;
        byte[] seed = ByteArrayUtils.concatenate(this.serverRandom.getBytes(), this.clientRandom.getBytes());
        byte[] data = PseudoRandomFunction.doPRF(prfMacName, masterSecret, PseudoRandomFunction.Label.KEY_EXPANSION_LABEL, seed, totalLength);
        int index = 0;
        int length = macKeyLength;
        this.clientWriteMACKey = new SecretKeySpec(data, index, length, "Mac");
        this.serverWriteMACKey = new SecretKeySpec(data, index += length, length, "Mac");
        index += length;
        length = encKeyLength;
        this.clientWriteKey = new SecretKeySpec(data, index, length, "AES");
        this.serverWriteKey = new SecretKeySpec(data, index += length, length, "AES");
        index += length;
        length = fixedIvLength;
        this.clientWriteIV = new IvParameterSpec(data, index, length);
        this.serverWriteIV = new IvParameterSpec(data, index += length, length);
    }

    private byte[] generateMasterSecret(byte[] premasterSecret) {
        String prfMacName = this.session.getCipherSuite().getPseudoRandomFunctionMacName();
        byte[] randomSeed = ByteArrayUtils.concatenate(this.clientRandom.getBytes(), this.serverRandom.getBytes());
        return PseudoRandomFunction.doPRF(prfMacName, premasterSecret, PseudoRandomFunction.Label.MASTER_SECRET_LABEL, randomSeed);
    }

    protected final byte[] generatePremasterSecretFromPSK(byte[] psk, byte[] otherSecret) {
        int pskLength = psk.length;
        byte[] other = otherSecret == null ? new byte[pskLength] : otherSecret;
        DatagramWriter writer = new DatagramWriter();
        writer.write(other.length, 16);
        writer.writeBytes(other);
        writer.write(pskLength, 16);
        writer.writeBytes(psk);
        return writer.toByteArray();
    }

    protected final void setCurrentReadState() {
        DTLSConnectionState connectionState = this.isClient ? new DTLSConnectionState(this.session.getCipherSuite(), this.session.getCompressionMethod(), this.serverWriteKey, this.serverWriteIV, this.serverWriteMACKey) : new DTLSConnectionState(this.session.getCipherSuite(), this.session.getCompressionMethod(), this.clientWriteKey, this.clientWriteIV, this.clientWriteMACKey);
        this.session.setReadState(connectionState);
    }

    protected final void setCurrentWriteState() {
        DTLSConnectionState connectionState = this.isClient ? new DTLSConnectionState(this.session.getCipherSuite(), this.session.getCompressionMethod(), this.clientWriteKey, this.clientWriteIV, this.clientWriteMACKey) : new DTLSConnectionState(this.session.getCipherSuite(), this.session.getCompressionMethod(), this.serverWriteKey, this.serverWriteIV, this.serverWriteMACKey);
        this.session.setWriteState(connectionState);
    }

    protected final void wrapMessage(DTLSFlight flight, DTLSMessage fragment) throws HandshakeException {
        try {
            switch (fragment.getContentType()) {
                case HANDSHAKE: {
                    this.wrapHandshakeMessage(flight, (HandshakeMessage)fragment);
                    break;
                }
                case CHANGE_CIPHER_SPEC: {
                    flight.addMessage(new Record(fragment.getContentType(), this.session.getWriteEpoch(), this.session.getSequenceNumber(), fragment, this.session, false, 0));
                    break;
                }
                default: {
                    throw new HandshakeException("Cannot create " + (Object)((Object)fragment.getContentType()) + " record for flight", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.session.getPeer()));
                }
            }
        }
        catch (GeneralSecurityException e) {
            throw new HandshakeException("Cannot create record", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.session.getPeer()));
        }
    }

    private void wrapHandshakeMessage(DTLSFlight flight, HandshakeMessage handshakeMessage) throws GeneralSecurityException {
        int fragmentLength;
        this.setSequenceNumber(handshakeMessage);
        int messageLength = handshakeMessage.getMessageLength();
        int maxFragmentLength = this.session.getMaxFragmentLength();
        if (messageLength <= maxFragmentLength) {
            boolean useCid = handshakeMessage.getMessageType() == HandshakeType.FINISHED;
            flight.addMessage(new Record(ContentType.HANDSHAKE, this.session.getWriteEpoch(), this.session.getSequenceNumber(), handshakeMessage, this.session, useCid, 0));
            return;
        }
        this.LOGGER.debug("Splitting up {} message for [{}] into multiple fragments of max {} bytes", new Object[]{handshakeMessage.getMessageType(), handshakeMessage.getPeer(), maxFragmentLength});
        byte[] messageBytes = handshakeMessage.fragmentToByteArray();
        if (messageBytes.length != messageLength) {
            throw new IllegalStateException("message length " + messageLength + " differs from message " + messageBytes.length + "!");
        }
        int messageSeq = handshakeMessage.getMessageSeq();
        for (int offset = 0; offset < messageLength; offset += fragmentLength) {
            fragmentLength = maxFragmentLength;
            if (offset + fragmentLength > messageLength) {
                fragmentLength = messageLength - offset;
            }
            byte[] fragmentBytes = new byte[fragmentLength];
            System.arraycopy(messageBytes, offset, fragmentBytes, 0, fragmentLength);
            FragmentedHandshakeMessage fragmentedMessage = new FragmentedHandshakeMessage(handshakeMessage.getMessageType(), messageLength, messageSeq, offset, fragmentBytes, this.session.getPeer());
            flight.addMessage(new Record(ContentType.HANDSHAKE, this.session.getWriteEpoch(), this.session.getSequenceNumber(), fragmentedMessage, this.session, false, 0));
        }
    }

    protected final HandshakeMessage handleFragmentation(FragmentedHandshakeMessage fragment) throws HandshakeException {
        this.LOGGER.debug("Processing {} message fragment ...", (Object)fragment.getMessageType());
        if (fragment.getMessageLength() > this.maxFragmentedHandshakeMessageLength) {
            throw new HandshakeException("Fragmented message length exceeded (" + fragment.getMessageLength() + " > " + this.maxFragmentedHandshakeMessageLength + ")!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, fragment.getPeer()));
        }
        int messageSeq = fragment.getMessageSeq();
        ReassemblingHandshakeMessage reassembledMessage = this.reassembledMessages.get(messageSeq);
        try {
            if (reassembledMessage == null) {
                reassembledMessage = new ReassemblingHandshakeMessage(fragment);
                this.reassembledMessages.put(messageSeq, reassembledMessage);
            } else {
                reassembledMessage.add(fragment);
            }
            if (reassembledMessage.isComplete()) {
                HandshakeMessage message = HandshakeMessage.fromByteArray(reassembledMessage.toByteArray(), this.session.getParameter(), reassembledMessage.getPeer());
                this.LOGGER.debug("Successfully re-assembled {} message", (Object)message.getMessageType());
                this.reassembledMessages.remove(messageSeq);
                return message;
            }
        }
        catch (IllegalArgumentException ex) {
            throw new HandshakeException(ex.getMessage(), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, fragment.getPeer()));
        }
        return null;
    }

    protected final CipherSuite.KeyExchangeAlgorithm getKeyExchangeAlgorithm() {
        return this.session.getKeyExchange();
    }

    final SecretKey getClientWriteMACKey() {
        return this.clientWriteMACKey;
    }

    final SecretKey getServerWriteMACKey() {
        return this.serverWriteMACKey;
    }

    final IvParameterSpec getClientWriteIV() {
        return this.clientWriteIV;
    }

    final IvParameterSpec getServerWriteIV() {
        return this.serverWriteIV;
    }

    final SecretKey getClientWriteKey() {
        return this.clientWriteKey;
    }

    final SecretKey getServerWriteKey() {
        return this.serverWriteKey;
    }

    public final DTLSSession getSession() {
        return this.session;
    }

    public final InetSocketAddress getPeerAddress() {
        return this.session.getPeer();
    }

    public final Connection getConnection() {
        return this.connection;
    }

    public Random getClientRandom() {
        return this.clientRandom;
    }

    public Random getServerRandom() {
        return this.serverRandom;
    }

    private void setSequenceNumber(HandshakeMessage message) {
        message.setMessageSeq(this.sequenceNumber);
        ++this.sequenceNumber;
    }

    final int getNextReceiveSeq() {
        return this.nextReceiveSeq;
    }

    final void incrementNextReceiveSeq() {
        ++this.nextReceiveSeq;
    }

    public void addApplicationDataForDeferredProcessing(RawData outgoingMessage) {
        int max;
        int n = max = this.maxDeferredProcessedApplicationDataMessages == 0 ? 1 : this.maxDeferredProcessedApplicationDataMessages;
        if (this.deferredApplicationData.size() < max) {
            this.deferredApplicationData.add(outgoingMessage);
        }
    }

    public void addRecordsForDeferredProcessing(Record incomingMessage) {
        if (this.deferredRecords.size() < this.maxDeferredProcessedApplicationDataMessages) {
            this.deferredRecords.add(incomingMessage);
        }
    }

    public List<RawData> takeDeferredApplicationData() {
        ArrayList<RawData> applicationData = new ArrayList<RawData>(this.deferredApplicationData);
        this.deferredApplicationData.clear();
        return applicationData;
    }

    public List<Record> takeDeferredRecords() {
        ArrayList<Record> records = new ArrayList<Record>(this.deferredRecords);
        this.deferredRecords.clear();
        return records;
    }

    public void takeDeferredApplicationData(Handshaker replacedHandshaker) {
        this.deferredApplicationData.addAll(replacedHandshaker.takeDeferredApplicationData());
    }

    public void setPendingFlight(DTLSFlight pendingFlight) {
        DTLSFlight flight = this.pendingFlight.getAndSet(pendingFlight);
        if (flight != null && flight != pendingFlight) {
            flight.setResponseCompleted();
        }
    }

    public void sendFlight(DTLSFlight flight) {
        this.setPendingFlight(null);
        try {
            this.recordLayer.sendFlight(flight, this.connection);
            this.setPendingFlight(flight);
        }
        catch (IOException e) {
            this.handshakeFailed(new Exception("handshake flight " + flight.getFlightNumber() + " failed!", e));
        }
    }

    public final void addSessionListener(SessionListener listener) {
        if (listener != null) {
            this.sessionListeners.add(listener);
        }
    }

    public final void removeSessionListener(SessionListener listener) {
        if (listener != null) {
            this.sessionListeners.remove(listener);
        }
    }

    protected final void handshakeStarted() throws HandshakeException {
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.handshakeStarted(this);
        }
    }

    protected final void sessionEstablished() throws HandshakeException {
        if (!this.sessionEstablished) {
            this.sessionEstablished = true;
            for (SessionListener sessionListener : this.sessionListeners) {
                sessionListener.sessionEstablished(this, this.getSession());
            }
        }
    }

    public final void handshakeCompleted() {
        this.setPendingFlight(null);
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.handshakeCompleted(this);
        }
    }

    public final void handshakeFailed(Throwable cause) {
        if (this.cause == null) {
            this.cause = cause;
        }
        if (!this.handshakeFailed && this.cause == cause) {
            this.handshakeFailed = true;
            this.setPendingFlight(null);
            if (!this.sessionEstablished) {
                for (SessionListener sessionListener : this.sessionListeners) {
                    sessionListener.handshakeFailed(this, cause);
                }
            }
        }
    }

    public Throwable getFailureCause() {
        return this.cause;
    }

    public void setFailureCause(Throwable cause) {
        this.setPendingFlight(null);
        this.cause = cause;
    }

    public final void handshakeFlightRetransmitted(int flight) {
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.handshakeFlightRetransmitted(this, flight);
        }
        for (RawData message : this.deferredApplicationData) {
            message.onDtlsRetransmission(flight);
        }
    }

    public final boolean isChangeCipherSpecMessageExpected() {
        return this.changeCipherSuiteMessageExpected;
    }

    protected final void expectChangeCipherSpecMessage() {
        this.changeCipherSuiteMessageExpected = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void verifyCertificate(CertificateMessage message) throws HandshakeException {
        if (message.getCertificateChain() == null) {
            RawPublicKeyIdentity rpk = new RawPublicKeyIdentity(message.getPublicKey());
            if (this.rpkStore.isTrusted(rpk)) return;
            this.LOGGER.debug("Certificate validation failed: Raw public key is not trusted");
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, this.session.getPeer());
            throw new HandshakeException("Raw public key is not trusted", alert);
        }
        if (this.certificateVerifier != null) {
            this.certificateVerifier.verifyCertificate(message, this.session);
            return;
        }
        this.LOGGER.debug("Certificate validation failed: x509 could not be trusted!");
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE, this.session.getPeer());
        throw new HandshakeException("Trust is not possible!", alert);
    }

    class InboundMessageBuffer {
        private ChangeCipherSpecMessage changeCipherSpec = null;
        private SortedSet<Record> queue = new TreeSet<Record>(new Comparator<Record>(){

            @Override
            public int compare(Record r1, Record r2) {
                if (r1.getEpoch() < r2.getEpoch()) {
                    return -1;
                }
                if (r1.getEpoch() > r2.getEpoch()) {
                    return 1;
                }
                if (r1.getSequenceNumber() < r2.getSequenceNumber()) {
                    return -1;
                }
                if (r1.getSequenceNumber() > r2.getSequenceNumber()) {
                    return 1;
                }
                return 0;
            }
        });

        InboundMessageBuffer() {
        }

        boolean isEmpty() {
            return this.queue.isEmpty();
        }

        DTLSMessage getNextMessage() throws GeneralSecurityException, HandshakeException {
            AbstractMessage result = null;
            if (Handshaker.this.isChangeCipherSpecMessageExpected() && this.changeCipherSpec != null) {
                result = this.changeCipherSpec;
                this.changeCipherSpec = null;
            } else {
                for (Record record : this.queue) {
                    HandshakeMessage msg;
                    if (record.getEpoch() != Handshaker.this.session.getReadEpoch() || (msg = (HandshakeMessage)record.getFragment(Handshaker.this.session.getReadState())).getMessageSeq() != Handshaker.this.nextReceiveSeq) continue;
                    result = msg;
                    this.queue.remove(record);
                    break;
                }
            }
            return result;
        }

        DTLSMessage getNextMessage(Record candidate) throws GeneralSecurityException, HandshakeException {
            int epoch = candidate.getEpoch();
            if (epoch < Handshaker.this.session.getReadEpoch()) {
                Handshaker.this.LOGGER.debug("Discarding message from peer [{}] from past epoch [{}] < current epoch [{}]", Handshaker.this.getPeerAddress(), epoch, Handshaker.this.session.getReadEpoch());
                return null;
            }
            if (epoch == Handshaker.this.session.getReadEpoch()) {
                DTLSMessage fragment = candidate.getFragment();
                switch (fragment.getContentType()) {
                    case ALERT: {
                        return fragment;
                    }
                    case CHANGE_CIPHER_SPEC: {
                        if (Handshaker.this.isChangeCipherSpecMessageExpected()) {
                            return fragment;
                        }
                        Handshaker.this.LOGGER.debug("Change Cipher Spec is not expected and therefore kept for later processing!");
                        this.changeCipherSpec = (ChangeCipherSpecMessage)fragment;
                        return null;
                    }
                    case HANDSHAKE: {
                        HandshakeMessage handshakeMessage = (HandshakeMessage)fragment;
                        int messageSeq = handshakeMessage.getMessageSeq();
                        if (messageSeq == Handshaker.this.nextReceiveSeq) {
                            return handshakeMessage;
                        }
                        if (messageSeq > Handshaker.this.nextReceiveSeq) {
                            Handshaker.this.LOGGER.debug("Queued newer message from current epoch, message_seq [{}] > next_receive_seq [{}]", (Object)messageSeq, (Object)Handshaker.this.nextReceiveSeq);
                            this.queue.add(candidate);
                            return null;
                        }
                        Handshaker.this.LOGGER.debug("Discarding old message, message_seq [{}] < next_receive_seq [{}]", (Object)messageSeq, (Object)Handshaker.this.nextReceiveSeq);
                        return null;
                    }
                }
                Handshaker.this.LOGGER.debug("Cannot process message of type [{}], discarding...", (Object)fragment.getContentType());
                return null;
            }
            this.queue.add(candidate);
            Handshaker.this.LOGGER.debug("Queueing HANDSHAKE message from future epoch [{}] > current epoch [{}]", (Object)epoch, (Object)Handshaker.this.getSession().getReadEpoch());
            return null;
        }
    }
}

