/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetAddress;
import java.net.InetSocketAddress;

public class RawData {
    public final byte[] bytes;
    private InetAddress address;
    private int port;
    private boolean multicast;

    public RawData(byte[] bytes) {
        this(bytes, null, 0);
    }

    public RawData(byte[] bytes, InetAddress address, int port) {
        if (bytes == null) {
            throw new NullPointerException();
        }
        this.bytes = bytes;
        this.address = address;
        this.port = port;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getSize() {
        return this.bytes.length;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isMulticast() {
        return this.multicast;
    }

    public void setMulticast(boolean multicast) {
        this.multicast = multicast;
    }

    public InetSocketAddress getInetSocketAddress() {
        return new InetSocketAddress(this.address, this.port);
    }
}

