/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.serialization;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.serialization.DatagramReader;

public class DataParser {
    private DatagramReader reader;
    private int version;
    private int type;
    private int tokenlength;
    private int code;
    private int mid;

    public DataParser(byte[] bytes) {
        this.setBytes(bytes);
    }

    public void setBytes(byte[] bytes) {
        this.reader = new DatagramReader(bytes);
        this.version = this.reader.read(2);
        this.type = this.reader.read(2);
        this.tokenlength = this.reader.read(4);
        this.code = this.reader.read(8);
        this.mid = this.reader.read(16);
    }

    public boolean isWellFormed() {
        return this.version == 1;
    }

    public int getVersion() {
        return this.version;
    }

    public int getMID() {
        return this.mid;
    }

    public boolean isReply() {
        return this.type > CoAP.Type.NON.value;
    }

    public boolean isRequest() {
        return this.code >= 1 && this.code <= 31;
    }

    public boolean isResponse() {
        return this.code >= 64 && this.code <= 191;
    }

    public boolean isEmpty() {
        return this.code == 0;
    }

    public Request parseRequest() {
        assert (this.isRequest());
        Request request = new Request(CoAP.Code.valueOf(this.code));
        this.parseMessage(request);
        return request;
    }

    public Response parseResponse() {
        assert (this.isResponse());
        Response response = new Response(CoAP.ResponseCode.valueOf(this.code));
        this.parseMessage(response);
        return response;
    }

    public EmptyMessage parseEmptyMessage() {
        assert (!this.isRequest() && !this.isResponse());
        EmptyMessage message = new EmptyMessage(CoAP.Type.valueOf(this.type));
        this.parseMessage(message);
        return message;
    }

    private void parseMessage(Message message) {
        message.setType(CoAP.Type.valueOf(this.type));
        message.setMID(this.mid);
        if (this.tokenlength > 0) {
            message.setToken(this.reader.readBytes(this.tokenlength));
        } else {
            message.setToken(new byte[0]);
        }
        int currentOption = 0;
        int nextByte = 0;
        while (this.reader.bytesAvailable() && (nextByte = (int)this.reader.readNextByte()) != -1) {
            int optionDeltaNibble = (0xF0 & nextByte) >> 4;
            int optionLengthNibble = 0xF & nextByte;
            int optionLength = this.readOptionValueFromNibble(optionLengthNibble);
            Option option = new Option(currentOption += this.readOptionValueFromNibble(optionDeltaNibble));
            option.setValue(this.reader.readBytes(optionLength));
            this.addOptionToSet(option, message.getOptions());
        }
        if (nextByte == -1) {
            if (!this.reader.bytesAvailable()) {
                throw new IllegalStateException();
            }
            message.setPayload(this.reader.readBytesLeft());
        } else {
            message.setPayload(new byte[0]);
        }
    }

    private void addOptionToSet(Option option, OptionSet optionSet) {
        switch (option.getNumber()) {
            case 1: {
                optionSet.addIfMatch(option.getValue());
                break;
            }
            case 3: {
                optionSet.setURIHost(option.getStringValue());
                break;
            }
            case 4: {
                optionSet.addETag(option.getValue());
                break;
            }
            case 5: {
                optionSet.setIfNoneMatch(true);
                break;
            }
            case 7: {
                optionSet.setURIPort(option.getIntegerValue());
                break;
            }
            case 8: {
                optionSet.addLocationPath(option.getStringValue());
                break;
            }
            case 11: {
                optionSet.addURIPath(option.getStringValue());
                break;
            }
            case 12: {
                optionSet.setContentFormat(option.getIntegerValue());
                break;
            }
            case 14: {
                optionSet.setMaxAge(option.getLongValue());
                break;
            }
            case 15: {
                optionSet.addURIQuery(option.getStringValue());
                break;
            }
            case 17: {
                optionSet.setAccept(option.getIntegerValue());
                break;
            }
            case 20: {
                optionSet.addLocationQuery(option.getStringValue());
                break;
            }
            case 35: {
                optionSet.setProxyURI(option.getStringValue());
                break;
            }
            case 39: {
                optionSet.setProxyScheme(option.getStringValue());
                break;
            }
            case 27: {
                optionSet.setBlock1(option.getValue());
                break;
            }
            case 23: {
                optionSet.setBlock2(option.getValue());
                break;
            }
            case 6: {
                optionSet.setObserve(option.getIntegerValue());
                break;
            }
            default: {
                optionSet.addOption(option);
            }
        }
    }

    private int readOptionValueFromNibble(int nibble) {
        if (nibble <= 12) {
            return nibble;
        }
        if (nibble == 13) {
            return this.reader.read(8) + 13;
        }
        if (nibble == 14) {
            return this.reader.read(16) + 269;
        }
        throw new IllegalArgumentException("Unsupported option delta " + nibble);
    }
}

