/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.util.Arrays;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.ExchangeObserver;
import org.eclipse.californium.core.network.stack.BlockwiseStatus;
import org.eclipse.californium.core.observe.ObserveRelation;

public class Exchange {
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger();
    private Endpoint endpoint;
    private ExchangeObserver observer;
    private boolean complete = false;
    private long timestamp;
    private Request request;
    private Request currentRequest;
    private BlockwiseStatus requestBlockStatus;
    private Response response;
    private Response currentResponse;
    private BlockwiseStatus responseBlockStatus;
    private final Origin origin;
    private boolean timedOut;
    private int currentTimeout;
    private int failedTransmissionCount = 0;
    private ScheduledFuture<?> retransmissionHandle = null;
    private ScheduledFuture<?> reregistrationHandle = null;
    private BlockOption block1ToAck;
    private ObserveRelation relation;

    public Exchange(Request request, Origin origin) {
        INSTANCE_COUNTER.incrementAndGet();
        this.currentRequest = request;
        this.origin = origin;
        this.timestamp = System.currentTimeMillis();
    }

    public void sendAccept() {
        assert (this.origin == Origin.REMOTE);
        if (this.request.getType() == CoAP.Type.CON && !this.request.isAcknowledged()) {
            this.request.setAcknowledged(true);
            EmptyMessage ack = EmptyMessage.newACK(this.request);
            this.endpoint.sendEmptyMessage(this, ack);
        }
    }

    public void sendReject() {
        assert (this.origin == Origin.REMOTE);
        this.request.setRejected(true);
        EmptyMessage rst = EmptyMessage.newRST(this.request);
        this.endpoint.sendEmptyMessage(this, rst);
    }

    public void sendResponse(Response response) {
        response.setDestination(this.request.getSource());
        response.setDestinationPort(this.request.getSourcePort());
        this.setResponse(response);
        this.endpoint.sendResponse(this, response);
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public Request getCurrentRequest() {
        return this.currentRequest;
    }

    public void setCurrentRequest(Request currentRequest) {
        this.currentRequest = currentRequest;
    }

    public BlockwiseStatus getRequestBlockStatus() {
        return this.requestBlockStatus;
    }

    public void setRequestBlockStatus(BlockwiseStatus requestBlockStatus) {
        this.requestBlockStatus = requestBlockStatus;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public Response getCurrentResponse() {
        return this.currentResponse;
    }

    public void setCurrentResponse(Response currentResponse) {
        this.currentResponse = currentResponse;
    }

    public BlockwiseStatus getResponseBlockStatus() {
        return this.responseBlockStatus;
    }

    public void setResponseBlockStatus(BlockwiseStatus responseBlockStatus) {
        this.responseBlockStatus = responseBlockStatus;
    }

    public BlockOption getBlock1ToAck() {
        return this.block1ToAck;
    }

    public void setBlock1ToAck(BlockOption block1ToAck) {
        this.block1ToAck = block1ToAck;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void setTimedOut() {
        this.timedOut = true;
        this.setComplete();
    }

    public int getFailedTransmissionCount() {
        return this.failedTransmissionCount;
    }

    public void setFailedTransmissionCount(int failedTransmissionCount) {
        this.failedTransmissionCount = failedTransmissionCount;
    }

    public int getCurrentTimeout() {
        return this.currentTimeout;
    }

    public void setCurrentTimeout(int currentTimeout) {
        this.currentTimeout = currentTimeout;
    }

    public ScheduledFuture<?> getRetransmissionHandle() {
        return this.retransmissionHandle;
    }

    public void setRetransmissionHandle(ScheduledFuture<?> retransmissionHandle) {
        if (this.retransmissionHandle != null) {
            this.retransmissionHandle.cancel(false);
        }
        this.retransmissionHandle = retransmissionHandle;
    }

    public ScheduledFuture<?> getReregistrationHandle() {
        return this.reregistrationHandle;
    }

    public synchronized void setReregistrationHandle(ScheduledFuture<?> reregistrationHandle) {
        if (this.reregistrationHandle != null) {
            this.reregistrationHandle.cancel(false);
        }
        this.reregistrationHandle = reregistrationHandle;
    }

    public void setObserver(ExchangeObserver observer) {
        this.observer = observer;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete() {
        this.complete = true;
        ExchangeObserver obs = this.observer;
        if (obs != null) {
            obs.completed(this);
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public ObserveRelation getRelation() {
        return this.relation;
    }

    public void setRelation(ObserveRelation relation) {
        this.relation = relation;
    }

    public static class KeyUri {
        protected final String uri;
        protected final byte[] address;
        protected final int port;
        private final int hash;

        public KeyUri(String uri, byte[] address, int port) {
            if (uri == null) {
                throw new NullPointerException();
            }
            if (address == null) {
                throw new NullPointerException();
            }
            this.uri = uri;
            this.address = address;
            this.port = port;
            this.hash = (port * 31 + uri.hashCode()) * 31 + Arrays.hashCode(address);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof KeyUri)) {
                return false;
            }
            KeyUri key = (KeyUri)o;
            return this.uri.equals(key.uri) && this.port == key.port && Arrays.equals(this.address, key.address);
        }

        public String toString() {
            return "KeyUri[" + this.uri + " from " + Utils.toHexString(this.address) + ":" + this.port + "]";
        }
    }

    public static final class KeyToken {
        protected final byte[] token;
        protected final byte[] address;
        protected final int port;
        private final int hash;

        public KeyToken(byte[] token, byte[] address, int port) {
            if (address == null) {
                throw new NullPointerException();
            }
            if (token == null) {
                throw new NullPointerException();
            }
            this.token = token;
            this.address = address;
            this.port = port;
            this.hash = (port * 31 + Arrays.hashCode(token)) * 31 + Arrays.hashCode(address);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof KeyToken)) {
                return false;
            }
            KeyToken key = (KeyToken)o;
            return Arrays.equals(this.token, key.token) && this.port == key.port && Arrays.equals(this.address, key.address);
        }

        public String toString() {
            return "KeyToken[" + Utils.toHexString(this.token) + " from " + Utils.toHexString(this.address) + ":" + this.port + "]";
        }
    }

    public static final class KeyMID {
        protected final int MID;
        protected final byte[] address;
        protected final int port;
        private final int hash;

        public KeyMID(int mid, byte[] address, int port) {
            if (address == null) {
                throw new NullPointerException();
            }
            this.MID = mid;
            this.address = address;
            this.port = port;
            this.hash = (port * 31 + this.MID) * 31 + Arrays.hashCode(address);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof KeyMID)) {
                return false;
            }
            KeyMID key = (KeyMID)o;
            return this.MID == key.MID && this.port == key.port && Arrays.equals(this.address, key.address);
        }

        public String toString() {
            return "KeyMID[" + this.MID + " from " + Utils.toHexString(this.address) + ":" + this.port + "]";
        }
    }

    public static enum Origin {
        LOCAL,
        REMOTE;

    }
}

