/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import org.eclipse.californium.core.coap.option.OptionDefinition;
import org.eclipse.californium.core.coap.option.OptionNumber;
import org.eclipse.californium.elements.util.DatagramWriter;

public abstract class Option
implements OptionNumber {
    private final OptionDefinition definition;

    protected Option(OptionDefinition definition) {
        if (definition == null) {
            throw new NullPointerException("Definition must not be null!");
        }
        this.definition = definition;
    }

    public OptionDefinition getDefinition() {
        return this.definition;
    }

    public abstract int getLength();

    @Override
    public int getNumber() {
        return this.definition.getNumber();
    }

    public abstract void writeTo(DatagramWriter var1);

    public byte[] encode() {
        DatagramWriter writer = new DatagramWriter(this.getLength());
        this.writeTo(writer);
        return writer.toByteArray();
    }

    @Override
    public boolean isSingleValue() {
        return this.getDefinition().isSingleValue();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.definition.getName());
        sb.append(": ");
        sb.append(this.toValueString());
        return sb.toString();
    }

    public abstract String toValueString();
}

