/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.OptionsParser;

public final class CBOREncodeOptions {
    public static final CBOREncodeOptions Default = new CBOREncodeOptions();
    public static final CBOREncodeOptions DefaultCtap2Canonical = new CBOREncodeOptions("ctap2canonical=true");
    private final boolean propVarresolvereferences;
    private final boolean propVaruseindeflengthstrings;
    private final boolean propVarkeepkeyorder;
    private final boolean propVarallowempty;
    private final boolean propVarallowduplicatekeys;
    private final boolean propVarfloat64;
    private final boolean propVarctap2canonical;

    public CBOREncodeOptions() {
        this("");
    }

    @Deprecated
    public CBOREncodeOptions(boolean useIndefLengthStrings, boolean allowDuplicateKeys) {
        this(useIndefLengthStrings, allowDuplicateKeys, false);
    }

    @Deprecated
    public CBOREncodeOptions(boolean useIndefLengthStrings, boolean allowDuplicateKeys, boolean ctap2Canonical) {
        this.propVarresolvereferences = false;
        this.propVarallowempty = false;
        this.propVarfloat64 = false;
        this.propVarkeepkeyorder = false;
        this.propVaruseindeflengthstrings = useIndefLengthStrings;
        this.propVarallowduplicatekeys = allowDuplicateKeys;
        this.propVarctap2canonical = ctap2Canonical;
    }

    public CBOREncodeOptions(String paramString) {
        if (paramString == null) {
            throw new NullPointerException("paramString");
        }
        OptionsParser parser = new OptionsParser(paramString);
        this.propVarresolvereferences = parser.GetBoolean("resolvereferences", false);
        this.propVaruseindeflengthstrings = parser.GetBoolean("useindeflengthstrings", false);
        this.propVarfloat64 = parser.GetBoolean("float64", false);
        this.propVarallowduplicatekeys = parser.GetBoolean("allowduplicatekeys", false);
        this.propVarkeepkeyorder = parser.GetBoolean("keepkeyorder", false);
        this.propVarallowempty = parser.GetBoolean("allowempty", false);
        this.propVarctap2canonical = parser.GetBoolean("ctap2canonical", false);
    }

    public String toString() {
        return "allowduplicatekeys=" + (this.getAllowDuplicateKeys() ? "true" : "false") + ";useindeflengthstrings=" + (this.getUseIndefLengthStrings() ? "true" : "false") + ";float64=" + (this.getFloat64() ? "true" : "false") + ";ctap2canonical=" + (this.getCtap2Canonical() ? "true" : "false") + ";keepkeyorder=" + (this.getKeepKeyOrder() ? "true" : "false") + ";resolvereferences=" + (this.getResolveReferences() ? "true" : "false") + ";allowempty=" + (this.getAllowEmpty() ? "true" : "false");
    }

    public final boolean getResolveReferences() {
        return this.propVarresolvereferences;
    }

    public final boolean getUseIndefLengthStrings() {
        return this.propVaruseindeflengthstrings;
    }

    public final boolean getKeepKeyOrder() {
        return this.propVarkeepkeyorder;
    }

    public final boolean getAllowEmpty() {
        return this.propVarallowempty;
    }

    public final boolean getAllowDuplicateKeys() {
        return this.propVarallowduplicatekeys;
    }

    public final boolean getFloat64() {
        return this.propVarfloat64;
    }

    public final boolean getCtap2Canonical() {
        return this.propVarctap2canonical;
    }
}

