/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.Definition;
import org.eclipse.californium.elements.Definitions;
import org.eclipse.californium.elements.DefinitionsEndpointContextMatcher;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.UdpEndpointContext;
import org.eclipse.californium.elements.util.NetworkInterfacesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpEndpointContextMatcher
extends DefinitionsEndpointContextMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpEndpointContextMatcher.class);
    private static final Definitions<Definition<?>> DEFINITIONS = new Definitions<Definition<String>>("udp context").add(UdpEndpointContext.KEY_PLAIN);
    public static final String MULTICAST_IDENTITY = "MULTICAST";
    private final boolean checkAddress;

    public UdpEndpointContextMatcher() {
        this(true);
    }

    public UdpEndpointContextMatcher(boolean checkAddress) {
        super(DEFINITIONS);
        this.checkAddress = checkAddress;
    }

    @Override
    public Object getEndpointIdentity(EndpointContext context) {
        InetSocketAddress address;
        Object identity = super.getEndpointIdentity(context);
        if (identity instanceof InetSocketAddress && NetworkInterfacesUtil.isMultiAddress((address = (InetSocketAddress)identity).getAddress())) {
            return MULTICAST_IDENTITY;
        }
        return identity;
    }

    @Override
    public boolean isResponseRelatedToRequest(EndpointContext requestContext, EndpointContext responseContext) {
        InetSocketAddress peerAddress2;
        InetSocketAddress peerAddress1;
        if (this.checkAddress && !(peerAddress1 = requestContext.getPeerAddress()).equals(peerAddress2 = responseContext.getPeerAddress()) && !NetworkInterfacesUtil.isMultiAddress(peerAddress1.getAddress())) {
            LOGGER.info("request {}:{} doesn't match {}:{}!", peerAddress1.getAddress().getHostAddress(), peerAddress1.getPort(), peerAddress2.getAddress().getHostAddress(), peerAddress2.getPort());
            return false;
        }
        return super.isResponseRelatedToRequest(requestContext, responseContext);
    }
}

