/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.server.resources;

import java.util.List;
import java.util.Set;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.WebLink;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.LinkFormat;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.Resource;

public class DiscoveryResource
extends CoapResource {
    public static final String CORE = "core";
    private final Resource root;

    public DiscoveryResource(Resource root) {
        this(CORE, root);
    }

    public DiscoveryResource(String name, Resource root) {
        super(name);
        this.setVisible(false);
        this.addSupportedContentFormats(40);
        this.root = root;
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        List<String> query = exchange.getRequestOptions().getUriQueryStrings();
        if (query.size() > 1) {
            exchange.respond(CoAP.ResponseCode.BAD_OPTION, "only one search query is supported!", 0);
            return;
        }
        String tree = this.discoverTree(this.root, query);
        exchange.respond(CoAP.ResponseCode.CONTENT, tree, 40);
    }

    public String discoverTree(Resource root, List<String> queries) {
        Set<WebLink> subTree = LinkFormat.getSubTree(root, queries);
        return LinkFormat.serialize(subTree);
    }
}

