/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;

public final class HelloVerifyRequest
extends HandshakeMessage {
    private static final int VERSION_BITS = 8;
    private static final int COOKIE_LENGTH_BITS = 8;
    private final ProtocolVersion serverVersion;
    private final byte[] cookie;

    public HelloVerifyRequest(ProtocolVersion version, byte[] cookie) {
        this.serverVersion = version;
        this.cookie = cookie;
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter(this.cookie.length + 3);
        writer.write(this.serverVersion.getMajor(), 8);
        writer.write(this.serverVersion.getMinor(), 8);
        writer.writeVarBytes(this.cookie, 8);
        return writer.toByteArray();
    }

    public static HandshakeMessage fromReader(DatagramReader reader) {
        int major = reader.read(8);
        int minor = reader.read(8);
        ProtocolVersion version = ProtocolVersion.valueOf(major, minor);
        byte[] cookie = reader.readVarBytes(8);
        return new HelloVerifyRequest(version, cookie);
    }

    @Override
    public HandshakeType getMessageType() {
        return HandshakeType.HELLO_VERIFY_REQUEST;
    }

    @Override
    public int getMessageLength() {
        return 3 + this.cookie.length;
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(indent));
        String indentation = StringUtil.indentation(indent + 1);
        sb.append(indentation).append("Server Version: ").append(this.serverVersion.getMajor()).append(", ").append(this.serverVersion.getMinor()).append(StringUtil.lineSeparator());
        sb.append(indentation).append("Cookie Length: ").append(this.cookie.length).append(" bytes").append(StringUtil.lineSeparator());
        sb.append(indentation).append("Cookie: ").append(StringUtil.byteArray2HexString(this.cookie)).append(StringUtil.lineSeparator());
        return sb.toString();
    }
}

