/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap.option;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionNumberRegistry;
import org.eclipse.californium.core.coap.option.BaseOptionDefinition;

public class StringOptionDefinition
extends BaseOptionDefinition {
    public StringOptionDefinition(int number, String name) {
        this(number, name, true, null);
    }

    public StringOptionDefinition(int number, String name, boolean singleValue) {
        this(number, name, singleValue, null);
    }

    public StringOptionDefinition(int number, String name, boolean singleValue, int ... lengths) {
        super(number, name, OptionNumberRegistry.OptionFormat.STRING, singleValue, lengths);
    }

    @Override
    public Option create(String value) {
        return new Option(this, value);
    }

    public static String getStringValue(byte[] value) {
        return new String(value, CoAP.UTF8_CHARSET);
    }

    public static byte[] setStringValue(String value) {
        return value.getBytes(CoAP.UTF8_CHARSET);
    }
}

