/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

public class ClockUtil {
    private static volatile Realtime handler = new Realtime(){

        @Override
        public long nanoRealtime() {
            return System.nanoTime();
        }
    };

    public static void setRealtimeHandler(Realtime systemHandler) {
        if (systemHandler == null) {
            throw new NullPointerException("realtime system handler must not be null!");
        }
        handler = systemHandler;
    }

    public static long nanoRealtime() {
        return handler.nanoRealtime();
    }

    public static interface Realtime {
        public long nanoRealtime();
    }
}

