/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.config;

import java.util.List;

public class DefinitionUtils {
    public static <E extends Enum<?>> Class<E> getClass(E[] list) {
        if (list == null) {
            throw new NullPointerException("Enums must not be null!");
        }
        if (list.length == 0) {
            throw new IllegalArgumentException("Enums must not be empty!");
        }
        return list[0].getClass();
    }

    public static String toString(List<String> list, boolean brackets) {
        if (list == null) {
            throw new NullPointerException("List must not be null!");
        }
        StringBuilder message = new StringBuilder();
        if (brackets) {
            message.append('[');
        }
        for (String in : list) {
            message.append(in).append(", ");
        }
        message.setLength(message.length() - 2);
        if (brackets) {
            message.append(']');
        }
        return message.toString();
    }

    public static <E extends Enum<?>> String toNames(List<E> list, boolean brackets) {
        if (list == null) {
            throw new NullPointerException("List must not be null!");
        }
        StringBuilder message = new StringBuilder();
        if (brackets) {
            message.append('[');
        }
        for (Enum in : list) {
            message.append(in.name()).append(", ");
        }
        message.setLength(message.length() - 2);
        if (brackets) {
            message.append(']');
        }
        return message.toString();
    }

    public static <E extends Enum<?>> E toValue(String text, List<E> values) {
        if (text == null) {
            throw new NullPointerException("Text must not be null!");
        }
        if (values == null) {
            throw new NullPointerException("values must not be null!");
        }
        for (Enum in : values) {
            if (!in.name().equals(text)) continue;
            return (E)in;
        }
        return null;
    }
}

