/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.SimpleCounterStatistic;
import org.eclipse.californium.elements.util.StringUtil;

public abstract class CounterStatisticManager {
    protected final SimpleCounterStatistic.AlignGroup align = new SimpleCounterStatistic.AlignGroup();
    private final ConcurrentMap<String, SimpleCounterStatistic> statistics = new ConcurrentHashMap<String, SimpleCounterStatistic>();
    private final List<String> orderedKeys = new CopyOnWriteArrayList<String>();
    protected final String tag;
    private final ScheduledExecutorService executor;
    private final long interval;
    private final TimeUnit unit;
    private ScheduledFuture<?> taskHandle;
    private AtomicBoolean running = new AtomicBoolean();
    private AtomicLong lastTransfer = new AtomicLong(ClockUtil.nanoRealtime());

    protected CounterStatisticManager(String tag) {
        this.tag = StringUtil.normalizeLoggingTag(tag);
        this.interval = 0L;
        this.unit = null;
        this.executor = null;
    }

    protected CounterStatisticManager(String tag, long interval, TimeUnit unit, ScheduledExecutorService executor) {
        if (executor == null) {
            throw new NullPointerException("executor must not be null!");
        }
        this.tag = StringUtil.normalizeLoggingTag(tag);
        if (this.isEnabled()) {
            this.interval = interval;
            this.unit = unit;
            this.executor = interval > 0L ? executor : null;
        } else {
            this.interval = 0L;
            this.unit = null;
            this.executor = null;
        }
    }

    protected void add(String head, SimpleCounterStatistic statistic) {
        this.addByKey(head + statistic.getName(), statistic);
    }

    protected void add(SimpleCounterStatistic statistic) {
        this.addByKey(statistic.getName(), statistic);
    }

    protected void addByKey(String key, SimpleCounterStatistic statistic) {
        SimpleCounterStatistic previous = this.statistics.put(key, statistic);
        if (previous != null) {
            this.orderedKeys.remove(key);
        }
        this.orderedKeys.add(key);
    }

    protected void removeByKey(String key, SimpleCounterStatistic statistic) {
        if (this.statistics.remove(key, statistic)) {
            this.orderedKeys.remove(key);
        }
    }

    protected void removeByKey(String key) {
        if (this.statistics.containsKey(key)) {
            this.statistics.remove(key);
            this.orderedKeys.remove(key);
        }
    }

    protected SimpleCounterStatistic get(String name) {
        return (SimpleCounterStatistic)this.statistics.get(name);
    }

    public SimpleCounterStatistic getByKey(String key) {
        return (SimpleCounterStatistic)this.statistics.get(key);
    }

    public List<String> getKeys() {
        return Collections.unmodifiableList(this.orderedKeys);
    }

    public List<String> getKeys(Principal principal) {
        return Collections.unmodifiableList(this.orderedKeys);
    }

    public abstract boolean isEnabled();

    public synchronized void start() {
        if (this.executor != null && this.taskHandle == null) {
            this.running.set(true);
            this.taskHandle = this.executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (CounterStatisticManager.this.running.get()) {
                        CounterStatisticManager.this.dump();
                    }
                }
            }, this.interval, this.interval, this.unit);
        }
    }

    public synchronized boolean stop() {
        if (this.taskHandle != null) {
            this.running.set(false);
            this.taskHandle.cancel(false);
            this.taskHandle = null;
            return true;
        }
        return false;
    }

    public abstract void dump();

    public long getLastTransferTime() {
        return this.lastTransfer.get();
    }

    public void transferCounter() {
        for (SimpleCounterStatistic statistic : this.statistics.values()) {
            statistic.transferCounter();
        }
        this.lastTransfer.set(ClockUtil.nanoRealtime());
    }

    public void reset() {
        for (SimpleCounterStatistic statistic : this.statistics.values()) {
            statistic.reset();
        }
        this.lastTransfer.set(ClockUtil.nanoRealtime());
    }

    public long getCounter(String name) {
        return this.getByKey(name).getCounter();
    }

    public long getCounterByKey(String key) {
        return this.getByKey(key).getCounter();
    }

    public String getTag() {
        return this.tag;
    }
}

