/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.oscore;

import java.util.Arrays;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.oscore.CoapOSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OscoreOptionDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(OscoreOptionDecoder.class);
    private byte[] encodedBytes;
    private byte[] idContext;
    private byte[] partialIV;
    private byte[] kid;
    private int n;
    private int k;
    private int h;

    public OscoreOptionDecoder(byte[] encodedBytes) throws CoapOSException {
        this.encodedBytes = encodedBytes;
        this.decode();
    }

    public void setBytes(byte[] encodedBytes) throws CoapOSException {
        this.encodedBytes = encodedBytes;
        this.decode();
    }

    private void decode() throws CoapOSException {
        byte[] total = this.encodedBytes;
        if (total.length == 0) {
            total = new byte[]{0};
        }
        byte flagByte = total[0];
        int n = flagByte & 7;
        int k = (flagByte & 8) >> 3;
        int h = (flagByte & 0x10) >> 4;
        byte[] partialIV = null;
        byte[] kid = null;
        byte[] kidContext = null;
        int index = 1;
        try {
            if (n > 0) {
                partialIV = Arrays.copyOfRange(total, index, index + n);
                index += n;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse Partial IV in OSCORE option.");
            throw new CoapOSException("Failed to decode COSE", CoAP.ResponseCode.BAD_OPTION);
        }
        try {
            if (h != 0) {
                byte s = total[index++];
                kidContext = Arrays.copyOfRange(total, index, index + s);
                index += s;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse KID Context in OSCORE option.");
            throw new CoapOSException("Failed to decode COSE", CoAP.ResponseCode.BAD_OPTION);
        }
        try {
            if (k != 0) {
                kid = Arrays.copyOfRange(total, index, total.length);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse KID in OSCORE option.");
            throw new CoapOSException("Failed to decode COSE", CoAP.ResponseCode.BAD_OPTION);
        }
        if (k == 0 && index != total.length) {
            LOGGER.error("Extranous data at end of OSCORE option.");
            throw new CoapOSException("Failed to decode COSE", CoAP.ResponseCode.BAD_OPTION);
        }
        this.n = n;
        this.k = k;
        this.h = h;
        this.partialIV = partialIV;
        this.kid = kid;
        this.idContext = kidContext;
    }

    public byte[] getIdContext() {
        return this.idContext;
    }

    public byte[] getPartialIV() {
        return this.partialIV;
    }

    public int getSequenceNumber() {
        if (this.partialIV == null) {
            return 0;
        }
        return new DatagramReader(this.partialIV, false).read(this.partialIV.length * 8);
    }

    public byte[] getKid() {
        return this.kid;
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }

    public int getH() {
        return this.h;
    }
}

