/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap.option;

import java.util.Arrays;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionNumberRegistry;
import org.eclipse.californium.core.coap.option.IntegerOptionDefinition;
import org.eclipse.californium.core.coap.option.MapBasedOptionRegistry;
import org.eclipse.californium.core.coap.option.OptionDefinition;
import org.eclipse.californium.core.coap.option.OptionRegistry;
import org.eclipse.californium.core.coap.option.StringOptionDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LegacyMapBasedOptionRegistry
extends MapBasedOptionRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegacyMapBasedOptionRegistry.class);
    private final boolean supportUndefinedOptions;
    private final int[] criticalCustomOptions;
    private final OptionNumberRegistry.CustomOptionNumberRegistry customOptionNumberRegistry;

    public LegacyMapBasedOptionRegistry(boolean supportUndefinedOptions, int[] criticalCustomOptions, OptionRegistry ... registries) {
        super(new OptionDefinition[0]);
        this.supportUndefinedOptions = supportUndefinedOptions;
        this.customOptionNumberRegistry = LegacyMapBasedOptionRegistry.getCustomOptionNumberRegistry(registries);
        if (this.customOptionNumberRegistry != null && criticalCustomOptions == null) {
            criticalCustomOptions = this.customOptionNumberRegistry.getCriticalCustomOptions();
        }
        if (criticalCustomOptions != null) {
            this.criticalCustomOptions = (int[])criticalCustomOptions.clone();
            Arrays.sort(this.criticalCustomOptions);
        } else {
            this.criticalCustomOptions = null;
        }
        for (OptionRegistry registry : registries) {
            this.add(registry);
        }
    }

    public LegacyMapBasedOptionRegistry(boolean supportUndefinedOptions, OptionNumberRegistry.CustomOptionNumberRegistry customOptionNumberRegistry, OptionRegistry ... registries) {
        super(new OptionDefinition[0]);
        int[] criticalCustomOptions = null;
        this.supportUndefinedOptions = supportUndefinedOptions;
        if (customOptionNumberRegistry != null) {
            this.customOptionNumberRegistry = customOptionNumberRegistry;
            criticalCustomOptions = this.customOptionNumberRegistry.getCriticalCustomOptions();
        } else {
            this.customOptionNumberRegistry = LegacyMapBasedOptionRegistry.getCustomOptionNumberRegistry(registries);
            if (this.customOptionNumberRegistry != null) {
                criticalCustomOptions = this.customOptionNumberRegistry.getCriticalCustomOptions();
            }
        }
        if (criticalCustomOptions != null) {
            this.criticalCustomOptions = (int[])criticalCustomOptions.clone();
            Arrays.sort(this.criticalCustomOptions);
        } else {
            this.criticalCustomOptions = null;
        }
        for (OptionRegistry registry : registries) {
            this.add(registry);
        }
    }

    private boolean isSupportedCiriticalCustomOption(int optionNumber) {
        return this.criticalCustomOptions == null || Arrays.binarySearch(this.criticalCustomOptions, optionNumber) >= 0;
    }

    @Override
    public void add(OptionRegistry registry) {
        super.add(registry);
    }

    @Override
    public void put(OptionDefinition definition) {
        super.put(definition);
    }

    @Override
    protected OptionDefinition getCustomDefinition(int optionNumber) {
        String name;
        boolean add = false;
        OptionDefinition definition = null;
        if (this.customOptionNumberRegistry != null && this.customOptionNumberRegistry.toNumber(name = this.customOptionNumberRegistry.toString(optionNumber)) != -1) {
            definition = new CustomOptionDefinition(optionNumber, this.customOptionNumberRegistry);
            add = true;
        }
        if (definition == null && this.supportUndefinedOptions && (!OptionNumberRegistry.isCritical(optionNumber) || this.isSupportedCiriticalCustomOption(optionNumber))) {
            definition = new UnspecificOptionDefinition(optionNumber);
        }
        if (add) {
            try {
                this.put(definition);
                LOGGER.debug("{}/{} added.", (Object)definition.getNumber(), (Object)definition.getName());
            }
            catch (IllegalArgumentException ex) {
                return super.getInternal(optionNumber);
            }
        }
        return definition;
    }

    @Override
    public boolean contains(OptionDefinition definition) {
        if (super.contains(definition)) {
            return true;
        }
        if (this.supportUndefinedOptions) {
            return definition instanceof UnspecificOptionDefinition;
        }
        return false;
    }

    private static OptionNumberRegistry.CustomOptionNumberRegistry getCustomOptionNumberRegistry(OptionRegistry ... registries) {
        OptionNumberRegistry.CustomOptionNumberRegistry customRegistry = null;
        for (OptionRegistry registry : registries) {
            if (!(registry instanceof LegacyMapBasedOptionRegistry)) continue;
            if (customRegistry == null) {
                customRegistry = ((LegacyMapBasedOptionRegistry)registry).customOptionNumberRegistry;
                continue;
            }
            if (customRegistry == ((LegacyMapBasedOptionRegistry)registry).customOptionNumberRegistry) continue;
            throw new IllegalArgumentException("Ambiguous custom registry");
        }
        return customRegistry;
    }

    private static class CustomOptionDefinition
    extends UnspecificOptionDefinition {
        private final OptionNumberRegistry.CustomOptionNumberRegistry customOptionNumberRegistry;

        private CustomOptionDefinition(int optionNumber, OptionNumberRegistry.CustomOptionNumberRegistry customOptionNumberRegistry) {
            super(optionNumber, customOptionNumberRegistry.toString(optionNumber));
            this.customOptionNumberRegistry = customOptionNumberRegistry;
        }

        @Override
        public OptionNumberRegistry.OptionFormat getFormat() {
            return this.customOptionNumberRegistry.getFormatByNr(this.getNumber());
        }

        @Override
        public boolean isSingleValue() {
            return this.customOptionNumberRegistry.isSingleValue(this.getNumber());
        }

        @Override
        public void assertValue(byte[] value) {
            super.assertValue(value);
            if (this.getFormat() == OptionNumberRegistry.OptionFormat.INTEGER) {
                long numberValue = IntegerOptionDefinition.getLongValue(value);
                this.customOptionNumberRegistry.assertValue(this.getNumber(), numberValue);
            }
        }

        @Override
        public int[] getValueLengths() {
            int[] lengths = this.customOptionNumberRegistry.getValueLengths(this.getNumber());
            if (lengths == null) {
                lengths = super.getValueLengths();
            }
            return lengths;
        }

        @Override
        public String getName() {
            return this.customOptionNumberRegistry.toString(this.getNumber());
        }
    }

    private static class UnspecificOptionDefinition
    implements OptionDefinition {
        private static final int[] LENGTHS = new int[]{0, 65804};
        private final int optionNumber;
        private final String name;

        protected UnspecificOptionDefinition(int optionNumber) {
            this(optionNumber, String.format("Unknown (%d)", optionNumber));
        }

        protected UnspecificOptionDefinition(int optionNumber, String name) {
            this.optionNumber = optionNumber;
            this.name = name;
        }

        @Override
        public OptionNumberRegistry.OptionFormat getFormat() {
            return OptionNumberRegistry.OptionFormat.UNKNOWN;
        }

        @Override
        public boolean isSingleValue() {
            return true;
        }

        @Override
        public void assertValue(byte[] value) {
            int max;
            int valueLength = value.length;
            int[] lengths = this.getValueLengths();
            int min = lengths[0];
            int n = max = lengths.length == 1 ? min : lengths[1];
            if (valueLength < min || valueLength > max) {
                if (min == max) {
                    if (min == 0) {
                        throw new IllegalArgumentException("Option " + this.getName() + " value of " + valueLength + " bytes must be empty.");
                    }
                    throw new IllegalArgumentException("Option " + this.getName() + " value of " + valueLength + " bytes must be " + min + " bytes.");
                }
                throw new IllegalArgumentException("Option " + this.getName() + " value of " + valueLength + " bytes must be in range of [" + min + "-" + max + "] bytes.");
            }
        }

        @Override
        public int[] getValueLengths() {
            return LENGTHS;
        }

        @Override
        public int getNumber() {
            return this.optionNumber;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Option create(byte[] value) {
            return new Option(this, value);
        }

        @Override
        public Option create(String value) {
            return this.create(StringOptionDefinition.setStringValue(value));
        }

        @Override
        public Option create(long value) {
            return this.create(IntegerOptionDefinition.setLongValue(value));
        }

        public int hashCode() {
            return this.getNumber() + 0x1000000;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (!(obj instanceof UnspecificOptionDefinition)) {
                return false;
            }
            UnspecificOptionDefinition other = (UnspecificOptionDefinition)obj;
            return this.getNumber() == other.getNumber() && this.getName().equals(other.getName());
        }
    }
}

