/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Logger;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.stack.Layer;

public abstract class AbstractLayer
implements Layer {
    protected static final Logger LOGGER = Logger.getLogger(AbstractLayer.class.getCanonicalName());
    private Layer upperLayer;
    private Layer lowerLayer;
    protected ScheduledExecutorService executor;

    @Override
    public void sendRequest(Exchange exchange, Request request) {
        if (this.lowerLayer != null) {
            this.lowerLayer.sendRequest(exchange, request);
        } else {
            LOGGER.severe("No lower layer found to send request " + request);
        }
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        if (this.lowerLayer != null) {
            this.lowerLayer.sendResponse(exchange, response);
        } else {
            LOGGER.severe("No lower layer found to send response " + response);
        }
    }

    @Override
    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        if (this.lowerLayer != null) {
            this.lowerLayer.sendEmptyMessage(exchange, message);
        } else {
            LOGGER.severe("No lower layer found to send empty message " + message + " for exchange " + exchange);
        }
    }

    @Override
    public void receiveRequest(Exchange exchange, Request request) {
        if (this.upperLayer != null) {
            this.upperLayer.receiveRequest(exchange, request);
        } else {
            LOGGER.severe("No upper layer found to receive request " + request + " for exchange " + exchange);
        }
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        if (this.upperLayer != null) {
            this.upperLayer.receiveResponse(exchange, response);
        } else {
            LOGGER.severe("No upper layer found to receive response " + response + " for exchange " + exchange);
        }
    }

    @Override
    public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        if (this.upperLayer != null) {
            this.upperLayer.receiveEmptyMessage(exchange, message);
        } else {
            LOGGER.severe("No upper layer found to receive empty message " + message + " for exchange " + exchange);
        }
    }

    @Override
    public void setLowerLayer(Layer layer) {
        if (this.lowerLayer != layer) {
            if (this.lowerLayer != null) {
                this.lowerLayer.setUpperLayer(null);
            }
            this.lowerLayer = layer;
            this.lowerLayer.setUpperLayer(this);
        }
    }

    @Override
    public void setUpperLayer(Layer layer) {
        if (this.upperLayer != layer) {
            if (this.upperLayer != null) {
                this.upperLayer.setLowerLayer(null);
            }
            this.upperLayer = layer;
            this.upperLayer.setLowerLayer(this);
        }
    }

    @Override
    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public void reject(Exchange exchange, Message message) {
        if (message.getType() == CoAP.Type.ACK || message.getType() == CoAP.Type.RST) {
            throw new IllegalArgumentException("Rejecting an " + (Object)((Object)message.getType()) + " is not allowed");
        }
        this.sendEmptyMessage(exchange, EmptyMessage.newRST(message));
    }
}

