/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;

public class Response
extends Message {
    private final CoAP.ResponseCode code;
    private long rtt;
    private boolean last = true;

    public Response(CoAP.ResponseCode code) {
        this.code = code;
    }

    public CoAP.ResponseCode getCode() {
        return this.code;
    }

    public String toString() {
        String payload = this.getPayloadString();
        if (payload == null) {
            payload = "no payload";
        } else {
            int len = payload.length();
            if (payload.indexOf("\n") != -1) {
                payload = payload.substring(0, payload.indexOf("\n"));
            }
            if (payload.length() > 24) {
                payload = payload.substring(0, 20);
            }
            if ((payload = "\"" + payload + "\"").length() != len + 2) {
                payload = payload + ".. " + payload.length() + " bytes";
            }
        }
        return String.format("%s-%-6s MID=%5d, Token=[%s], %s, %s", new Object[]{this.getType(), this.getCode(), this.getMID(), this.getTokenString(), this.getOptions(), payload});
    }

    public static Response createPiggybackedResponse(Request request, CoAP.ResponseCode code) {
        Response response = new Response(code);
        response.setMID(request.getMID());
        response.setType(CoAP.Type.ACK);
        response.setDestination(request.getSource());
        response.setDestinationPort(request.getSourcePort());
        response.setToken(request.getToken());
        return response;
    }

    public static Response createSeparateResponse(Request request, CoAP.ResponseCode code) {
        Response response = new Response(code);
        response.setDestination(request.getSource());
        response.setDestinationPort(request.getSourcePort());
        response.setToken(request.getToken());
        return response;
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public long getRTT() {
        return this.rtt;
    }

    public void setRTT(long rtt) {
        this.rtt = rtt;
    }
}

