/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.oscore;

import com.upokecenter.cbor.CBORObject;
import java.nio.ByteBuffer;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.cose.CoseException;
import org.eclipse.californium.cose.Encrypt0Message;
import org.eclipse.californium.cose.HeaderKeys;
import org.eclipse.californium.oscore.ContextRederivation;
import org.eclipse.californium.oscore.OSCoreCtx;
import org.eclipse.californium.oscore.OSException;
import org.eclipse.californium.oscore.OSSerializer;
import org.eclipse.californium.oscore.OptionJuggle;
import org.eclipse.californium.oscore.OscoreOptionDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Decryptor {
    public static final int INTEGER_BYTES = 4;
    private static final Logger LOGGER = LoggerFactory.getLogger(Decryptor.class);
    protected static final OptionSet EMPTY = new OptionSet();

    protected static byte[] decryptAndDecode(Encrypt0Message enc, Message message, OSCoreCtx ctx, Integer seqByToken) throws OSException {
        CBORObject piv;
        int seq = -2;
        boolean isRequest = message instanceof Request;
        byte[] nonce = null;
        byte[] partialIV = null;
        byte[] aad = null;
        if (isRequest) {
            piv = enc.findAttribute(HeaderKeys.PARTIAL_IV);
            if (piv == null) {
                LOGGER.error("Decryption failed: no partialIV in request");
                throw new OSException("Decryption failed");
            }
            partialIV = piv.GetByteString();
            partialIV = Decryptor.expandToIntSize(partialIV);
            seq = ByteBuffer.wrap(partialIV).getInt();
            ctx.checkIncomingSeq(seq);
            nonce = OSSerializer.nonceGeneration(partialIV, ctx.getRecipientId(), ctx.getCommonIV(), ctx.getIVLength());
            aad = OSSerializer.serializeAAD(1, ctx.getAlg(), seq, ctx.getRecipientId(), message.getOptions());
        } else {
            if (seqByToken == null) {
                LOGGER.error("Decryption failed: the arrived response is not connected to a request we sent");
                throw new OSException("Decryption failed");
            }
            piv = enc.findAttribute(HeaderKeys.PARTIAL_IV);
            seq = seqByToken;
            if (piv == null) {
                partialIV = ByteBuffer.allocate(4).putInt(seq).array();
                nonce = OSSerializer.nonceGeneration(partialIV, ctx.getSenderId(), ctx.getCommonIV(), ctx.getIVLength());
            } else {
                partialIV = piv.GetByteString();
                partialIV = Decryptor.expandToIntSize(partialIV);
                nonce = OSSerializer.nonceGeneration(partialIV, ctx.getRecipientId(), ctx.getCommonIV(), ctx.getIVLength());
            }
            aad = OSSerializer.serializeAAD(1, ctx.getAlg(), seq, ctx.getSenderId(), message.getOptions());
        }
        if (ctx.getContextRederivationPhase() == ContextRederivation.PHASE.SERVER_PHASE_1) {
            ctx.setNonceHandover(nonce);
        } else if (ctx.getContextRederivationPhase() == ContextRederivation.PHASE.CLIENT_PHASE_2 && ctx.getNonceHandover() != null) {
            nonce = ctx.getNonceHandover();
        }
        byte[] plaintext = null;
        byte[] key = ctx.getRecipientKey();
        enc.setExternal(aad);
        try {
            enc.addAttribute(HeaderKeys.Algorithm, ctx.getAlg().AsCBOR(), 4);
            enc.addAttribute(HeaderKeys.IV, CBORObject.FromObject(nonce), 4);
            plaintext = enc.decrypt(key);
        }
        catch (CoseException e) {
            String details = "Decryption failed " + e.getMessage();
            LOGGER.error(details);
            throw new OSException(details);
        }
        return plaintext;
    }

    private static byte[] expandToIntSize(byte[] partialIV) throws OSException {
        if (partialIV.length > 4) {
            LOGGER.error("The partial IV is: {} long, {} was expected", (Object)partialIV.length, (Object)4);
            throw new OSException("Partial IV too long");
        }
        if (partialIV.length == 4) {
            return partialIV;
        }
        byte[] ret = new byte[4];
        for (int i = 0; i < partialIV.length; ++i) {
            ret[4 - partialIV.length + i] = partialIV[i];
        }
        return ret;
    }

    protected static Encrypt0Message prepareCOSEStructure(byte[] protectedData) {
        Encrypt0Message enc = new Encrypt0Message(false, true);
        try {
            enc.DecodeFromCBORObject(CBORObject.DecodeFromBytes(protectedData));
        }
        catch (CoseException e) {
            e.printStackTrace();
        }
        return enc;
    }

    protected static Encrypt0Message decompression(byte[] cipherText, Message message) throws OSException {
        Encrypt0Message enc = new Encrypt0Message(false, true);
        try {
            Decryptor.decodeObjectSecurity(message, enc);
        }
        catch (OSException e) {
            LOGGER.error(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Failed to decode object security option.");
            throw new OSException("Failed to decode object security option.");
        }
        if (cipherText != null) {
            enc.setEncryptedContent(cipherText);
        }
        return enc;
    }

    private static void decodeObjectSecurity(Message message, Encrypt0Message enc) throws OSException {
        OscoreOptionDecoder optionDecoder = new OscoreOptionDecoder(message.getOptions().getOscore());
        int n = optionDecoder.getN();
        int k = optionDecoder.getK();
        int h = optionDecoder.getH();
        byte[] partialIV = optionDecoder.getPartialIV();
        byte[] kid = optionDecoder.getKid();
        byte[] kidContext = optionDecoder.getIdContext();
        if (n > 0 && partialIV == null) {
            LOGGER.error("Partial_IV is missing from message when it is expected.");
            throw new OSException("Failed to decode COSE");
        }
        if (h != 0 && kidContext == null) {
            LOGGER.error("Kid context is missing from message when it is expected.");
            throw new OSException("Failed to decode COSE");
        }
        if (k != 0 && kid == null && message instanceof Request) {
            LOGGER.error("Kid is missing from message when it is expected.");
            throw new OSException("Failed to decode COSE");
        }
        try {
            if (partialIV != null) {
                enc.addAttribute(HeaderKeys.PARTIAL_IV, CBORObject.FromObject(partialIV), 2);
            }
            if (kid != null) {
                enc.addAttribute(HeaderKeys.KID, CBORObject.FromObject(kid), 2);
            }
            int kidContextKey = 10;
            if (kidContext != null) {
                enc.addAttribute(CBORObject.FromObject(kidContextKey), CBORObject.FromObject(kidContext), 2);
            }
        }
        catch (CoseException e) {
            LOGGER.error("COSE processing of message failed.");
            e.printStackTrace();
        }
    }

    protected static void discardEOptions(Message message) {
        OptionSet newOptions = OptionJuggle.discardEOptions(message.getOptions());
        message.setOptions(newOptions);
    }
}

